function [psi,dpsi_dx] = eval_psi(x,~,~,model,gauss)
% function [psi] = eval_psi(x,[],[],model,whichgrid)
%#codegen

if ~gauss
    psi = model.psi.Lam * x(model.psi.xind,:);
else
    psi = model.psi.Lamgauss * x(model.psi.xind,:);
end

if nargout>1
    dpsi_dx = zeros(numel(psi),numel(x));
    if ~gauss
        dpsi_dx(:,model.psi.xind) = model.psi.Lam;
    else
        dpsi_dx(:,model.psi.xind) = model.psi.Lamgauss;
    end
end


return
