function [nitot,dnitot_dx] = eval_nitot(x,g,v,model,gauss)
% function [nitot] = eval_nitot(x,g,v,model)
% total number of ions (incl impurities)
%#codegen

if nargout>1
  [ni,dni_dx] = eval_ni(x,g,v,model,gauss);
  [n1,dn1_dx] = eval_n1(x,g,v,model,gauss);
  [n2,dn2_dx] = eval_n2(x,g,v,model,gauss);
  [n3,dn3_dx] = eval_n3(x,g,v,model,gauss);
  dnitot_dx = dni_dx + dn1_dx + dn2_dx + dn3_dx;
else
  [ni] = eval_ni(x,g,v,model,gauss);
  [n1] = eval_n1(x,g,v,model,gauss);
  [n2] = eval_n2(x,g,v,model,gauss);
  [n3] = eval_n3(x,g,v,model,gauss);
end

nitot = ni+n1+n2+n3;


return
