function [niint,dniint_dx] = eval_niint(x,g,v,model)
% function [niint,dniint_dx] = eval_niint(x,g,v,model)
% integral of total amount of ions (incl thermal impurities)
%#codegen

if nargout>1
    der = true; % compute derivative
else
    der = false;
end

[nitot,dnitot_dx] = eval_nitot(x,g,v,model,true);
geop = geometry_profiles(g,0*g,model);
niint = int_Vtot(nitot,geop,model); % total plasma thermal energy

if der
    dniint_dx = int_Vtot(dnitot_dx);
end

return
