function [h,dh_dx,dh_du,Rk,T,iT] = diag_TCV_iota(x,g,v,u,it,model,nchan)
% #codegen

scal = 1; % typical scale
serr = 0.05; % error standard deviation

if ~isempty(nchan)
    if nchan==0
        irhomeas = [];
    else
        % always measurement at 1, others spread evenly elsewhere
        locmeas = [0,(1:nchan-1)/nchan];    % vector of rho locations
        % find corresponding closeby rhogrid points
        irhomeas = min(sum(bsxfun(@gt,locmeas,model.rgrid.rhogauss))+1,numel(model.rgrid.rhogauss));
    end
    gauss = true;
else
    irhomeas = 1:1:model.rgrid.nrho;
    gauss = false;
end

%irhomeas = 7;
[iota,diota_dx] = eval_iota(x,g,[],model,gauss);
dh_dx = 1/scal*diota_dx(irhomeas,:);

h = 1./scal*iota(irhomeas);

dh_du = zeros(numel(h),numel(u));

T = 1/scal * eye(numel(h));
iT = scal * eye(numel(h));

Rk = T*(serr.^2 * eye(numel(h)))*T';

return