%% RAPTOR Tutorial MEX. Learn how to accelerate simulations using mex files
disp('This tutorial needs fixing')
return

%% Run without MEX file
close all hidden;
% Start a simple RAPTOR run
run(fullfile(pwd,'..','RAPTOR_path.m')); % add RAPTOR path
[config] = RAPTOR_config; % load default params
% set longer default time
config.grid.tgrid = 0:1e-3:0.5;
[model,params,init,g,v,U] = build_RAPTOR_model(config); % generate model structure for these params.
x0 = RAPTOR_initial_conditions(model,init,g(:,1),v(:,1));  % Define the initial condition
U(1,:) = init.Ip0*ones(size(params.tgrid)); % input Ip trace: constant 80kA

%%
% This does not generate mex files. Let's test the timing
params.debug.iterdisp = 0; % turn off display
tic
simres = RAPTOR_predictive(x0,g,v,U,model,params);
toc

%% Run with MEX file
% We can generate mex files for the time step function at the time of the model generation
config.buildopts.mexify = true;
[model,params,~,~,~] = build_RAPTOR_model(config); % generate model structure for these params.

%%
% Now try the timing again
params.debug.iterdisp = 0; % turn off display
params.numerics.usemex = true;
tic
simres = RAPTOR_predictive(x0,g,v,U,model,params);
toc
return
%% MEX files regenerated only in case of code change
% Re-generating the RAPTOR model does not trigger new MEX file generation
% if the MEX is still compatible with the input sizes
tic
[model,params,init,g,v,U] = build_RAPTOR_model(config);
toc
%% 
% However if you change the model settings, a new MEX is generated
config.grid.rhogrid = linspace(0,1,21);
tic
[model,params,init,g,v,U] = build_RAPTOR_model(config); 
toc
