%% Load geometry information
clear;
fromfile = true; % set true to load from file
fname = 'ex1_data.mat'; 
if fromfile && ~isempty(which(fname))
  load('ex1_data.mat'); % if file exists, load it
else
  % Loading geometry data structure |G| of TCV from |fge:|
  % Vessel model with 256 filaments.
  L = fge('tcv',61400,[],'selu','v','izgrid',1);
  L.G = meqg(L.G,L.P,'Brxu','Bzxu','Brxa','Bzxa'); 
  G=L.G;
  % uncomment this to save file
  % save(fname,'G');
end

% The G structures now contains the full filament model of the vessel, since above we used `selu='v'`.
% Note that G.Tvu is the identity matrix and G.Muu is not diagonal.
fprintf('Muu diagonal? '); if isdiag(G.Muu); fprintf('yes\n'); else, fprintf('no\n'); end
fprintf('nv = %d\n',G.nv)
% copy these variables to Mvv, Rv etc for clarity
G.Mvv = G.Muu; G.Mav = G.Mau; G.Rv = G.Ru; G.Mxv=G.Mxu; G.Brxv=G.Brxu; G.Rvv = diag(G.Rv); % since selu='v'
% copy some more variables for brevity
na = G.na; nv = G.nv; 

%% Eigenmode decomposition
[V,D] = eig(G.Mvv\G.Rvv); % eigenvector and eigenvalues

% esort(P)  sorts the complex eigenvalues in the vector P in
% descending order by real part.  The unstable eigenvalues
% (in the continuous-time sense) will appear first.
[~,isort] = esort(diag(-D)); D = D(isort,isort); V = V(:,isort); % reorder eigenvalues
% keep only neig eigenvalues
neig = 30; ieig = 1:neig; 

% Define new Tvu and Tuv to diagonalize Muu and Ruu
Tvu = V; Tuv = V'; % this choice of Tuv maintains Mua=Mau'
Tuv = Tuv(ieig,:); Tvu = Tvu(:,ieig); % select only subset of eigenmodes
Ruu = Tuv*diag(G.Rv)*Tvu; Muu = Tuv*G.Mvv*Tvu; Mau = G.Mav*Tvu; Mua = Tuv*G.Mav';

% check if new Ruu, Muu are diagonal: check difference with purely diagonal matrix
disp(norm(Muu - diag(diag(Muu))))
disp(norm(Ruu - diag(diag(Ruu))))