classdef test_shotdesign_utils < matlab.unittest.TestCase
  % Tests for various shotdesign utilities

  properties
    testFilePrefix = 'tcv_coil_traces_';
    testFileSuffix = 'test';
  end
  
  methods(TestClassTeardown)
    function remove_test_file(testCase)
      testfilename = [testCase.testFilePrefix,testCase.testFileSuffix,'.mat'];
      if ~isempty(which(testfilename))
        delete(testfilename)
        fprintf('Teardown: deleted %s\n',testfilename);
      end
    end
  end
  
  methods(Test, TestTags={'Unit'})
    function test_tcv_traces_to_file(testCase)
      L = fbt('tcv',61400,0,'sela',{'E','F','OH'});
      t = 0:1e-3:0.1;
      nt = numel(t);
      
      Ia = zeros(L.G.na,nt);
      Va = zeros(L.G.na,nt);
      Ip = linspace(0,100e3,nt);
      dima = L.G.dima;
      filesuffix = 'test';
      
      fname_expected = [testCase.testFilePrefix,testCase.testFileSuffix,'.mat'];
      fname = tcv_traces_to_file(t,Ia,Va,Ip,dima,filesuffix);
      testCase.assertEqual(fname,fname_expected);
      testCase.assertNotEmpty(which(fname))
      
      D = load(fname);
      testCase.verifyEqual(D.efcur',Ia);
      testCase.verifyEqual(D.efvolt',Va);
      testCase.verifyEqual(D.aipoft',Ip);
      testCase.verifyEqual(D.toh',t);

      %% test errors
      testCase.verifyError(@() tcv_traces_to_file(t',Ia,Va,Ip,dima),'TCVTracesToFile:tsize'); % transpose t
      testCase.verifyError(@() tcv_traces_to_file(t, Ia',Va,Ip,dima),'TCVTracesToFile:Iasize'); % transpose Ia
      testCase.verifyError(@() tcv_traces_to_file(t, Ia(:,1),Va,Ip,dima),'TCVTracesToFile:Iasize'); % wrong Ia size

    end
    
  
  end
  
end