classdef test_mga_golden_shots < tests_mga
  % test mga golden shots, inherits test details from tests_mga
  
  properties
    RelTol = 1e-6;
    RelTolV = 1e-6;
    fort_equiv = false;
  end
  
  properties(TestParameter)
    % list of shots to be tested
    shots = cellstr(num2str(mga_golden_shots.get_golden_shots('golden_shot_table.csv')));
  end
  
  % the ones below do not work, don't know whether they should
  %     shot = {55645}; % doublet shot
  %     shot = {57541}; % a single not so recent shot (Jul 2017) - not good - checked out 6b754243 (from Sep 2017, needs zeecorr fix) and using static tree from Jan 2015 gets good match up to RelTol = 1e-6
  %     shot = {51839}; % a single not so recent shot (Mar 2016) - not good - checked out 6b754243 (from Sep 2017, needs zeecorr fix) and using static tree from Jan 2015 gets good match up to RelTol = 1e-6
  %     shot = {66513}; % A voltage stray                        - not good - Integral gain for OH control removed in some matrices as in .F plus vertical observer corrected as in .F (changes zeref)
  %     shot = {60061}; % a single not so recent shot (Feb 2018) - not good - Some gains changed + Ipz observer changed.
  
  methods(Test, TestTags={'Unit'})
    function test_writing_golden_shots(testCase)
      % test the golden shot generation methods
      g = mga_golden_shots; % instantiate
      
      % change parameters to be suitable for this test
      g.source_shotlist = 74893:-1:73000; % Specify shot list to avoid variability
      g.max_shots = 2;
      g.table_filename = sprintf('golden_data_test.csv');
      g.user_shot_offset = 50;
      g.ask_confirmation = false;
      
      % write test shots
      g.find_and_write_golden_shots;
      
      % check results
      T = readtable(g.table_filename);
      testCase.verifyFalse(~exist(g.table_filename,'file'),sprintf('file %s was not created',g.table_filename))
      testCase.verifyClass(T,'table')
      testCase.verifyEqual(size(T,1),g.max_shots);
      
      % test overwriting a single shot
      one_source_shot = T(1,:).source_shot;
      g.populate_user_shots(T,'source_shots',one_source_shot);
      
      one_golden_shot = T(2,:).golden_shot;
      g.populate_user_shots(T,'golden_shots',one_golden_shot);

       % clean up
      delete(g.table_filename);
    end
  end
  
end
