function fname = tcv_traces_to_file(t,Ia,Va,Ip,dima,filesuffix)
% Save feedforward references to file that can be loaded by MGAMS
%
% tcv_traces_tofile(t,Ia,Va,Ip,dima,filesuffix)
%
% Inputs:
% t: time vector
% Ia, Va: coil current, voltage, plasma current time tracess
% dima: cell array with dimensions for Ia,Vas
% filesuffix (optional)

% checks
assert(isrow(t),'TCVTracesToFile:tsize','t must be a row vector')
nt = numel(t); na = numel(dima);
assert(all(size(Ia) == [na,nt]),'TCVTracesToFile:Iasize','Unexpected Ia size, expected %dx%d',na,nt);
assert(all(size(Va) == [na,nt]),'TCVTracesToFile:Vasize','Unexpected Va size, expected %dx%d',na,nt);
assert(all(size(Ip) == [1,nt] ),'TCVTracesToFile:Ipize' ,'Unexpected Ip size, expected %dx%d', 1,nt);

assert(sum(startsWith(dima,{'E','F','OH'}))==18,'must specify all E,F,OH coils')

% store into MGAMS variables
toh    = t';
efcur  = Ia(contains(dima,{'E','F','OH'}),:)';
efvolt = Va(contains(dima,{'E','F','OH'}),:)';
aipoft = Ip';
tC = {[-0.5,3],[]}; % some default

if isempty(filesuffix)
  fname = 'tcv_coil_traces.mat';
else
  fname = sprintf('tcv_coil_traces_%s.mat',filesuffix);
end
save(fname,'toh','efcur','efvolt','aipoft','tC');
fname_path = which(fname);
fprintf('saved %s\n',fname_path);

end