% Generate list of shots prepared with FBTE.M and enforcing strki=0
% The PCS trees for these shots will be modified to ensure repeatability.

%%

shots = 57500:70300;
fbtem = false(size(shots));
strki = false(size(shots));
for ii = 1:numel(shots)
  [~,status] = mdsopen('pcs',shots(ii));
  if isodd(status)
    fbtem(ii) = strcmp('FBTE.M',mdsvalue('get_fbte_version()'));
    strki(ii) = any(mdsvalue('\mgams.data:strki'));
  end
  fprintf('TCV %05d: %d %d\n',shots(ii),fbtem(ii),strki(ii));
end

shots_mi = shots(fbtem & strki);

%%

checks_mi = NaN(numel(shots_mi),2);

for ii = 1:numel(shots_mi)
  L = fbt('tcv',shots_mi(ii));
  it = imax(L.P.strki);
  LX = fbtx('tcv',L.P.t(it),L);
  LY = fbtt(L,LX);
  [~,~,LY_] = fbt('tcv',shots_mi(ii),L.P.t(it),'strki',0);
  mdsopen('pcs',shots_mi(ii));
  Ia = mdsvalue('tcv_eq("i_pol","fbte")');Ia = Ia(1:16,it);
  checks_mi(ii,:) = [norm(LY.Ia - Ia),norm(LY_.Ia - Ia)];
  fprintf('TCV shot %05d, %03d/%03d\n',shots_mi(ii),ii,numel(shots_mi));
end

%%

fid = fopen('pcs_strki_shot_list','w');
for ii = 1:numel(shots_mi)
  if checks_mi(ii,2) < checks_mi(ii,1), fprintf(fid,'%d\n',shots_mi(ii)); end
end
