% Matrix Generation Users
classdef mgu < mgc
 
 properties (Constant , Hidden)
  x = {
       -1     -1 'tcv_oper' ;
       -1     -1 'tcv_root' ;
        0 899999 ''         ;
   900000 900999 'tcv_oper' ;
   901000 901999 'blanchar' ;
   902000 902999 'bbrown'   ;
   903000 903999 'ffelici'  ;
   904000 904999 'contre'   ;
   905000 905999 'coda'     ;
   906000 906999 'theiler'  ;
   907000 907999 'duval'    ;
   908000 908999 'ech_oper' ;
   909000 909999 'reimerdes';
   910000 910999 'testa'    ;
   911000 911999 'carpita'  ;
   912000 912999 'sauter'   ;
   913000 913999 'usheikh'  ;
   914000 914999 'ofevrier' ;
   915000 915999 'lporte'   ;
   916000 916999 'labit'    ;
   917000 917999 'amerle'   ;
   918000 918999 'mylee'    ;
   919000 919999 'smarchio' ;
   920000 920999 'cwuethri' ;
   921000 922999 'gituser'  ; % Extended range for golden shot storage
   923000 923999 'durrlego' ;
   924000 924999 'agostini' ;
   925000 925999 'ugoletti' ;
   926000 926999 'yinwang'  ;
   927000 927999 'lamatina' ;
   928000 928999 'apau'     ;
   929000 929999 'wangal'   ;
   930000 930999 'cheiss'   ;
   931000 931999 'admele'   ;
   932000    Inf ''         };
 end
 
 methods (Static)
  
  function y = size
   y = size(mgu.x,1);
  end
  
  function y = shot1(k)
   y = mgu.x{k,1};
  end
  
  function y = shot2(k)
   y = mgu.x{k,2};
  end
  
  function y = user(k)
   y = mgu.x{k,3};
  end
  
  function y = check(shot)
   user = getenv('USER');
   for k = 1:mgu.size
    y = strcmp(user,mgu.user(k)) && mgu.shot1(k) <= shot && shot <= mgu.shot2(k);
    if y, break, end
   end
  end
  
  function y = listusers
    y = mgu.x(:,3);
  end
  
  function [shotrange] = userrange(user)
    kuser = find(strcmp(mgu.listusers,user));
    assert(numel(kuser)==1,'no unique user %s found in list',user);
    shotrange = {mgu.shot1(kuser),mgu.shot2(kuser)};
  end
  
  function [shotrange] = myrange()
    user = getenv('USER');
    shotrange = mgu.userrange(user);
  end
  
  function testshot = mytestshot()
    myshotrange = mgu.myrange();
    user = getenv('USER');
    if strcmp(user,'gituser')
      % Shot # based on MATLAB version
      A = str2double(regexp(version,'\d+','match'));
      testshot = myshotrange{end} - 1999 + mod(A(1)*100 + A(2),1000);
    else
      testshot = myshotrange{end}; % take last shot for this user
    end
  end
  
 end %methods
 
end %classdef
