% MG C TYPE MIDGET 1931 4cyl 746cc 52.5bhp single OHC vertical dynamo
classdef mgc < dynamicprops & matlab.mixin.CustomDisplay
 
 methods (Static)
  
  function varargin = mdso(shot,mode)
   % mgc.mdso(shot,'r'|'w')
   
   assert(mode == 'r' || mgu.check(shot),'MatrixGenerator:mdso:Shot #%d protected',shot)
   if shot >= 900000 && mode == 'w'
    mdsconnect('tcvdata.epfl.ch');
    mdstcl('SET TREE PCS');
    mdstcl(sprintf('CREATE PULSE %d',shot));
   end
   status=mdsconnect('tcvdata.epfl.ch'); assert(isodd(status),'MatrixGenerator:mdso:can not connect to tcvdata')
   [opened_shot,s] = mdsopen('PCS',shot);
   assert(isodd(s),'MatrixGenerator:mdso:Shot #%d cannot be open(created)',shot);
   assert(logical(rem(mdssetdef('\MGAMS.DATA'),2)),'MatrixGenerator:mdso:Shot #%d has no MGAMS branch',shot)
   if nargout>0, varargin{1}=opened_shot; end
  end
  
 end
 
 methods (Access = protected)
  
  function pg = getPropertyGroups(M)
   A = {'tokamak';'shot'};
   B = properties(M);
   for k = [intersect(A,B,'stable');setdiff(B,A,'sorted')]'
    S.(k{1}) = M.(k{1});
   end
   pg = matlab.mixin.util.PropertyGroup(S);
  end
  
 end %methods
 
end %classdef
