% LOGBOOK
% mvloop(2:8) not treated yet
% aipgain(4:6) not treated yet 

function [varargout] = mgams18(shot,varargin)
%	State at 01/09/08 (SC)
%	consider:
%		could set up constants once at start-up possibly if program is
%		  kept running (not likely)
% MGAMS variables:
% mgams_var are all the input parameters corresponding to MDSPlus nodes,
%   list should not be modified

mgams_var =    {'aipdel',	'ip_obs(2)';
		'aipgain',	'ip_gain'; ...
		'aipipz',	'zip_obs(3)'; ...
		'alpha',	'rad_weight'; ...
		'amagic',	'time_dil(2)'; ...
		'boost',	'zip_w(1)'; ...
		'brmzerb',	't0_br(3)'; ...
		'brmzero',	't0_br(1)'; ...
		'brpzerb',	't0_br(4)'; ...
		'brpzero',	't0_br(2)'; ...
		'bzero',	'bt'; ...
		'bzmzerb',	't0_bz(3)'; ...
		'bzmzero',	't0_bz(1)'; ...
		'bzpzerb',	't0_bz(4)'; ...
		'bzpzero',	't0_bz(2)'; ...
		'cappa1',	'kappa_ref'; ...
		'curfac',	'ip_obs(1)'; ...
		'delipz',	'zip_obs(2)'; ...
		'delta1',	'delta_ref'; ...
		'deltar',	't0_dr'; ...
		'diohdt',	'diohdt_val'; ...
		'dpsfac',	'rad_obs(1)'; ...
		'dpszero',	'rad_obs(2)'; ...
		'egain',	'ie_gain(2)'; ...
		'emgain',	'icoil_gain'; ...
		'f36same',	'diag_time'; ...
		'fastm',	'zip_gain_d(3)'; ...
		'fgain',	'if_gain(2)'; ...
		'flattop',	'time_flattop'; ...
		'gain', 	'dens_gain_p'; ...
		'gainext',	'kappa_gain'; ...
		'gainr',	'rad_gain'; ...
		'gainvz',	'zip_gain_d(2)'; ...
		'gainvze',	'zip_gain_d(1)'; ...
		'gainz',	'zip_gain_p(2)'; ...
		'gainze',	'zip_gain_p(1)'; ...
		'gapin',	'rad_gap(1)'; ...
		'gapout',	'rad_gap(2)'; ...
		'ggain',	'dens_gain_i'; ...
		'hgain',	'dens_gain_d'; ...
		'hlamd1',	'lambda_ref'; ...
		'hpla',		'early_z'; ...
		'iansha',	'bound_anal_sel'; ...
		'icoilon',	'icoil_on'; ...
		'ierat',	'diohdt_sel'; ...
		'if36fb',	'bt_sign'; ...
		'ifour',	'kappa_sel'; ...
		'ikriz',	'zip_sel(2)'; ...
		'ilarg', 	'diag_corr(1)'; ...
		'ilia', 	'bound_approx_n'; ...
		'ilie', 	'bound_exact_n'; ...
		'imeas',	'imeas'; ...
		'inova',	'zip_sel(1)'; ...
		'iohfb',	'ip_sign'; ...
		'ipr16',	'magn_sel'; ...
		'iprcinc',	'diag_vac'; ...
		'ipripz',	'wobble_freq'; ...
		'iprmax',	'shape_sel(2)'; ...
		'isaddl',	'bound_x_sel'; ...
		'iscale',	'rad_sel'; ...
		'iscramb',	'shape_sel(1)'; ...
		'istop',	'diag_sel(1)'; ...
		'iwrida', 	'diag_corr(2)'; ...
		'mvloop',	'ip_sel(1)'; ...
		'nelz', 	'fe_NZ'; ...
		'nfast',	'zip_sel(3)'; ...
		'nr',		'mesh_n_R'; ...
		'nruns',	'run_calc_n'; ...
		'ntmax',	'run_t_n'; ...
		'numeq',	'run_n'; ...
		'nvvel',	'vessel_n'; ...
		'nz',		'mesh_n_Z'; ...
		'nzaxel',	'run_Zref'; ...
		'nzaxre',	'run_Sref'; ...
		'ohback',	'if_obs(2)'; ...
		'ohcorr',	'zip_obs(5)'; ...
		'ohgain',	'ioh_gain(2)'; ...
		'ohsame',	'dioh_gain_p'; ...
		'ohsami',	'dioh_gain_i'; ...
		'placu1',	'ip_ref'; ...
		'psifac',	'rad_obs(6)'; ...
		'rampt',	'zip_w(2)'; ...
		'rbro',		't0_br0_r'; ...
		'rbzo',		't0_bz0_r'; ...
		'relovo',	'vloop'; ...
		'ri',		'mesh_R_val(1)'; ...
		'rlia1',       	'bound_approx_r'; ...
		'rlim1',       	'bound_exact_r'; ...
		'rmajo1',	'rad_ref'; ...
		'rmino1',	'rmin_ref'; ...
		'ro',		'mesh_R_val(2)'; ...
		'rshift1',	'rad_obs(3)'; ...
		'rshift2',	'rad_obs(4)'; ...
		'rshift3',	'rad_obs(5)'; ...
		'timefac',	'time_dil(1)'; ...
		'toft', 	'diohdt_time'; ...
		'uc1',		'zip_w(3)'; ...
		'uc2',		'ip_w(1)'; ...
		'uc3',		'ip_w(2)'; ...
		'veback',	'if_obs(3)'; ...
		'vscal',	'bp_weight'; ...
		'vsec',		'vsec_ef'; ...
		'wpla',		'early_r'; ...
		'wscal',	'fl_weight'; ...
		'xip',		'fe_R_val(1)'; ...
		'xop',		'fe_R_val(2)'; ...
		'zbro',		't0_br0_z'; ...
		'zbzo',		't0_bz0_z'; ...
		'zeecorr',	'zip_obs(4)'; ...
		'zlia1',       	'bound_approx_z'; ...
		'zlim1',       	'bound_exact_z'; ...
		'zlp',		'fe_Z_val(1)'; ...
		'zmajo1',	'z_ref'; ...
		'zshift',	'wobble_ampl'; ...
		'zu',		'mesh_Z_val'; ...
		'zup',		'fe_Z_val(2)'};
% mgams18_int_var are additional (internal) variables
mgams18_int_var =  ...
	       {'aipoft',	'Ip_oft'; ...
		'a2ipz',	'IpDz_xf'; ... 
		'a2ipzb',	'IpDz_xf_b'; ...
		'a2ipzt',	'IpDz_xf_t'; ...
		'a2ipzs',	'IpDz2_xf'; ...
		'a3ipz',	'IpDz_xm'; ...
		'a3ipzb',	'IpDz_xm_b'; ...
		'a3ipzt',	'IpDz_xm_t'; ...
		'a3ipzs',	'IpDz2_xm'; ...
		'a3ipz3',	'IpDz_xm_m'; ...
		'a4ipz',	'IpDz_xc'; ...
		'a4ipzs',	'IpDz2_xc'; ...
		'a4ipz3',	'IpDz_xc_m'; ...
		'aph',		'Area_rate'; ...
		'aphv',		'repmat(Area_rate,fe_NRZ,1)'; ...
		'area',		'A_pla'; ...				%Plasma area
		'aroft',	'R_pla_oft'; ...
		'axi',		'A_xx_inv'; ...
		'axiw',		'A_xx_inv_f'; ...
		'axiv',		'A_xx_inv_m'; ...
		'axx',		'A_xx'; ...
		'azel',		'Dz'; ...
		'azels',	'Dz2'; ...
		'b1 (first)',	'M_xfx'; ...
		'b1 (second)',  'M_xf_w'; ...
		'b2 (first)',	'B_xmx'; ...
		'b2 (second)'	'B_xm_w'; ...	
		'b4',		'M_xfc'; ...
		'b5',		'B_xmc'; ...
		'b6',		'M_xfc + B_xmc'; ...
		'bee',		'bpol'; ...
		'beemax',	'bpolM'; ...
		'beeoft',	'bp_oft'; ...
		'beerem'	't_br(:,1)'; ...
		'beerep'	't_br(:,2)'; ...
		'beermb'	't_br(:,3)'; ...
		'beerpb'	't_br(:,4)'; ...
		'beetwo',	'bpoltwo'; ...
		'beezem'	't_bz(:,1)'; ...
		'beezepb'	't_bz(:,3)'; ...
		'beezep'	't_bz(:,2)'; ...
		'beezepb'	't_bz(:,4)'; ...
		'bound_n',	'bound_n'; ... 		%bound_n = bound_exact_n + bound_approx_n;
		'bphbacq',	'bt_norm'; ...
		'brmoft',	't0_br_oft(1)'; ...
		'brmone',	'brone(1)'; ...
		'brmoftb',	't0_br_oft(3)'; ...
		'brmtwo',	'brtwo(1)'; ...
		'brpoft',	't0_br_oft(2)'; ...
		'brpoftb',	't0_br_oft(4)'; ...
		'brpone',	'brone(2)'; ...
		'brptwo',	'brtwo(2)'; ...
		'bzeroe',	'bt'; ...
		'bzeroft',	'bt_oft'; ...
		'bzmoft',	't0_bz_oft(1)'; ...
		'bzmoftb',	't0_bz_oft(3)'; ...
		'bzmone',	'bzone(1)'; ...
		'bzmtwo',	'bztwo(1)'; ...
		'bzpoft',	't0_bz_oft(2)'; ...
		'bzpoftb',	't0_bz_oft(4)'; ...
		'bzpone',	'bzone(2)'; ...
		'bzptwo',	'bztwo(2)'; ...
		'bzramp',	'bz_ramp'; ...
		'cappab',	'K_pla';				%Plasma elongation
		'coe',		'Txf'; ...
		'itype'		'conductor_type'; ...
		'curmax',	'icoilM'; ...
	        'deltat1 ',	'early_dt(1)'; ...
		'deltat2 ',	'early_dt(2)'; ...
		'deltat5 ',	'early_dt(5)'; ...
		'dep',		'B_xm'; ...
		'dex',		'B_mc'; ...
		'dr',		'mesh_dR'; ...
		'dxel',		'fe_dR'; ...
		'dz',		'mesh_dZ'; ...
		'dzel',		'fe_dZ'; ...
		'ebias',	'ebias'; ...
		'eli',		'Li_pla'; ...				%Plasma internal inductance	
		'elplas',	'L_pla'; ...				%Plasma inductance
		'elpvone',	'M_pcone'; ...
		'elpvtwo',	'M_pctwo'; ...
		'elss',		'M_cc'; ... 				%[E(8),F(8),OH(2),G(1),VV(38)]
		'filfac',	'coil_packing'; ...
		'flux',		'flux'; ...
		'fluxoft',	'fl_oft'; ...
		'fldmax',	'fluxM'; ...
		'gcurr',	'icoil'; ...
		'gp',		'M_xf'; ...		
		'gx',		'M_fc'; ... 				%c = coils + vessel: for vessel divided by the resistance
		'gxf',		'M_fc_fast'; ...
		'hvf',		'filament_height'; ...
		'iallf',	'filament_n'; ...
		'jmax',		'mesh_NR'; ...
		'kmax',		'mesh_NZ'; ...
		' ',		'mesh_NRZ'; ...				%mesh_NRZ = mesh_NR*mesh_NZ	
		'midplan',	'midplan'; ...
		'midplad',	'midplad'; ...
		'midout',	'midout'; ...
		'ntoft',	'diohdt_n';
		'mmax',		'fe_NRZ'; ...
		'mmshift',	'mmshift'; ...
		'nelr', 	'fe_NR'; ...
		'ngroup',	'cond_n'; ...				%Number of conductors (coil_n + vessel_n)
		'ngroup1',	'cond_n+1'; ...
		'nip',		'nip'; ...	
		'nloop',	'fl_n'; ...
		'noh',		'oh_n'; ...
		'nprob',	'bp_n'; ...
		'nshafa',	'coil_n'; ...				%Number coils
		'nshaoh',	'coil_n'; ...		
		'nshap',	'shap_n'; ...				%Number shaping coils
		' ',		'obs_doublet'; ...			%Observer for doublet configuration
		'oh',		'[oh1 oh2 .. ]'; ...
		'placur',	'pla_cur'; ... 
		'plcmax',	'pla_curM'; ...
		'polcur',	'pol_cur'; ...
		'prlen',	'bp_l'; ...
		'r',		'mesh_R'; ...
		'raxb',		'R_pla_b'; ...
		'raxt',		'R_pla_t'; ...
		'rbee',		'bp_r'; ...
		'rbroe',       	't0_br0_r'; ...
		'rbzoe',       	't0_bz0_r'; ...
		'rdee',		'r_pla'; ...				%Plasma minur radius
		'resis',	'Rc'; ...
		'rflu',		'fl_r'; ...
		'rhocu',	'coil_res'; ...
		'rhovv',	'vessel_res'; ...
		'rlia',       	'bound_approx_r'; ...
		'rlim',       	'bound_exact_r'; ...
		'rvf',		'filament_R'; ...
		'rze',		'R_pla'; ...				%Plasma radius
		'rzepm',	'dR_pla(1:2,:)'; ...			%dR_pla(1,:) = R_pla - t0_dr 
		'tfra',		'tfra'; ...
		'tfrasq',	'tfra2'; ...
		'thbee',	'bp_th'; ...
		'timeqe',	'timeqe'; ...
		'tvf',		'filament_turns'; ...
		'usdi',		'cost_mu'; ...
		've',		'[ve1 ve2 ... ]'; ...
		'vvv',		'bp_w'; ...
		'wvf',		'filament_width'; ...
		'www',		'fl_w'; ...
		'xel',		'fe_R'; ...
		'xfob',		'rb'; ...
		'z',		'mesh_Z'; ...
		'zax',		'Z_pla'; ...
		'zaxb',		'Z_pla_b'; ...
		'zaxt',		'Z_pla_t'; ...
		'zbee',		'bp_z'; ...
		'zbroe',       	't0_br0_z'; ...
		'zbzoe',       	't0_bz0_z'; ...
		'zdee',		'z_pla'; ...				%Vertical plasma size
		'zecorb',	'zecorb'; ...
		'zecorrb',	'zecorrb'; ...
		'zecorrt',	'zecorrt'; ...
		'zecort',	'zecort'; ...
		'zel',		'fe_Z'; ...
		'zeoft',	'Z_pla_oft'; ...
		'zflu',		'fl_z'; ...
		'zfob',		'zb'; ...
		'zlia',       	'bound_approx_z'; ...
		'zlim',       	'bound_exact_z'; ...
		'zsq',		'DZ2'; ...
		'zvf',		'filament_z'};

%---------------------------------------- 
% constant values
%%	DEFAULT subroutine
%---------------------------------------- 
bt_sign				= 1;
dens_gain_i			= 0.1;
dens_gain_p			= 0;
diag_sel			= 0;
diag_time			= 0;
diag_vac			= 1;
dioh_gain_p			= 1;
diohdt_n			= 29;
early_dt			= 0.001*[1,2,0,0,10];
early_r 			= 0.1;
early_z 			= 0.1;
fe_NZ			= 2;
fe_R_val			= [0.65,1.11];
fe_Z_val			= 0.24*[-1,1];
run_Zref 		= 10;
run_Sref 		= 1;
icoil_gain			= 200;
ie_gain				= [0,3];
if_gain				= [0,2];
if_obs				= [0,1.1,0.93];
ioh_gain			= [0,0.5];
ip_gain				= 0;
ip_obs				= [0.75,0];
ip_sel				= 0;
ip_sign				= 1;
ip_w			= 1e-8*[1,1];
kappa_gain			= 0;
fl_weight			= 10000;
magn_sel			= 0;
midplan				= 0;
bp_weight			= 10000;
rad_gain			= 0;
rad_gap				= [0.04,0.1];
rad_obs 			= [1,0,0,0,0,5000];
rad_sel				= 0;
rad_weight			= 0;
run_n				= 7;
run_t_n				= 900;
shape_sel			= [1,0];
time_dil			= [0.8,1];
time_flattop			= 0.25;
t0_br				= [0,0,0,0];
t0_bz				= -0.00015*[1,1,1,1];
t0_dr				= 0.01;
vloop				= 1.5;
wobble_ampl			= 0;
wobble_freq			= 0;
zeecorb				= 0;
zeecort				= 0;
zip_gain_d			= [0,0,0];
zip_gain_p			= [0,0];
zip_obs				= [0,0,0,0,0,];
zip_w			= [0,0.5,0];


%---------------------------------------- 
% read MGAMS parameters 
%%	
%---------------------------------------- 
if isempty(mdsopen('PCS',shot)),    error('Cannot open shot'),        end
if ~rem(mdssetdef('MGAMS.DATA'),2), error('No MGAMS branch in shot'), end
for i=1:size(mgams_var,1),
  eval(['[',mgams_var{i,2},',stat] = mdsdata(''',mgams_var{i,1},''');'])
  if ~rem(stat,2), error(['Cannot read MGAMS variable ',mgams_var{i,1}]), end
end
mdsclose
if isnan(zip_obs(5)), zip_obs(5) = 0; end 
kappa_gain(length(kappa_gain):3) = 0;

%---------------------------------------- 
% read FBTE output 
%%	
%---------------------------------------- 
%   will later replace fbtmeas.dat file with MDSPlus nodes
shap_n=16;
fbtid=fopen('fbtmeas.dat','r');
if fbtid <= 0, 
  disp(['Error opening FBTE output file; program stopping'])
  return
end
[fbtin,fbtcount]=fscanf(fbtid,'%e');
fclose(fbtid);
if fbtcount < 8 | fbtcount < 14+fbtin(7)*6+fbtin(8)*3+fbtin(3)*3+fbtin(4)*2,
  disp(['FBTE output file truncated; program stopping'])
  return
end
ii=14;
fbtinc=num2cell(fbtin(1:ii));
[run_calc_n,	dummy,		bp_n,		fl_n,		...
 mesh_n_R, 	mesh_n_Z,	filament_n,	cond_n, 	...
 mesh_R_val(1),	mesh_R_val(2),	mesh_Z_val,	coil_res,	...
 coil_packing,	vessel_res ] = ...
	deal(fbtinc{:});
filament_R=fbtin(ii+1:ii+filament_n);
ii=ii+filament_n;
filament_z=fbtin(ii+1:ii+filament_n);
ii=ii+filament_n;
filament_height=fbtin(ii+1:ii+filament_n);
ii=ii+filament_n;
filament_width=fbtin(ii+1:ii+filament_n);
ii=ii+filament_n;
filament_turns=fbtin(ii+1:ii+filament_n);
ii=ii+filament_n;
% kgroup are not used
ii=ii+filament_n;
conductor_start_index=fbtin(ii+1:ii+cond_n);
ii=ii+cond_n;
conductor_end_index=fbtin(ii+1:ii+cond_n);
ii=ii+cond_n;
conductor_type=fbtin(ii+1:ii+cond_n);
ii=ii+cond_n;
bp_r=fbtin(ii+1:ii+bp_n);
ii=ii+bp_n;
bp_z=fbtin(ii+1:ii+bp_n);
ii=ii+bp_n;
bp_th=fbtin(ii+1:ii+bp_n);
ii=ii+bp_n;
fl_r=fbtin(ii+1:ii+fl_n);
ii=ii+fl_n;
fl_z=fbtin(ii+1:ii+fl_n);
ii=ii+fl_n;
%
for i=1:run_calc_n,
  if fbtcount-ii < 24+cond_n+bp_n+fl_n,
    disp(['FBTE output file truncated; program stopping'])
    return
  end
  fbtinc=num2cell(fbtin(ii+1:ii+24));
  [nrun,	ilie,		ilia,		ibro,		...
   ibzo,	pla_cur(i),	Z_pla(i),	bt(i),		...
   R_pla(i),	timeqe(i),	R_pla_t(i),	Z_pla_t(i),	...
   R_pla_b(i),	Z_pla_b(i),	zecorb(i),	zecort(i),	...
   betai(i),	Li_pla(i),	diamag(i),	qedge(i),	...
   qzeroe(i),	A_pla(i),	K_pla(i),	shvsec(i)] = ...
       deal(fbtinc{:});
  ii=ii+24;
  icoil(i,1:cond_n)=fbtin(ii+1:ii+cond_n)';
  ii=ii+cond_n;
  bpol(i,1:bp_n)=fbtin(ii+1:ii+bp_n)';
  ii=ii+bp_n;
  flux(i,1:fl_n)=fbtin(ii+1:ii+fl_n)';
  ii=ii+fl_n;
  if fbtcount-ii < 2*(ilie+ilia+ibro+ibzo);
    disp(['FBTE output file truncated; program stopping'])
    return
  end
  bound_exact_n = ilie;
  bound_approx_n= ilia;
  bound_exact_r(i,1:ilie)=fbtin(ii+1:ii+ilie)';
  ii=ii+ilie;
  bound_exact_z(i,1:ilie)=fbtin(ii+1:ii+ilie)';
  ii=ii+ilie;
  bound_approx_r(i,1:ilia)=fbtin(ii+1:ii+ilia)';
  ii=ii+ilia;
  bound_approx_z(i,1:ilia)=fbtin(ii+1:ii+ilia)';
  ii=ii+ilia;
  t0_br0_r(i,1:ibro)=fbtin(ii+1:ii+ibro)';
  ii=ii+ibro;
  t0_br0_z(i,1:ibro)=fbtin(ii+1:ii+ibro)';
  ii=ii+ibro;
  t0_bz0_r(i,1:ibzo)=fbtin(ii+1:ii+ibzo)';
  ii=ii+ibzo;
  t0_bz0_z(i,1:ibzo)=fbtin(ii+1:ii+ibzo)';
  ii=ii+ibzo;
  if diag_sel(1)==8,
    if ilie>0,
      disp(sprintf('%12.5f',bound_exact_r(i,:)))
      disp(sprintf('%12.5f',bound_exact_z(i,:)))
    end
    if ilia>0,
      disp(sprintf('%12.5f',bound_approx_r(i,:)))
      disp(sprintf('%12.5f',bound_approx_z(i,:)))
    end
    if ibro>0,
      disp(sprintf('%12.5f',t0_br0_r(i,:)))
      disp(sprintf('%12.5f',t0_br0_z(i,:)))
    end
    if ibzo>0,
      disp(sprintf('%12.5f',t0_bz0_r(i,:)))
      disp(sprintf('%12.5f',t0_bz0_z(i,:)))
    end
  end
end

%---------------------------------------- 
% read ggg18.inc data 
%%	
%---------------------------------------- 
mequi 	= 10;
mrmp 	= 31;
mamp 	= 65;
melm 	= 12;
mfila	= 310;
ms 	= 1800;
mt	= 900;
mcoil 	= 27;
mm1	= 24;
mm2	= 48;
mm3 	= 128;
msw	= 10;
msx	= 12;


%---------------------------------------- 
% read mgamsread.inc data 
%%	
%---------------------------------------- 
mh 	= 60;
mcog	= 60;
mbro	= 5;
mbzo	= 5;
mabp	= 25;
mebp	= 20;
 

ip_gain = [ip_gain zeros(1,3-length(ip_gain))];




%---------------------------------------- 
% constant values
%%	CONST subroutine
%---------------------------------------- 
%Constants
cost_mu = 4*pi*1e-7;

%Negative plasma current 
if ip_sign == -1
	zeecorb		= -zeecorb;
	zeecort		= -zeecort;
	rad_obs([2 5]) 	= -rad_obs([2 5]);
	wobble_ampl  	= -wobble_ampl;
	zip_obs([2 3 4])= -zip_obs([2 3 4]);
	vloop		= -vloop;
	t0_br		= -t0_br;
	t0_bz		= -t0_bz;
	ip_obs(2)	= -ip_obs(2);
	pla_cur		= -pla_cur;
	shvsec		= -shvsec;
	icoil		= -icoil;
	bpol		= -bpol;
	flux		= -flux;
end

if mesh_n_R > 30, 		mesh_n_R = 30; end
if mesh_n_Z > 32, 		mesh_n_Z = 32; end
if run_n > run_calc_n, 		run_n = run_calc_n; end
if run_Zref > run_n,	run_Zref = run_n; end
if run_Sref > run_n, run_Sref = run_n; end 

if ip_sel(1) == 8||ip_sel(1) == 18, midplan = 8; end

omal = 1 - rad_weight;
opal = 1 + rad_weight;
ompsq = 2/(omal^2 + opal^2); 
ompsq2 = 3/(2*omal^2 + opal^2);

if shape_sel(1) == 25|shape_sel(1) == 26
	ompsq3 = 6/(3*omal^2 + opal^2 + 2*omal*opal);
else
	ompsq3 = 6/(opal^4 + 2*omal^4 + 3*opal^2*omal^2);
end

if shape_sel(1) ~=4&shape_sel(1) ~= 14
	zutile = 0.75;
	zaxinp = (fe_Z_val(1)+fe_Z_val(2))/2;
	zaxdel = Z_pla(run_Zref) - zaxinp;
	fe_Z_val(1) = fe_Z_val(1) + zaxdel;
	fe_Z_val(2) = fe_Z_val(2) + zaxdel;
	
	if fe_Z_val(1) < -zutile
		fe_Z_val(2) = fe_Z_val(2) + fe_Z_val(1) + zutile;
		fe_Z_val(1) = -zutile; 	
	end	
	
	if fe_Z_val(2) > zutile
		fe_Z_val(1) = fe_Z_val(1) + fe_Z_val(2) - zutile;
		fe_Z_val(2) = zutile;
	end
end

if midplan == 8 %Doublet
	fe_NZ 	= 6;
	fe_R_val(1) 	= 0.65;
	fe_R_val(2)  = 1.11;			
	fe_Z_val(1)	= -0.7;
	fe_Z_val(2)	= 0.7;
end	

dt = 1;
if run_calc_n ~= 1, dt = zip_w(2)/(run_calc_n-1); end
bound_n = bound_exact_n + bound_approx_n;
%cond_n = 38+18; disp('cond_n and vessel_n imposed');
shap_n 	= length(find(conductor_type==1));
oh_n	= length(find(conductor_type==2));
vessel_n= length(find(conductor_type==4));
%vessel_n = 38;
coil_n	= cond_n - vessel_n;

zip_weight_r(3)	= 0;
ip_weight_r(1)	= ip_w(1)/(ip_w(1)+ip_w(2));	
ip_weight_r(2)	= ip_w(2)/(ip_w(1)+ip_w(2));	

%Maximum values of measurements
pla_curM	= max(pla_cur);
icoilM		= max(max(abs(icoil)));
bpolM		= max(max(abs(bpol)));
fluxM		= max(max(abs(flux(:,2:end)-repmat(flux(:,1),1,fl_n-1))));

%Poloidal distance between B-probes (used in the plasma current observer)
bp_l 	= sqrt(diff([bp_r(end); bp_r]).^2 + diff([bp_z(end); bp_z]).^2);
bp_l 	= mean([bp_l(1:end-1) bp_l(2:end); bp_l(end) bp_l(1)],2)./cost_mu; 

%mesh
mesh_dR	= (mesh_R_val(2) - mesh_R_val(1))/mesh_n_R; %Delta R of the mesh
mesh_R 	= mesh_R_val(1) + (1:mesh_n_R)*mesh_dR; mesh_R = [mesh_R_val(1) mesh_R]; %Radial points mesh
mesh_NR = length(mesh_R); %Number radial points mesh

mesh_dZ	= mesh_Z_val/mesh_n_Z; %Delta Z of the mesh
mesh_Z	= -mesh_Z_val + (1:mesh_n_Z*2)*mesh_dZ; mesh_Z = [-mesh_Z_val mesh_Z]; %Vertical points mesh
mesh_NZ = length(mesh_Z); %Number vertical points mesh

mesh_NRZ = mesh_NR*mesh_NZ; %Size mesh

mesh_r	= reshape(repmat(mesh_R',1,mesh_NZ)',mesh_NRZ,1); %Radial coordinates mesh 
mesh_z 	= reshape(repmat(mesh_Z,mesh_NR,1)',mesh_NRZ,1);  %Vertical coordinates mesh	

%position filaments conductors
coil_Rw = mdsdata('STATIC("R_W")');
coil_Zw = mdsdata('STATIC("Z_W")');

vessel_R = mdsdata('STATIC("R_F")');
vessel_Z = mdsdata('STATIC("Z_F")');
if vessel_n == 19
	vessel_R = vessel_R(1:2:38);
	vessel_Z = vessel_Z(1:2:38);
elseif vessel_n == 38
	vessel_R = vessel_R(1:38);
	vessel_Z = vessel_Z(1:38);

end

%resistance conductors
dim_a = mdsdata('STATIC("DIM_A")'); dim_a = dim_a([3:18 1:2]); 
R_a = mdsdata('STATIC("RES_A")[$]',dim_a); %resistance a coils
if vessel_n == 38 
	R_v = mdsdata('STATIC("RES_S")'); %Vessel resistance (differences with fortran version)
elseif vessel_n == 19
	R_v = mdsdata('STATIC("RES_R")'); %Vessel resistance (differences with fortran version)
end
R_c = [R_a; R_v];

%inductance conductors
M_aa = mdsdata('STATIC("MUT_A_A")[$1,$2]',dim_a,dim_a); %Mutual between poloidal coils
if vessel_n == 19
	M_vv = mdsdata('STATIC("MUT_R_R")'); %Mutual between vessel filaments 
	M_va = mdsdata('STATIC("MUT_R_A")[*,$]',dim_a); %Mutual between vessel filaments and coils
elseif vessel_n == 38
	M_vv = mdsdata('STATIC("MUT_S_S")'); %Mutual between vessel filaments 
	M_va = mdsdata('STATIC("MUT_S_A")[*,$]',dim_a); %Mutual between vessel filaments and coils
end 

M_cc = [M_aa M_va'; M_va M_vv];

%Tranformation matrix conductors
T_ba = mdsdata('STATIC("T_C_A")[*,$]',dim_a);
T_wb = mdsdata('STATIC("T_W_C")');

% Weights: inverse of square of measurements error 
fl_w = repmat(fl_weight,fl_n,1);
if magn_sel == 0
	fl_w([10:12 28:30]) = 0;
end

bp_w = repmat(bp_weight,bp_n,1);

if zip_sel(3) ~= 0 %FPS ON
	fl_w([13:16 24:27]) = 0;	
	bp_w([13:16 24:27]) = 0;	
end

% M_fc - mutual between flux loops and conductors
dim_f= mdsdata('STATIC("DIM_F")'); dim_f = dim_f(1:38);
M_fa = -mdsdata('STATIC("MUT_F_A")[$1,$2]',dim_f,dim_a); %Flux from coils
if vessel_n == 19
	M_fv = -mdsdata('STATIC("MUT_F_R")[$,*]',dim_f);%Flux from vessel 
elseif vessel_n == 38
	M_fv = -mdsdata('STATIC("MUT_F_S")[$,*]',dim_f);%Flux from vessel 
end

M_fc = [M_fa M_fv./repmat(R_v,1,38)']; %NB Flux from vessel/resis
M_fc = M_fc-repmat(M_fc(1,:),38,1);

% B_mc - magnetic field in pick-up coils from conductors
B_ma = mdsdata('STATIC("BT_M_A")[*,$]',dim_a); %Magnetic field from coils
if vessel_n == 19
	B_mv = mdsdata('STATIC("BT_M_R")'); %Magnetic field from vessel
else
	B_mv = mdsdata('STATIC("BT_M_S")'); %Magnetic field from vessel
end
B_mc = [B_ma B_mv./repmat(R_v,1,38)'];%NB Magnetic field from vessel/resis 

% Finite elements definition
fe_NR  = 2;
%> bad usage of imeas variable JMM
if imeas > 2, fe_NR = imeas; end
fe_NRZ = fe_NR*fe_NZ;
fe_dR  = (fe_R_val(2) - fe_R_val(1))/(fe_NR+1);
fe_dZ  = (fe_Z_val(2) - fe_Z_val(1))/(fe_NZ+1);
fe_A   = fe_dR*fe_dZ/(mesh_dR*mesh_dZ);
fe_R   = fe_R_val(1) + (1:fe_NR)*fe_dR;
fe_Z	  = fe_Z_val(1) + (1:fe_NZ)*fe_dZ;
fe_r	  = reshape(repmat(fe_R',1,fe_NZ)',fe_NRZ,1); 
fe_z	  = reshape(repmat(fe_Z,fe_NR,1)',fe_NRZ,1);

%Tranformation matrix mesh -> filaments
Txf = zeros(mesh_NRZ,fe_NRZ);
for m=1:fe_NRZ
	for j=1:mesh_NR
		for k=1:mesh_NZ
			coe(j,k,m) = ((1-abs(mesh_R(j)-fe_r(m))/fe_dR)* ...
				(1-abs(mesh_Z(k)-fe_z(m))/fe_dZ));
			if abs((mesh_R(j)-fe_r(m))/fe_dR) >= 1, coe(j,k,m) = 0;end
			if abs((mesh_Z(k)-fe_z(m))/fe_dZ) >= 1, coe(j,k,m) = 0;end
		end
	end
	Txf(:,m) = reshape(coe(:,:,m)',mesh_NRZ,1);	
end

% M_fx flux in the loops produced by filaments
M_fx = zeros(fl_n,fe_NRZ);
M_fx = -greenem('m',fl_r,fl_z,mesh_r,mesh_z) * Txf; 
M_fx(2:end,:) = M_fx(2:end,:)-repmat(M_fx(1,:),fl_n-1,1); %flux - flux(1)
M_fx(1,1:end) = 0;
M_xf=M_fx';
%B_mx magnetic field in the probes produced by filaments
B_mx 	= zeros(bp_n,fe_NRZ);
B_mx_r 	= greenem('br',bp_r,bp_z,mesh_r,mesh_z) * Txf;
B_mx_z 	= greenem('bz',bp_r,bp_z,mesh_r,mesh_z) * Txf;
B_mx 	= 	B_mx_r .* repmat(cos(bp_th.*pi/180),1,fe_NRZ) + ...
		B_mx_z .* repmat(sin(bp_th.*pi/180),1,fe_NRZ);
B_xm 	= B_mx';






%---------------------------------------- 
% Buid the observer 
%%	OBSERV subroutine
%---------------------------------------- 

%% VERTICAL OBSERVER
% Main equation: Ix = A_xx_inv*(Mfx'*psi - Mfx'*Mfa*Ia + Bmx'*b - Bmx'*Bma*Ia)
M_xfx = M_xf*diag(fl_w)*M_fx;                    % mdmt(gp,mmax,nloop,www,nloop,b1)
B_xmx = B_xm*diag(bp_w)*B_mx + fe_A^2*ip_w(1);   % mdmt(dep,mmax,nprob,vvv,nprob,b2) % b2(i,j) = b2(i,j)+aph*aph*uc2
A_xx = M_xfx + B_xmx;                            % axx(i,j) = b1(i,j)+b2(i,j)

A_xx_inv   = pinv(A_xx);                         % inver(axx,mmax,axi)
A_xx_inv_f = pinv(M_xfx);                        % inver(b1,mmax,axiw)
A_xx_inv_m = pinv(B_xmx);                        % inver(b2,mmax,axiv)

M_xf_w = M_xf*diag(fl_w);                        % mulmd(gp,mmax,nloop,www,nloop,b1)
B_xm_w = B_xm*diag(bp_w);                        % mulmd(dep,mmax,nprob,vvv,nprob,b2)

if zip_sel(2)==2 && ismember(zip_sel(3),[-3 -5]) % ikriz.eq.2.and.(nfast.eq.-5.or.nfast.eq.-3)
 bp_w([1 7 9 10 12:16 20 24:28 30 31 33]) = 0.;  % vvv(?) = 0.
 B_xmx_w = B_xm*diag(bp_w)*B_mx + fe_A^2*ip_w(1); % mdmt(dep,mmax,nprob,vvv,nprob,b3) % b3(i,j) = b3(i,j)+aph*aph*uc2
 A_xx_inv_m = pinv(B_xmx_w);                     % inver(b3,mmax,axiv)
 B_xmx_w = B_xm*diag(bp_w);                      % mulmd(dep,mmax,nprob,vvv,nprob,b3)
end

B_xm_w = B_xm_w+repmat(bp_l'.*ip_w(1)*fe_A,fe_NRZ,1); % b2(m,n) = b2(m,n) + uc2*aph*prlen(n)

M_xc = M_xf_w * M_fc;                            % mulmm(b1,mmax,nloop,gx,nloop,ngroup1,b4)
B_xc = B_xm_w * B_mc;                            % mulmm(b2,mmax,nprob,dex,nprob,ngroup1,b5)
A_xc = M_xc + B_xc;                              % b6(i,j)=b4(i,j)+b5(i,j)

if midplan == 8                                  % midplan.eq.8
 Dz = fe_A*fe_Z;                                 % azel(m) = aph*zel(m)
else
 Dz = fe_A*(fe_z - Z_pla(run_Sref));             % azel(m) = aph*(zel(m)-zax(nzaxre)) 
end
                                                 % mulvm(azel,mmax,axi,mmax,mmax,v1)
IpDz_xf = (Dz'*A_xx_inv)*M_xf_w;                 % mulvm(v1,mmax,b1,mmax,nloop,a2ipz)
IpDz_xm = (Dz'*A_xx_inv)*B_xm_w;                 % mulvm(v1,mmax,b2,mmax,nprob,a3ipz)
IpDz_xc = (Dz'*A_xx_inv)*A_xc;                   % mulvm(v1,mmax,b6,mmax,ngroup1,a4ipz)
IpDz_xm_m = zeros(size(IpDz_xm));
IpDz_xc_m = zeros(size(IpDz_xc));

if zip_sel(2)==2 && zip_sel(3)==-2               % ikriz.eq.2.and.nfast.eq.-2
                                                 % mulvm(azel,mmax,axiv,mmax,mmax,v1)
 IpDz_xm_m = (Dz'*A_xx_inv_m)*B_xm_w;            % mulvm(v1,mmax,b2,mmax,nprob,a3ipz3)
	IpDz_xc_m = (Dz'*A_xx_inv_m)*B_xc;              % mulvm(v1,mmax,b5,mmax,ngroup1,a4ipz3)
end 
	
if zip_sel(2)==2 && ismember(zip_sel(3),[-3 -5]) % ikriz.eq.2.and.(nfast.eq.-5.or.nfast.eq.-3)
 IpDz_xm_m = (Dz'*A_xx_inv_m)*B_xmx_w;           % mulvm(azel,mmax,axiv,mmax,mmax,v1)
end                                              % mulvm(v1,mmax,b3,mmax,nprob,a3ipz3)

% UNTRANSLATED section
if ismember(zip_sel(3),[-3 -4 -5])               % nfast.eq.-3.or.nfast.eq.-4.or.nfast.eq.-5
	IpDz_xm_m = IpDz_xm;
end

if fe_NZ==2 && zip_sel(3)==-4 && shape_sel(1)==2 % nelz.eq.2.and.nfast.eq.-4.and.iscramb.eq.2
	kc = [10 11 14 15];
 if     Z_pla(1) < -0.11, kc = kc - 1;
 elseif Z_pla(1) >  0.11, kc = kc + 1;
 end

	v_fc = M_fc(2:end,kc) * [1;1;-1;-1];            % a1(38,j) = gx(j+1,10+mmshift)+gx(j+1,11+mmshift)-gx(j+1,14+mmshift)-gx(j+1,15+mmshift) % a1(j,j) = 1. % a1(j,38) = a1(38,j)
	v_fx = [1 1 -1 -1] * M_xf([2 4 1 3],2:end)';    % v11(j)   = gp(2,j+1)+gp(4,j+1)-gp(1,j+1)-gp(3,j+1)	% a1(j,39) = v11(j)	
	if magn_sel == 0                                % ipr16.eq.0                             
		k = [9 10 11 13 14 24 25 27 28 29]; 
		v_fc(k,:) = 0;
		v_fx(k,:) = 0;
 end
	v = [eyes(37) v_fc ; v_fc' 0] \ [v_fx ; 0];     % gauss(38,a1,v12)
	coef = 2*fe_A*fe_dZ/(v_fx'*v);                  % coef = coef + v11(j)*v12(j) % coef = (2.*aph*dzel)/coef
	IpDz_xf = [0 0.5*v'*coef];                      % a2ipz(j+1) = 0.5*v12(j)*coef % a2ipz(1) = 0.
	
	v_mc = B_mc(1:end,kc) * [1;1;-1;-1];            % a1(39,j) = dex(j,10+mmshift)+dex(j,11+mmshift)-dex(j,14+mmshift)-dex(j,15+mmshift) % a1(j,j) = 1. % a1(j,39) = a1(39,j)
	v_mx = [1 1 -1 -1] * B_xm([2 4 1 3],1:end)';	   % v11(j)   = dep(2,j)+dep(4,j)-dep(1,j)-dep(3,j) % a1(j,40) = v11(j)
	k = [14 15 25 26 37]; 
	v_mc(k,:) = 0;
	v_mx(k,:) = 0;
	v = [eyes(38) v_mc ; v_mc' 0] \ [v_mx ; 0];     % gauss(39,a1,v12)
	coef = 2*fe_A*fe_dZ/(v_mx'*v);                  % coef = coef + v11(j)*v12(j) % coef= (2.*aph*dzel)/coef
	IpDz_xm = [0 0.5*v'*coef];                      % a3ipz(j) = 0.5*v12(j)*coef
end

if ismember(zip_sel(3),[-3 -4 -5])               % nfast.eq.-3.or.nfast.eq.-4.or.nfast.eq.-5
	IpDz_xc_m = IpDz_xm_m*B_mc;                     % mulvm(a3ipz3,nprob,dex,nprob,ngroup1,a4ipz3)
end

if zip_sel(3) ~= 0                                           % nfast.ne.0
	v12 = M_vv \ M_va(:,end);                                   % a1(n,m) = elss(nshafa+n,nshafa+m) % a1(n,nvvel+1) = elss(nshafa+n,nshafa) % gauss(mat,a1,v12)   
	IpDz_xc(cond_n+2) = sum(-v12.*IpDz_xc(coil_n+1:end)'.*R_v); % a4ipz(ngroup1+1) = a4ipz(ngroup1+1)-v12(n)*a4ipz(nshafa+n)*resis(nshafa+n)
end

if midplan == 8
 v_fc  = sum(M_fc(2:end,[9 12]),2);
 v_fx1 = sum(M_xf([1 7],2:end),1)';
 v_fx2 = sum(M_xf([2 8],2:end),1)';
 v_fx3 = sum(M_xf([6 12 5 11],2:end),1)';
 v_fx4 = [1 1 -1 -1] * M_xf([6 12 5 11],2:end)';
	if magn_sel == 0
		k = [9 10 11 27 28 29];
  v_fc (k,:) = 0;
  v_fx1(k,:) = 0;
  v_fx2(k,:) = 0;
  v_fx3(k,:) = 0;
 end
 v = [eye(37) v_fx1 v_fx2 v_fc v_fx3; [[v_fx1 v_fx2 v_fc v_fx3]' zeros(4)]] \ [v_fx4 ; zeros(4,1)];
	IpDz_xf_t = [0 2*fe_A*fe_dZ/(v_fx3*v(1:37)).*v(1:37)]; 
	IpDz_xf_b = fliplr(IpDz_xf_t);
 
 v_mc  = sum(B_mc(:,[9 12]),2);
 v_mx1 = sum(B_xm([1 7],:),1)';
 v_mx2 = sum(B_xm([2 8],:),1)';
 v_mx3 = sum(B_xm([6 12 5 11],:),1)';
 v_mx4 = [1 1 -1 -1] * B_xm([6 12 5 11],2:end)';
 v = [eye(38) v_mx1 v_mx2 v_mc v_mx3; [[v_mx1 v_mx2 v_mc v_mx3]' zeros(4)]] \ [v_mx4 ; zeros(4,1)];
	IpDz_xm_t = [0 2*fe_A*fe_dZ/(Y(1:38)*v(1:38)).*v(1:38)]; 
	IpDz_xm_b = fliplr(IpDz_xm_t);
end

%% KAPPA OBSERVER
% Main equation: Fb = Mbx*Ix + Mba*Ia + Mbv*Iv
DZ2 = sum((fe_z - Z_pla(run_Sref)).^2)*fe_A;           % zsq=zsq+aph*(zel(m)-zax(nzaxre))**2
switch rem(kappa_sel,10)                               % mod(ifour,10).eq. % 5 % 4
 case 5,    Dz2 =    (fe_z - Z_pla(run_Sref)).^2*fe_A; % azels(m) = aph*(zel(m)-zax(nzaxre))**2
 case 4,    Dz2 = abs(fe_z - Z_pla(run_Sref))   *fe_A; % azels(m) = aph*abs(zel(m)-zax(nzaxre))
 otherwise, Dz2 = zeros(fe_NRZ,1);                     % azels(m) = 0.
end
if midplan == 8                                        % midplan.eq.8
%> move 1 statement to kappa observer JMM
	Dz2 = fe_A*fe_Z.^2; 		                                % azels(m) = aph*zel(m)*zel(m)
end
temp = Dz2'*A_xx_inv;
IpDz2_xf  = temp*M_xf_w;
IpDz2_xm  = temp*B_xm_w;
IpDz2_xc= temp*(M_xc + B_xc);

if wobble_freq == 1 %wobble
	% perhaps not necessary	(FP)	
end

%Flux matrix diagnostic
if diag_sel(1) == 1969
	% perhaps not necessary (FP)
end

%Time evolution
if rem(kappa_sel,10)==6 
		%ip_sel(1) == 6, plasma elongation control by ECRH power) option added (SC, 02/11/06)
	m = run_Sref; %m = run_n Use equilibrium run_Sref instead (SC 28.10.03)  
	if bound_exact_n > 0
		rb = bound_exact_r(m,1:bound_exact_n);					
		zb = bound_exact_z(m,1:bound_exact_n);					
	end
	if bound_approx_n > 0
		rb(bound_exact_n+1:bound_exact_n+bound_approx_n) = bound_approx_r(m,1:bound_approx_n); 
		zb(bound_exact_n+1:bound_exact_n+bound_approx_n) = bound_approx_z(m,1:bound_approx_n); 
	end
	M_bx 	= zeros(bound_n,fe_NRZ);
	M_bx	= greenem('m',rb,zb,mesh_r,mesh_z)*Txf; 
	M_bxf	= M_bx*A_xx_inv*M_xf_w;	
	M_bxm	= M_bx*A_xx_inv*B_xm_w;
	M_bxc	= M_bx*A_xx_inv*(M_xc + B_xc);		
	IpDz2_xf  = (-M_bxf(imax(zb),:)-M_bxf(imin(zb),:)+M_bxf(imax(rb),:)+M_bxf(imin(rb),:)).*69000;
	IpDz2_xm  = (-M_bxm(imax(zb),:)-M_bxm(imin(zb),:)+M_bxm(imax(rb),:)+M_bxm(imin(rb),:)).*69000;
	IpDz2_xc= (-M_bxc(imax(zb),:)-M_bxc(imin(zb),:)+M_bxc(imax(rb),:)+M_bxc(imin(rb),:)).*69000;
end








%---------------------------------------- 
%  Coils selection 
%%	COILNUM subroutine
%---------------------------------------- 
if Z_pla(1)<=0.11 & Z_pla(1)>=-0.11 & ip_sel(1)~=8 & ip_sel(1)~=18, 	midplan = 1; end
if Z_pla(1)< -0.11 & 		  ip_sel(1)~=8 & ip_sel(1)~=18, 	midplan = 37;end
if Z_pla(1)> 0.11 & 		  ip_sel(1)~=8 & ip_sel(1)~=18, 	midplan = 3; end
if rad_sel>2, 	rad_sel = 2; end
if rad_sel<-2, 	rad_sel =-2; end

moh(5:8) = [1 4 5 8];

switch midplan
 case 1,
	midplad = 1 + rad_sel;
	if midplad<1, midplad=midplad+38;end
	midout = 20 - rad_sel;
	mu(1:4) = [4 5 11 14];	
	moh(1:4)= [10 12 13 15];
 case 37,
	midplad = rad_sel + 37;
	if midplad>38, midplad=midplad-38;end
	midout = 22 - rad_sel;
	mu(1:4) = [3 4 10 13];
	moh(1:5)= [9 11 12 14 1];
 case 3,
	midplad = rad_sel + 3;
	midout = 18 - rad_sel;
	mu(1:4) = [5 6 12 15];
	moh(1:8)= [11 13 14 16 8 9 4 7];
 case 8,	%doublet
	midplab = 35; 
	midplat = 5;
	midoutb = 24;
	midoutt = 16;
	mu(1:8) = [6 7 13 16 3 2 12 9]; 
	moh(1:8)= [10 11 14 15 1 4 5 8];
	if kappa_sel == 8
		moh(1:8) = [2 3 6 7 1 4 5 8];
		mu(1:8)  = [9 10 11 12 13 14 15 16];
	end
end








%---------------------------------------- 
%  Magnetic fiel inside the vessel 
%%	BRBZEQ subroutine
%---------------------------------------- 
for m = 1:run_n  
	z_pla = sqrt(A_pla(m)*K_pla(m));		
	r_pla = z_pla/K_pla(m);
	L_pla(m) = greenem('m',R_pla(m),Z_pla(m),[r_pla z_pla]) + 2*Li_pla(m)*R_pla(m)*pi*1e-7;	

  	t_bz(m,:) = t0_bz; 
 	t_br(m,:) = t0_br; 

	if midplan == 8
		if m == 1
			iplatop=0;
			if R_pla_b(m)<0.01&Z_pla_t(m)<0, iplatop=-1;end  
			if R_pla_b(m)>0.01&Z_pla_t(m)<0, iplatop= 1;end  
		end	
		if R_pla_b(m)<0.01, R_pla_b(m)=R_pla_t(m); Z_pla_b(m)= Z_pla_t(m);end
		if Z_pla_t(m)<0,    Z_pla_t(m)=Z_pla_t(m); Z_pla_b(m)=-Z_pla_t(m);end
		dR_pla_t(:,m) = [R_pla_t(m)-t0_dr; R_pla_t(m)+t0_dr];	
		dR_pla_b(:,m) = [R_pla_b(m)-t0_dr; R_pla_b(m)+t0_dr];	
		temp = greenem('br',dR_pla_t(:,m),repmat(Z_pla_t(m),2,1),coil_Rw,coil_Zw)*T_wb*T_ba;	
		t_br(m,1:2) = t_br(m,1:2) + icoil(m,1:coil_n)*temp'; 
		%
		temp = greenem('bz',dR_pla_t(:,m),repmat(Z_pla_t(m),2,1),coil_Rw,coil_Zw)*T_wb*T_ba;	
		t_bz(m,1:2) = t_bz(m,1:2) + icoil(m,1:coil_n)*temp'; 
		%
		temp = greenem('br',dR_pla_b(:,m),repmat(Z_pla_b(m),2,1),coil_Rw,coil_Zw)*T_wb*T_ba;	
		t_br(m,3:4) = t_br(m,3:4) + icoil(m,1:coil_n)*temp'; 
		%
		temp = greenem('bz',dR_pla_b(:,m),repmat(Z_pla_b(m),2,1),coil_Rw,coil_Zw)*T_wb*T_ba;	
		t_bz(m,3:4) = t_bz(m,3:4) + icoil(m,1:coil_n)*temp'; 
	else
		dR_pla(:,m) = [R_pla(m)-t0_dr; R_pla(m)+t0_dr];
		temp = greenem('br',dR_pla(:,m),repmat(Z_pla(m),2,1),coil_Rw,coil_Zw)*T_wb*T_ba;	
		t_br(m,1:2) = t_br(m,1:2) + icoil(m,1:coil_n)*temp'; 
		%	
		temp = greenem('bz',dR_pla(:,m),repmat(Z_pla(m),2,1),coil_Rw,coil_Zw)*T_wb*T_ba;	
		t_bz(m,1:2) = t_bz(m,1:2) + icoil(m,1:coil_n)*temp'; 
	end 
end








%---------------------------------------- 
%  
%%	SCENARI subroutine
%---------------------------------------- 
if ip_sign==1,			ebias = 100;  end
if ip_sign==-1 & bt_sign==1,	ebias = -100;end 		 
if ip_sign==-1 & bt_sign==-1,	ebias = -100; end 		 
if midplan==8,			ebias = 50;  end	
	 
nip 	= 4;
nipm1 	= nip-1;
nip1	= nip+1; 
nip10	= nip+10;
nip11	= nip+11;
nflat	= nip10+run_n-1;
nflat1	= nflat+1;
if time_dil(2)>0 
	nend = nflat + run_n;
else
	nend = nflat;
end
diohdt_n 	= nend+2;
ntoftm1 = diohdt_n-1;

timeqe(1:run_n) = timeqe(1:run_n)*time_dil(1);

if length(diohdt_val)>=diohdt_n
	if ip_sign==1, diohdt_val(1:diohdt_n) =  diohdt_val(1:diohdt_n)*1e3;end  
	if ip_sign==-1,diohdt_val(1:diohdt_n) = -diohdt_val(1:diohdt_n)*1e3;end   
else
	if ip_sign==1, diohdt_val =  diohdt_val*1e3;end  
	if ip_sign==-1,diohdt_val = -diohdt_val*1e3;end   
end	
diohdt_val = [diohdt_val; zeros(diohdt_n-length(diohdt_val),1)];
%nip
for n = 1:nip
	Ip_oft(n) = 0;
	bt_oft(n) = bt(1);  bt_oft(1) = 0;
	pol_cur(n,1:16) = zeros(1,16);
	pol_cur(n,1:8) = ebias;
	pol_cur(n,mu(1:2)) = 0;
	if midplan == 8, pol_cur(n,mu(5:6)) = 0; end
	fl_oft(n,1:38) = zeros(1,38);
	bp_oft(n,1:38) = zeros(1,38);
	t0_br_oft(n,:) = t0_br;
	t0_bz_oft(n,:) = t0_bz;
	if ip_sign == 1
		bz_ramp = 0;
		if midplan==8, bz_ramp=zip_w(3); end   
	elseif ip_sign == -1
		bz_ramp = -0.01;
	end
	if n==2 | n==3 
		t0_bz_oft(n,:) = t0_bz + repmat(bz_ramp,1,4);
	end
	if midplan==8
		R_pla_oft(1:2,n) = [R_pla_t(1); R_pla_b(1)];	
		Z_pla_oft(1:2,n) = [Z_pla_t(1); Z_pla_b(1)];	
	else
		R_pla_oft(1,n) = R_pla(1);
		Z_pla_oft(1,n) = Z_pla(1);
	end
	zecorrb(n) = zecorb(1);
	zecorrt(n) = zecort(1);
end

%nip10
for n = nip1:nip10
	tfra = (diohdt_time(n)-diohdt_time(nip))/(diohdt_time(nip10)-diohdt_time(nip));
	tfra2 = tfra^2;
	Ip_oft(n) = pla_cur(1)*tfra2;
	bt_oft(n)  = bt(1);
	pol_cur(n,1:16) = icoil(1,1:16).*tfra2;   
	pol_cur(n,1:8)  = pol_cur(n,1:8) + ebias;  
	pol_cur(n,mu(1:2)) = pol_cur(n,mu(1:2))-ebias;
	if midplan == 8, pol_cur(nip1:nip10,mu(5:6)) = pol_cur(nip1:nip10,mu(5:6)) - ebias;end 
	fl_oft(n,1:38) = flux(1,1:38)-repmat(flux(1,1),1,38).*tfra2;
	bp_oft(n,1:38) = bpol(1,1:38).*tfra2;
	t0_br_oft(n,:) = t0_br_oft(nip,:) + (t_br(1,:)-t0_br_oft(nip,:)).*tfra^1.63;
	t0_bz_oft(n,:) = t0_bz_oft(nip,:) + (t_bz(1,:)-t0_bz_oft(nip,:)).*tfra.^1.63;
	if midplan == 8
		R_pla_oft(1:2,n) = [R_pla_t(1); R_pla_b(1)];	
		Z_pla_oft(1:2,n) = [Z_pla_t(1); Z_pla_b(1)];	
		zecorrb(n) = zecorb(1);
		zecorrt(n) = zecort(1);
	else
		R_pla_oft(1,n) = R_pla(1); 
		Z_pla_oft(1,n) = Z_pla(1);
	end
end

%nflat
for n = nip11:nflat
	m = n-nip10+1;
	Ip_oft(n) = pla_cur(m);
	bt_oft(n)  = bt(m);
	pol_cur(n,1:16) = icoil(m,1:16);
	pol_cur(n,1:8)  = pol_cur(n,1:8) + ebias;  
	pol_cur(n,mu(1:2)) = pol_cur(n,mu(1:2))-ebias;
	if midplan == 8, pol_cur(n,mu(5:6)) = pol_cur(n,mu(5:6)) - ebias;end 
	fl_oft(n,1:38) = flux(m,1:38)-flux(m,1);
	bp_oft(n,1:38) = bpol(m,1:38);
	t0_br_oft(n,:) = t_br(m,:);
	t0_bz_oft(n,:) = t_bz(m,:);
	if midplan == 8
		R_pla_oft(1:2,n) = [R_pla_t(m); R_pla_b(m)];	
		Z_pla_oft(1:2,n) = [Z_pla_t(m); Z_pla_b(m)];	
		zecorrb(n) = zecorb(m);
		zecorrt(n) = zecort(m);
	else
		R_pla_oft(n) = R_pla(m); 
		Z_pla_oft(n) = Z_pla(m);
	end

	if m > 1, diohdt_time(n) = timeqe(m) - timeqe(1) + diohdt_time(nip10); end
	if n < nflat,	
		dvsi = L_pla(m+1)*pla_cur(m+1) - L_pla(m)*pla_cur(m); 
		dvsr = vloop*(timeqe(m+1)-timeqe(m));
		dvss = -shvsec(m+1)+shvsec(m);
		dvsoh= dvsi+dvsr-dvss;
		vloopoh = dvsoh/(timeqe(m+1)-timeqe(m));
		if 	diohdt_sel ~= 2 | (diohdt_sel == 2 & diohdt_time(n) > 0.05)
			diohdt_val(n) = -vloopoh*15504; 
		end
	end
end
diohdt_val(nflat) = -vloop*15504;  
diohdt_time(nflat1) = diohdt_time(nflat)+time_flattop;

%nend
for n = nflat1:nend
	m = run_n+nflat1-n;
	nm = nflat+nflat1-n;
	Ip_oft(n) = Ip_oft(nm);
	bt_oft(n) = bt_oft(nm);
	pol_cur(n,1:16) = pol_cur(nm,1:16);
	fl_oft(n,:) = fl_oft(nm,:);  
	bp_oft(n,:) = bp_oft(nm,:);  
	t0_br_oft(n,:) = t0_br_oft(nm,:);
	t0_bz_oft(n,:) = t0_bz_oft(nm,:);
	R_pla_oft(:,n) = R_pla_oft(:,nm);
	Z_pla_oft(:,n) = Z_pla_oft(:,nm);
	%zecorrb(n) = zecorrb(nm); wrong! (FP, 24/02/09)
	%zecorrt(n) = zecorrt(nm); wrong! (FP, 24/02/09)
	if n > nflat1
		diohdt_time(n) = diohdt_time(nflat1) + (timeqe(run_n)-timeqe(m))*(time_dil(2)/time_dil(1));
	end
	if n < nend
		dvsi = L_pla(m-1)*pla_cur(m-1) - L_pla(m)*pla_cur(m); 
		dvsr = vloop*((timeqe(m)-timeqe(m-1))*time_dil(2)/time_dil(1));
		dvss = -shvsec(m-1)+shvsec(m);
		dvsoh= dvsi+dvsr-dvss;
		vloopoh = dvsoh/((timeqe(m)-timeqe(m-1))*time_dil(2)/time_dil(1));
		diohdt_val(n) = -vloopoh*15504;		 
	end
end
diohdt_val(nend) = diohdt_val(nend-1);
diohdt_time(ntoftm1) = diohdt_time(nend) + 0.015;
diohdt_time(diohdt_n) = diohdt_time(ntoftm1) + 0.25;

%diohdt_n
for n = ntoftm1:diohdt_n
	Ip_oft(n) = 0;
	bt_oft(n) = bt(1);
	pol_cur(n,1:16) = 0;
	fl_oft(n,:) = 0;
	bp_oft(n,:) = 0;
	t0_bz_oft(n,:) = t0_bz; 	 		
	t0_br_oft(n,:) = t0_br; 	 		
	if midplan == 8
		R_pla_oft(1:2,n) = [R_pla_t(1); R_pla_b(1)];	
		Z_pla_oft(1:2,n) = [Z_pla_t(1); Z_pla_b(1)];	
	else	
		R_pla_oft(n) = R_pla(1);
		Z_pla_oft(n) = Z_pla(1);
	end 
	zecorrb(n) = 0;
	zecorrt(n) = 0;	
end
bt_oft(diohdt_n) = 0;

ohcur(1) = 0;
for n = 2:ntoftm1
	ohcur(n) = ohcur(n-1) + diohdt_val(n-1).*(diohdt_time(n)-diohdt_time(n-1));
end
ohcur(diohdt_n) = 0;

diohdt_val(ntoftm1) = ohcur(ntoftm1)/(diohdt_time(diohdt_n)-diohdt_time(ntoftm1));
diohdt_val(diohdt_n) = 0;

aipcor(1:diohdt_n) = Ip_oft(1:diohdt_n).*ip_obs(1) + ip_obs(2); 

EF_Cur 	= zeros(mt,17);
R_ref	= zeros(mt,1);
Z_ref	= zeros(mt,1);
Z_ref_b	= zeros(mt,1);
Z_ref_m	= zeros(mt,1);
EF_Wave	= zeros(mt,24);






%---------------------------------------- 
%  
%%	BACKOFF subroutine
%---------------------------------------- 
% initial conditions were computed for OHCUR = 10kA and VLOOP = 7V
%	F-coils have 36 turns
%	VLOOP = 1V corresponds to diohdt_val=15504 A/s

if midplan == 1
	oh([1 4]) = if_obs(2)*(3.04/360);
	oh([2 3]) = if_obs(2)*(4.03/360);
	ve([1 4]) = -if_obs(3)*0.1385/(36*7*0.18);  			
	ve([2 3]) = -if_obs(3)*0.0538/(36*7*0.18);  			
	if bt_sign == 1
		oh(1) = (180+64)*if_obs(2)/21267;	
		oh(2) = (237-70)*if_obs(2)/21267;	
		oh(3) = 237*if_obs(2)/21267;	
		oh(4) = (180+52)*if_obs(2)/21267;	
		oh(5) = 190*if_obs(2)/21267;	
		oh(6) = 0;
		oh(7) = 0;
		oh(8) = 0;
		ve(1) = -442*if_obs(3)/168780;
		ve(2) = -172*if_obs(3)/168780;
		ve(3) = -149*if_obs(3)/168780;
		ve(4) = -450*if_obs(3)/168780;
		if bt(1) < 1.3 & shape_sel(1) == 5
			ve(1) = -292*if_obs(3)/168780;				
			ve(2) = -122*if_obs(3)/168780;				
			ve(3) = -99*if_obs(3)/168780;				
			ve(4) = -300*if_obs(3)/168780;				
		end 
		ve(5) = 0;
		ve(6) = 0;
		ve(7) = 0;
		ve(8) = 0;
		if shape_sel(1) == 7
			ve(1) = -532*if_obs(3)/168780;				
			ve(2) = -92*if_obs(3)/168780;				
			ve(3) = -124*if_obs(3)/168780;				
			ve(4) = -440*if_obs(3)/168780;				
		end 
		if shape_sel(1) == 8 & shape_sel(1) == 10
			% New coil combination for small plasmas (SC, 02/09/04 - 18/01/05)
			ve(1) = -476*if_obs(3)/168780;				
			ve(2) = -178*if_obs(3)/168780;				
			ve(3) = -116*if_obs(3)/168780;				
			ve(4) = -439*if_obs(3)/168780;				
		end 
	elseif bt_sign == -1	
		oh(1) = (180+162)*if_obs(2)/21267;	
		oh(2) = (237-63)*if_obs(2)/21267;	
		oh(3) = (237+36)*if_obs(2)/21267;	
		oh(4) = (180+162)*if_obs(2)/21267;	
		oh(5) = 135*if_obs(2)/21267;	
		oh(6) = 0;
		oh(7) = 0;
		oh(8) = 0;
		ve(1) = -442*if_obs(3)/168780;
		ve(2) = -172*if_obs(3)/168780;
		ve(3) = -149*if_obs(3)/168780;
		ve(4) = -450*if_obs(3)/168780;
		ve(5) = 0;
		ve(6) = 0;
		ve(7) = 0;
		ve(8) = 0;
	end
elseif midplan == 37
	oh(1) = 38*if_obs(2)/21267;	
	oh(2) = -10.4*if_obs(2)/21267;	
	oh(3) = 453.5*if_obs(2)/21267;	
	oh(4) = 213.9*if_obs(2)/21267;	
	oh(5) = 0;
	oh(6) = 0;
	oh(7) = 0;
	oh(8) = 0;
	ve(1) = -391*if_obs(3)/168780;
	ve(2) = -245*if_obs(3)/168780;
	ve(3) = 29*if_obs(3)/168780;
	ve(4) = -538*if_obs(3)/168780;
	ve(5) = 0;
	ve(6) = 0;
	ve(7) = 0;
	ve(8) = 0;
	if bt_sign == 1
		oh(1) = -34*if_obs(2)/21267;	
		oh(2) = 225*if_obs(2)/21267;	
		oh(3) = 202*if_obs(2)/21267;	
		oh(4) = 330*if_obs(2)/21267;	
		oh(5) = 100*if_obs(2)/21267;
		ve(1) = -442*if_obs(3)/168780;
		ve(2) = -90*if_obs(3)/168780;
		ve(3) = -162*if_obs(3)/168780;
		ve(4) = -405*if_obs(3)/168780;
		ve(5) = 100*if_obs(3)/168780;
	elseif bt_sign == -1	
		oh(1) = -154*if_obs(2)/21267;	
		oh(2) = 225*if_obs(2)/21267;	
		oh(3) = 202*if_obs(2)/21267;	
		oh(4) = 230*if_obs(2)/21267;	
		oh(5) = 20*if_obs(2)/21267;
		ve(1) = -442*if_obs(3)/168780;
		ve(2) = -90*if_obs(3)/168780;
		ve(3) = -162*if_obs(3)/168780;
		ve(4) = -405*if_obs(3)/168780;
		ve(5) = 20*if_obs(3)/168780;
	end
elseif midplan == 3
	oh(1) = 213.9*if_obs(2)/21267;	
	oh(2) = 453.5*if_obs(2)/21267;	
	oh(3) = -10.4*if_obs(2)/21267;	
	oh(4) = 38*if_obs(2)/21267;	
	oh(5) = 0;
	oh(6) = 0;
	oh(7) = 0;
	oh(8) = 0;
	ve(1) = -525*if_obs(3)/168780;
	ve(2) = -30*if_obs(3)/168780;
	ve(3) = 172*if_obs(3)/168780;
	ve(4) = -411*if_obs(3)/168780;
	ve(5) = 0;
	ve(6) = 0;
	ve(7) = 0;
	ve(8) = 0;
	if bt_sign == 1
		oh(1) = 310*if_obs(2)/21267;	
		oh(2) = 224*if_obs(2)/21267;	
		oh(3) = 215*if_obs(2)/21267;	
		oh(4) = -51*if_obs(2)/21267;	
		oh(5) = 100*if_obs(2)/21267;
		%Modif CN 27.11.96
		ve(1) = (-461-100)*if_obs(3)/168780;
		ve(2) = (-117-130)*if_obs(3)/168780;
		ve(3) = (-91-130)*if_obs(3)/168780;
		ve(4) = (-435+320)*if_obs(3)/168780;
		ve(5) = 100*if_obs(3)/168780;
	elseif bt_sign == -1	
		oh(1) = 230*if_obs(2)/21267;	
		oh(2) = 202*if_obs(2)/21267;	
		oh(3) = 225*if_obs(2)/21267;	
		oh(4) = -34*if_obs(2)/21267;	
		oh(5) = 0;
		oh(6) = -80*if_obs(2)/21267;	
		ve(1) = -419*if_obs(3)/168780;
		ve(2) = -172*if_obs(3)/168780;
		ve(3) = -82*if_obs(3)/168780;
		ve(4) = -329*if_obs(3)/168780;
		ve(5) = 0;
		ve(6) = -80*if_obs(3)/168780;
	end
elseif midplan == 8
	% Different backoffs are in the fortran version (commented)
	% We need to verify the best set of corrections
	oh(1) = -254*if_obs(2)/21267;	
	oh(2) = 536*if_obs(2)/21267;	
	oh(3) = 536*if_obs(2)/21267;	
	oh(4) = -254*if_obs(2)/21267;	
	oh(5) = 50*if_obs(2)/21267;	
	oh(6) = 0;
	oh(7) = 0;
	oh(8) = 50*if_obs(2)/21267;
	ve(1) = -454*if_obs(3)/169160;
	ve(2) = -131*if_obs(3)/169160;
	ve(3) = -68*if_obs(3)/169160;
	ve(4) = -404*if_obs(3)/169160;
	ve(5) = -50*if_obs(3)/169160;
	ve(6) = 0;
	ve(7) = 0;
	ve(8) = -50*if_obs(3)/169160;
	if kappa_sel == 8
		oh(1) = 0; 
		oh(2) = 0; 
		oh(3) = 0; 
		oh(4) = 0; 
		oh(5) = 0; 
		oh(6) = 0;
		oh(7) = 0;
		oh(8) = 0;
		ve(1) = 0;
		ve(2) = 0;
		ve(3) = 0;
		ve(4) = 0;
		ve(5) = -100*if_obs(3)/169160;
		ve(6) = -200*if_obs(3)/169160;
		ve(7) = -200*if_obs(3)/169160;
		ve(8) = -100*if_obs(3)/169160;
	end	
end






%---------------------------------------- 
%  
%%	INITIAL subroutine
%---------------------------------------- 

t(1) 		= diohdt_time(1);
I_cond(:,1) 	= zeros(cond_n,1);
VES_CUR(1) 	= 0;
Rpla(:,1)	= R_pla_oft(:,1);
Zpla(:,1) 	= Z_pla_oft(:,1);  
bz_p(:,1) 	= t0_bz_oft(1,:)'; 
br_p(:,1)	= t0_br_oft(1,:)'; 

Ip(1)	 	= Ip_oft(1);
I_cond([17 18]) = ohcur(1);

% Mutual between plasma current and conductors
M_pa(:,:,1) = greenem('m',Rpla,Zpla,coil_Rw,coil_Zw)*T_wb*T_ba;
M_pv(:,:,1) = greenem('m',Rpla,Zpla,vessel_R,vessel_Z);
M_pc(:,:,1) = [M_pa(:,:,1) M_pv(:,:,1)];

% Add doublet case



%-------------------------------------------------------------------------------- 
%%	START TIME LOOP	
%--------------------------------------------------------------------------------    
iiout = 0;
for it=2:run_t_n





%---------------------------------------- 
%  
%%	REFER subroutine
%---------------------------------------- 
% Compute input variables at end of time step
if 	t(it-1)>=diohdt_time(1) 		& t(it-1)<(diohdt_time(2)-0.02), 	deltat(it-1) = early_dt(2); end 
if 	t(it-1)>=(diohdt_time(2)-0.02)		& t(it-1)<diohdt_time(nip10+4),		deltat(it-1) = early_dt(1); end
if      t(it-1)>=diohdt_time(nip10+4)		& t(it-1)<(diohdt_time(nflat)+0.02),	deltat(it-1) = early_dt(2); end
if      t(it-1)>=(diohdt_time(nflat)+0.02)	& t(it-1)<(diohdt_time(nflat1)-0.02),	deltat(it-1) = early_dt(5); end
if 	t(it-1)>=(diohdt_time(nflat1)-0.02)						deltat(it-1) = early_dt(2); end

t(it) = t(it-1) + deltat(it-1);
if t(it) > (diohdt_time(diohdt_n)+deltat(it-1)), iiout = 1; t=t(1:end-1); break, end %goto end loop

n = min(find(diohdt_time>t(it)));
if isempty(n), n = diohdt_n; end

tfra		= (t(it) - diohdt_time(n-1))/(diohdt_time(n)-diohdt_time(n-1));
Rpla(:,it) 	= R_pla_oft(:,n-1) + (R_pla_oft(:,n)-R_pla_oft(:,n-1))*tfra;
Zpla(:,it) 	= Z_pla_oft(:,n-1) + (Z_pla_oft(:,n)-Z_pla_oft(:,n-1))*tfra;
bz_p(:,it)	= t0_bz_oft(n-1,:)' + (t0_bz_oft(n,:)-t0_bz_oft(n-1,:))'.*tfra;  
br_p(:,it)	= t0_br_oft(n-1,:)' + (t0_br_oft(n,:)-t0_br_oft(n-1,:))'.*tfra;  

Ip(it)	 	= Ip_oft(n-1) + (Ip_oft(n)-Ip_oft(n-1))*tfra; 

k = 1:16; k(mu) = []; %Current in control coils = 0
I_cond(k,it) = pol_cur(n-1,k)' + (pol_cur(n,k)-pol_cur(n-1,k))'*tfra;

k = 1:38;
fl_it(k,it) = fl_oft(n-1,k)' + (fl_oft(n,k)-fl_oft(n-1,k))'*tfra; 
bp_it(k,it) = bp_oft(n-1,k)' + (bp_oft(n,k)-bp_oft(n-1,k))'*tfra;

I_cond(17,it) = ohcur(n-1) + (ohcur(n)-ohcur(n-1))*tfra;
I_cond(18,it) = I_cond(17,it);

k=1:8;
I_cond(moh(k),it) = I_cond(moh(k),it) + I_cond(17,it).*oh(k)' + VES_CUR(it-1).*ve(k)';






%---------------------------------------- 
%  
%%	MUTBRBZ subroutine
%---------------------------------------- 

% Mutual between plasma current and conductors
M_pa(:,:,it) = greenem('m',Rpla(:,it),Zpla(:,it),coil_Rw,coil_Zw)*T_wb*T_ba;
M_pv(:,:,it) = greenem('m',Rpla(:,it),Zpla(:,it),vessel_R,vessel_Z);
M_pc(:,:,it) = [M_pa(:,:,it) M_pv(:,:,it)];

% Magnetic field at the plasma position from conductors
B_pa([1,3],1:coil_n,it) = (greenem('bz',[Rpla(1,it)-t0_dr Rpla(1,it)+t0_dr],[Zpla(1,it) Zpla(1,it)],coil_Rw,coil_Zw)*T_wb*T_ba);
B_pa([2,4],1:coil_n,it) = (greenem('br',[Rpla(1,it)-t0_dr Rpla(1,it)+t0_dr],[Zpla(1,it) Zpla(1,it)],coil_Rw,coil_Zw)*T_wb*T_ba);
%
B_pv([1,3],1:vessel_n,it) = greenem('bz',[Rpla(1,it)-t0_dr Rpla(1,it)+t0_dr],[Zpla(1,it) Zpla(1,it)],vessel_R,vessel_Z);
B_pv([2,4],1:vessel_n,it) = greenem('br',[Rpla(1,it)-t0_dr Rpla(1,it)+t0_dr],[Zpla(1,it) Zpla(1,it)],vessel_R,vessel_Z);

if midplan == 8
	% Magnetic field at the plasma position from conductors (bottom plasma)
	B_pa([5,7],1:coil_n,it) = (greenem('bz',[Rpla(2,it)-t0_dr Rpla(2,it)+t0_dr],[Zpla(2,it) Zpla(2,it)],coil_Rw,coil_Zw)*T_wb*T_ba);
	B_pa([6,8],1:coil_n,it) = (greenem('br',[Rpla(2,it)-t0_dr Rpla(2,it)+t0_dr],[Zpla(2,it) Zpla(2,it)],coil_Rw,coil_Zw)*T_wb*T_ba);
	%
	B_pv([5,7],1:vessel_n,it) = greenem('bz',[Rpla(2,it)-t0_dr Rpla(2,it)+t0_dr],[Zpla(2,it) Zpla(2,it)],vessel_R,vessel_Z);
	B_pv([6,8],1:vessel_n,it) = greenem('br',[Rpla(2,it)-t0_dr Rpla(2,it)+t0_dr],[Zpla(2,it) Zpla(2,it)],vessel_R,vessel_Z);
end

B_pc(:,:,it) = [B_pa(:,:,it) B_pv(:,:,it)];

%Toroidal current contribution (connection of toroidal coils)
tor_R = [1.554 1.717 1.754]; 	%Radial position
tor_Z = [-0.78 -0.78 -0.78]; 	%Vertical position
tor_W = [-26/68 -42/68 1]; 	%Weight from current distribution	

B_pT([1,3],1,it) = (greenem('bz',[Rpla(1,it)-t0_dr Rpla(1,it)+t0_dr],[Zpla(1,it) Zpla(1,it)],tor_R,tor_Z)*tor_W');
B_pT([2,4],1,it) = (greenem('br',[Rpla(1,it)-t0_dr Rpla(1,it)+t0_dr],[Zpla(1,it) Zpla(1,it)],tor_R,tor_Z)*tor_W');

if midplan == 8
	%Bottom plasma
	B_pT([5,7],1,it) = (greenem('bz',[Rpla(2,it)-t0_dr Rpla(2,it)+t0_dr],[Zpla(2,it) Zpla(2,it)],tor_R,tor_Z)*tor_W');
	B_pT([6,8],1,it) = (greenem('br',[Rpla(2,it)-t0_dr Rpla(2,it)+t0_dr],[Zpla(2,it) Zpla(2,it)],tor_R,tor_Z)*tor_W');
end








%---------------------------------------- 
%  
%%	CURRENT subroutine
%---------------------------------------- 
% Currents at end of time step
if 	bt_sign == 1, bt_norm = bt(1)/1.43; 
elseif	bt_sign == -1,bt_norm = -bt(1)/1.43;
end
%keyboard
% Equationi 1 (vessel)
% 0 = Rv*Iv(k)*Dt + Mvv*(Iv(k)-I(k-1)) + Mva*(Iap(k)-Iap(k-1)) + 
%	Mvp(k)*Ip(k) - Mvp(k-1)*Ip(k-1) + Mva*DIam(k)
% Equation 2 (Magnetic field imposed in the control points)
% Bp_rz(k) = Bpa*Ia(k) + Bpv*Iv(k) 	
ind = [coil_n+1:cond_n];

if midplan == 8
	if iplatop == 0
		pla_ter = -0.5*(M_pc(1,ind,it)' + M_pc(2,ind,it)')*Ip(it) +  ...
			   0.5*(M_pc(1,ind,it-1)' + M_pc(2,ind,it-1)')*Ip(it-1);
	elseif iplatop == 1
		pla_ter = -M_pc(1,ind,it)'*Ip(it) + M_pc(1,ind,it-1)'*Ip(it-1);
	elseif iplatop == -1
		pla_ter = -M_pc(2,ind,it)'*Ip(it) + M_pc(2,ind,it-1)'*Ip(it-1);
	end	
else
	pla_ter = -M_pc(1,ind,it)'*Ip(it) + M_pc(1,ind,it-1)'*Ip(it-1);
end

Y1(1:vessel_n,1) = M_vv*I_cond(ind,it-1) + pla_ter - M_va*(I_cond(1:coil_n,it) - I_cond(1:coil_n,it-1)); 

if 	midplan == 3
	Y2([1 3],1) = bz_p(1:2,it) - 150e-6*bt_norm;   
	Y2([2 4],1) = br_p(1:2,it) + 420e-6*bt_norm;   

elseif 	midplan == 1
	Y2([1 3],1) = bz_p(1:2,it) + 210e-6*bt_norm;   
	Y2([2 4],1) = br_p(1:2,it) + 690e-6*bt_norm;   

elseif 	midplan == 37 
	Y2([1 3],1) = bz_p(1:2,it) + 860e-6*bt_norm;   
	Y2([2 4],1) = br_p(1:2,it) + 910e-6*bt_norm;   

elseif 	midplan == 8 
	Y2([1 3 5 7],1) = bz_p(:,it);   
	Y2([2 4 6 8],1) = br_p(:,it);   
	Y2 = Y2 - B_pT*65e3*bt_norm; 
end

Y2 = Y2 - B_pa(:,:,it)*I_cond(1:coil_n,it); 
Y(:,it) = [Y1; Y2];

A = [	M_vv + diag(R_v)*deltat(it-1)	M_va(:,mu);
	B_pv(:,:,it)			B_pa(:,mu,it) ];

X(:,it) = A\Y(:,it); %Find currents

I_cond([ind mu],it) = X(:,it);

Bz_point(:,it) 	= B_pc([1,3],:,it)*I_cond(:,it);
Bz_mean(it)  	= mean(Bz_point(:,it)); 	
En(it)		= diff(Bz_point(:,it))*Rpla(it)/(2*t0_dr*Bz_mean(it)); 

V_loop(:,it)  = -M_pc(:,:,it)*(I_cond(:,it)-I_cond(:,it-1))./deltat(it-1);  

VES_CUR(it) = sum(I_cond(coil_n+1:end,it));







%---------------------------------------- 
%  
%%	DIAGNOS subroutine
%---------------------------------------- 
if diag_vac==1 & t(it)>=diag_time & t(it)<diag_time+deltat(it-1)
	% Breakdown field at t = diag_time

end  








%---------------------------------------- 
%  
%%	WAVGEN1 subroutine
%---------------------------------------- 
% Coil voltages
% Resistive voltage is normally added through the M-matrix and is not included
% in the feedforward voltages

if midplan == 8
	if iplatop == 0
		Volts(:,it) = (M_cc(1:coil_n,:)*(I_cond(:,it) - I_cond(:,it-1)) + ...
			0.5*(M_pa(1,:,it)' + M_pa(2,:,it)')*Ip(it) - ...
			0.5*(M_pa(1,:,it-1)' + M_pa(2,:,it-1)')*Ip(it-1))./deltat(it-1);
	elseif iplatop == 1
		Volts(:,it) = (M_cc(1:coil_n,:)*(I_cond(:,it) - I_cond(:,it-1)) + ...
			M_pa(1,:,it)'*Ip(it) - M_pa(1,:,it-1)'*Ip(it-1))./deltat(it-1);
	elseif iplatop == -1
		Volts(:,it) = (M_cc(1:coil_n,:)*(I_cond(:,it) - I_cond(:,it-1)) + ...
			M_pa(2,:,it)'*Ip(it) - M_pa(2,:,it-1)'*Ip(it-1))./deltat(it-1);
	end
else
	Volts(:,it) = (M_cc(1:coil_n,:)*(I_cond(:,it) - I_cond(:,it-1)) + ...
		M_pa(:,:,it)'*Ip(it) - M_pa(:,:,it-1)'*Ip(it-1))./deltat(it-1);
end

Amps(1:coil_n+10,it) = zeros(coil_n+10,1);
Amps(1:coil_n,it) = I_cond(1:coil_n,it);

t_switch = 0.01;
if t(it) <= t_switch
	fl_pre = -M_fc*(I_cond(:,it).*[ones(coil_n,1); R_v]); 			
	bp_pre = B_mc*(I_cond(:,it).*[ones(coil_n,1); R_v]); 			
	if t(it) <= 0
		fl_xx(:,it) 	= fl_pre;
		bp_xx(:,it) 	= bp_pre;
		Dfl_fact(it)	= 1;
	elseif t(it) > 0
		tfra = t(it)/t_switch;	
		fl_xx(:,it) 	= fl_pre + (fl_it(:,it)-fl_pre).*tfra;
		bp_xx(:,it) 	= bp_pre + (bp_it(:,it)-bp_pre).*tfra;
		Dfl_fact(it)	= 1 + (rad_obs(1)-1)*tfra;
	end
elseif t(it) > t_switch
	fl_xx(:,it) 	= fl_it(:,it);
	bp_xx(:,it) 	= bp_it(:,it);
	Dfl_fact(it) 	= rad_obs(1);	
end

if midplan ~= 8
	IpDz_cor(it)   = 0;
	IpDz_cor_3(it) = 0;
	IpDz_cor_4(it) = 0;
	% Coil correction allowed for zip_sel(1)=3 or 4 (SC, 31/03/05)
	if zip_sel(1)~=3&zip_sel(1)~=4
		IpDz_cor(it) = -IpDz_xc(1:16)*I_cond(1:16,it);  
	end
	% zip_obs(5) correction disabled for t < 0 (when vertical control is inactive anyway)
	%	to avoid triggering disruption detector (SC, 16/02/05)
	if t(it) > 0
		if zip_sel(1)~=3&zip_sel(1)~=4
			IpDz_cor(it) = IpDz_cor(it) - IpDz_xc(17:18)*(I_cond(17:18,it).*[1-zip_obs(5);1+zip_obs(5)]);		
		else
		% Coil correction allowed for zip_sel(1)=3 or 4 (SC, 31/03/05)
			IpDz_cor(it) = IpDz_cor(it) - IpDz_xc(17:18)*(I_cond(17:18,it).*[-zip_obs(5);zip_obs(5)]);		
		end
		Ip_ss(it) = 5000;
	else
		Ip_ss(it) = 0;
	end
	
	% Vessel correction
	IpDz_cor(it) = IpDz_cor(it) - IpDz_xc(coil_n+1:cond_n)*(I_cond(coil_n+1:end,it).*R_v);
	
	if zip_sel(2) == 2
		% No coil correction in derivative feedback (SC, 31/03/05)
		% zip_sel(1) = 4 option introduced (SC, 21/04/05) 	
		if zip_sel(1) ~= 4
			IpDz_cor_3(it) = IpDz_xc_m(1:16)*I_cond(1:16,it);	
		else
			IpDz_cor_3(it) = IpDz_xc(1:16)*I_cond(1:16,it);	
			IpDz_cor_4(it) = IpDz_xc_m(1:16)*I_cond(1:16,it);	
		end
	
		% zip_obs(5) correction disabled for t < 0 (when vertical control is inactive anyway)
		%	to avoid triggering disruption detector (SC, 16/02/05)
		if t(it) > 0
			if zip_sel(1) ~= 4
				IpDz_cor_3(it) = IpDz_cor_3(it) - ...
					IpDz_xc_m(17:18)*(I_cond(17:18,it).*[1-zip_obs(5);1+zip_obs(5)]);		
			else
				IpDz_cor_3(it) = IpDz_cor_3(it) - ...
					IpDz_xc(17:18)*(I_cond(17:18,it).*[1-zip_obs(5);1+zip_obs(5)]);		
				IpDz_cor_4(it) = IpDz_cor_4(it) - ...
					IpDz_xc_m(17:18)*(I_cond(17:18,it).*[1-zip_obs(5);1+zip_obs(5)]);		
			end
		end
		
		% Vessel correction
		if zip_sel(1) ~= 4
			IpDz_cor_3(it) = IpDz_cor_3(it) - IpDz_xc_m(coil_n+1:cond_n)*(I_cond(coil_n+1:end,it).*R_v);
		else
			IpDz_cor_3(it) = IpDz_cor_3(it) - IpDz_xc(coil_n+1:cond_n)*(I_cond(coil_n+1:end,it).*R_v);
			IpDz_cor_4(it) = IpDz_cor_4(it) - IpDz_xc_m(coil_n+1:cond_n)*(I_cond(coil_n+1:end,it).*R_v);
		end
	end
	
	Ip_scale(it) = Ip(it)*1e-6;
	
	% Wobble
	wobble = 0;
	if t(it)>diohdt_time(nflat)&t(it)<=diohdt_time(nflat1)
		temp = sin(t(it)-diohdt_time(nflat)*2*pi*wobble_freq);
		if 	temp > 0, wobble = 1;
		elseif	temp < 0, wobble = -1;
		end 
	end 
	Z_cor(it) = wobble*wobble_ampl + zip_obs(4);
	
	zeec = Ip_scale(it)^2*Z_cor(it) + (Zpla(it)-Z_pla(run_Sref))*Ip(it);
	
	Amps(coil_n+1,it) = zip_obs(2) + Ip_ss(it)*zip_obs(3) + zeec - IpDz_cor(it);
	
	if zip_sel(2) == 2
		Amps(coil_n+3,it) = zip_obs(2) + Ip_ss(it)*zip_obs(3) + zeec - IpDz_cor_3(it);
		% zip_sel(1) = 4 option introduced (SC, 21/04/05)
		if zip_sel(1) == 4
			Amps(coil_n+7,it) = zip_obs(2) + Ip_ss(it)*zip_obs(3) + zeec - IpDz_cor_4(it);
		end
	end
	
	Dflux(it) = (	fl_xx(midplad,it) - fl_xx(midout,it) + ...
			bp_xx(midplad,it)*rad_gap(1)*bp_r(midplad)*2*pi - ...
			bp_xx(midout,it)*rad_gap(2)*bp_r(midout)*2*pi)*Dfl_fact(it) + rad_obs(2);
	tfra = (t(it) - diohdt_time(nip))/(diohdt_time(nend)-diohdt_time(nip)); 		
	R_shift(it) = rad_obs(3) + (rad_obs(4)-rad_obs(3))*tfra; 
	Amps(coil_n+2,it) = (-Dflux(it) + Ip_scale(it)*R_shift(it) + Ip_scale(it)^2*rad_obs(5))*rad_obs(6);

elseif midplan == 8
	if t(it)<=0, 	Ip_ss(it) = 0;
	elseif t(it)>0, Ip_ss(it) = 5000;
	end
	IpDz_cor_b(it) 	= -zip_w(2)*IpDz_xf_b*fl_xx(:,it) + (1-zip_w(2))*IpDz_xm_b*bp_xx(:,it);
	IpDz_cor_t(it) 	= -zip_w(2)*IpDz_xf_t*fl_xx(:,it) + (1-zip_w(2))*IpDz_xm_t*bp_xx(:,it);
	IpDz_cor(it) 	= -zip_w(2)*IpDz_xf*fl_xx(:,it) + (1-zip_w(2))*IpDz_xm*bp_xx(:,it);
	Ip_scale(it) 	= Ip(it)*1e-6;
	%
	zeec_b = -Ip_scale(it)^2*zip_obs(4);
	zeec_t = Ip_scale(it)^2*zip_obs(4);
	%
	Amps(coil_n+1,it) = zip_obs(2) + Ip_ss(it)*zip_obs(3) + zeec_t - IpDz_cor_t(it);
	Amps(coil_n+3,it) = -zip_obs(2) + Ip_ss(it)*zip_obs(3) + zeec_b - IpDz_cor_b(it);
	% Ohcorr correction disabled for time<0 (when vertical control is inactive anyway)
	% to avoid triggering of disruption detector
	if t(it) > 0
		Amps(coil_n+1,it) = Amps(coil_n+1,it) + zip_obs(5)*Ip_scale(it)^2*I_cond(17,it);
		Amps(coil_n+3,it) = Amps(coil_n+3,it) + zip_obs(5)*Ip_scale(it)^2*I_cond(17,it);
	end	
	Amps(coil_n+5,it) = IpDz_cor(it);
	%	
	tfra = (t(it) - diohdt_time(nip))/(diohdt_time(nend)-diohdt_time(nip)); 		
	R_shift(it) = rad_obs(3) + (rad_obs(4)-rad_obs(3))*tfra; 
	%
	Dfl_t(it) = (	fl_xx(midplat,it) - fl_xx(midout,it) + ...
			bp_xx(midplat,it)*rad_gap(1)*bp_r(midplat)*2*pi - ...
			bp_xx(midoutt,it)*rad_gap(2)*bp_r(midoutt)*2*pi)*Dfl_fact(it) + rad_obs(2);
	Amps(coil_n+2,it) = (-Dfl_t(it) + Ip_scale(it)*R_shift(it) + Ip_scale(it)^2*rad_obs(5))*rad_obs(6);
	%	
	Dfl_b(it) = (	fl_xx(midplab,it) - fl_xx(midoutb,it) + ...
			bp_xx(midplab,it)*rad_gap(1)*bp_r(midplab)*2*pi - ...
			bp_xx(midoutb,it)*rad_gap(2)*bp_r(midoutb)*2*pi)*Dfl_fact(it) + rad_obs(2);
	Amps(coil_n+4,it) = (-Dfl_b(it) + Ip_scale(it)*R_shift(it) + Ip_scale(it)^2*rad_obs(5))*rad_obs(6);
end

% Added kappa reference correctors (SC, 14/05/04)		
IpDz_k(it) = kappa_gain(2) + abs(Ip_scale(it))*kappa_gain(3);
if kappa_sel < 20
	IpDz_k(it) = IpDz_k(it) - IpDz2_xf*fl_it(:,it) + IpDz2_xm*bp_it(:,it);	
else
	if rem(kappa_sel,10)==5
		IpDz_k(it) = IpDz_k(it) + (Zpla(it)-Z_pla(run_Sref))^2*Ip(it); 	
	elseif rem(kappa_sel,10)==4
		IpDz_k(it) = IpDz_k(it) + abs(Zpla(it)-Z_pla(run_Sref))*Ip(it); 	
	elseif rem(kappa_sel,10)==6
		%This is not implemented yet, needs fluxerr (?)
	end
end
% Added possibility of subtracting coil + vessel current corrections (SC, 13/05/04)
if kappa_sel>=10&kappa_sel<30
	IpDz_k(it) = IpDz_k(it) - IpDz2_xc(1:coil_n)*I_cond(1:coil_n,it); 
end
%
Amps(coil_n+6,it) = IpDz_k(it);





%--------------------------------------------------------------------------------   
%%	END LOOP
%--------------------------------------------------------------------------------   
end

%---------------------------------------- 
%  
%%	WAVGEN2 subroutine
%---------------------------------------- 

ramp = [0 0.03 0.12 0.24 0.37 0.5 0.63 0.76 0.88 0.97];
Volts(:,1:length(ramp))	= Volts(:,1:length(ramp)).*repmat(ramp,coil_n,1);
Amps(:,1:length(ramp))	= Amps(:,1:length(ramp)).*repmat(ramp,length(Amps(:,1)),1);

% No filtered quantities
Amps_nf = [Amps(:,2:end) zeros(length(Amps(:,1)),50)];
t_nf	= [t(2:end) zeros(1,50)];
Volts   = [Volts(:,2:end) zeros(length(Volts(:,1)),50)];
clear Amps t

%FILTERS
% t < diohdt_time(2)-0.02 
t(1) 	= t_nf(1);
n 	= 2;
for i=3:2:it-2
	if t_nf(i) > diohdt_time(2)-0.02, break, end
	t(n) = t_nf(i);
	EF_Volts(:,n) = sum(0.25*Volts(:,[i-1 i+1]),2) + 0.5*Volts(:,i); 
	Amps(:,n)  = sum(0.25*Amps_nf(:,[i-1 i+1]),2)  + 0.5*Amps_nf(:,i); 
	n = n+1;	
end

% t < diohdt_time(nip10+4) 
istart = i;

for i=istart:it-2
	if t_nf(i) > diohdt_time(nip10+4), break, end
	t(n) = t_nf(i);
	EF_Volts(:,n) = sum(0.125*Volts(:,[i-2 i+2]),2) + sum(0.25*Volts(:,[i-1 i i+1]),2); 
	Amps(:,n)  = sum(0.25*Amps_nf(:,[i-1 i+1]),2)   + 0.5*Amps_nf(:,i); 
	n = n+1;	
end

% t < end-1 
istart = i;
for i=istart:3:it-3
	t(n) = t_nf(i);
	EF_Volts(:,n) = sum(1/9*Volts(:,[i-2 i+2]),2) + sum(2/9*Volts(:,[i-1 i+1]),2) + 1/3*Volts(:,i); 
	Amps(:,n)  = sum(1/9*Amps_nf(:,[i-2 i+2]),2)  + sum(2/9*Amps_nf(:,[i-1 i+1]),2)  + 1/3*Amps_nf(:,i); 
	if wobble_ampl ~= 0, Amps(coil_n+1,n) = Amps_nf(coil_n+1,i);end 
	n = n+1;	
end

NT = n-1;
EF_Volts = EF_Volts';
EF_Volts(1,:) = 0;

EF_Cur = Amps(1:17,:)';
EF_Cur(1,:) = 0;

Z_ref(1:NT) 	= Amps(coil_n+1,:)';
R_ref(1:NT) 	= Amps(coil_n+2,:)';
Z_ref_b(1:NT) 	= Amps(coil_n+3,:)';
R_ref_b(1:NT)	= Amps(coil_n+4,:)';
Z_ref_m(1:NT)	= Amps(coil_n+5,:)';
K_ref(1:NT) 	= Amps(coil_n+6,:)';
ohcur		= zeros(size(ohcur));

cur_to_wave = eye(16);
switch shape_sel(1)
  case  1, 
    cur_to_wave([mu(3),mu(4)],[mu(3),mu(4)]) = [1,-1;1,1]/2;
  case  2, 
    cur_to_wave([moh(1),mu(3)],[moh(1),mu(3)]) = [1,-1;1,1]/2;
    cur_to_wave([moh(4),mu(4)],[moh(4),mu(4)]) = [1,-1;1,1]/2;
  case  3, 
    shapcoils=[10:12,14:16];
    if zax1<0,shapcoils=shapcoils-1;end
    cur_to_wave(shapcoils,shapcoils) = ...
	[[1,-1,0,0,1,-1]/4;[omal,0,-opal,-opal,0,omal]*ompsq/4; ...
	 [opal,0,omal,omal,0,opal]*ompsq/4;[0,0,-1,1,0,0]/2; ...
	 [0,1,0,0,1,0]/2;[-1,-1,0,0,1,1]/4];
  case  4, 
    cur_to_wave([9:11,14:16],[9:11,14:16]) = ...
	[[0,1,-1,-1,1,0]/4;[-1,1,0,0,-1,1]/4;[0,1,1,1,1,0]/4; ...
	 [0,0,-1,1,0,0]/2;[1,0,0,0,0,1]/2;[-1,-1,0,0,1,1]/4];
  case  5, 
    cur_to_wave([10:12,14:16],[10:12,14:16]) = ...
	[[0,-1,1,-1,1,0]/4;[-omal,0,opal,opal,0,-omal]*ompsq/4; ...
	 [opal,0,omal,omal,0,opal]*ompsq/4;[-1,0,0,0,0,1]/2; ...
	 [0,1,0,0,1,0]/2;[0,-1,-1,1,1,0]/4];
  case  6, 
    cur_to_wave([9,11:14,16],[9,11:14,16]) = ...
	[[-omal,opal,0,0,opal,-omal]*ompsq/4;[0,1,-1,1,-1,0]/4;; ...
	 [opal,omal,0,0,omal,opal]*ompsq/4;[-1,0,0,0,0,1]/2; ...
	 [0,0,1,1,0,0]/2;[0,-1,-1,1,1,0]/4];
  case  7, 
    cur_to_wave([11,12],[11,12]) = [1,-1;1,1]/2;
    cur_to_wave([15,14],[15,14]) = [1,-1;1,1]/2;
  case  8, 
    cur_to_wave(12:15,12:15) = [1,-1,1,-1;-1,-1,1,1; ...
			ompsq*[opal,omal,omal,opal;omal,-opal,-opal,omal]]/4;
  case  9, 
    cur_to_wave(11:16,11:16) = ...
	[[0,omal,-opal,-opal,omal,0]*ompsq/4;[-1,1,-0,0,-1,1]/4;; ...
	 [0,opal,omal,omal,opal,0]*ompsq/4;[0,0,-1,1,0,0]/2; ...
	 [1,0,0,0,0,1]/2;[-1,-1,0,0,1,1]/4];
  case  10, 
    cur_to_wave(13:16,13:16) = [1,-1,1,-1;-1,-1,1,1; ...
			ompsq*[opal,omal,omal,opal;omal,-opal,-opal,omal]]/4;
  case  12, 
    cur_to_wave([moh(1),mu(3),moh(2),moh(3),mu(4),moh(4)], ...
		[moh(1),mu(3),moh(2),moh(3),mu(4),moh(4)]) = ...
	[[1,1,1,1,1,1]/6;[-1,1,0,0,-1,1]/4;[0,0,-1,1,0,0]/2; ...
	 [-1,-1,0,0,1,1]/4;[1,-2,1,1,-2,1]/6;[1,0,-1,-1,0,1]/4];
  case  13, 
    cur_to_wave([10:12,14:16],[10:12,14:16]) = ...
	[[1,-1,0,0,1,-1]/4;[omal,0,-opal,-opal,0,omal]*ompsq/4; ...
	 [opal,0,omal,omal,0,opal]*ompsq/4;[0,0,-1,1,0,0]/2; ...
	 [0,1,0,0,1,0]/2;[-1,-1,0,0,1,1]/4];
    cur_to_wave([2,4,6,8,12],[2:2:16]) = ...
	[[1,0,0,-1,0,0,0,0]/2;[0,1,-1,0,0,0,0,0]/2; ...
	 [1,1,1,1,0,0,0,0]/4;[1,-1,-1,1,[-1,-1,-1,-1]*rad_weight]/4; ...
	 [[1,-1,-1,1]*rad_weight,1,1,1,1]/4];
  case  14, 
    cur_to_wave([9:11,14:16],[9:11,14:16]) = ...
	[[0,1,-1,-1,1,0]/4;[-1,1,0,0,-1,1]/4;[0,1,1,1,1,0]/4; ...
	 [0,0,-1,1,0,0]/2;[1,0,0,0,0,1]/2;[-1,-1,0,0,1,1]/4];
    cur_to_wave([1,4,5,8,11],[1,4,5,8,10,11,14,15]) = ...
	[[1,0,0,-1,0,0,0,0]/2;[0,1,-1,0,0,0,0,0]/2; ...
	 [1,1,1,1,0,0,0,0]/4;[1,-1,-1,1,[-1,-1,-1,-1]*rad_weight]/4; ...
	 [[1,-1,-1,1]*rad_weight,1,1,1,1]/4];
  case  15, 
    cur_to_wave([10:12,14:16],[10:12,14:16]) = ...
	[[-1,0,0,0,0,1]/2;[0,1,-1,1,-1,0]/4; ...
	 [opal,omal,omal,omal,omal,opal]*ompsq2/6; ...
	 [-omal,0,opal,opal,0,-omal]*ompsq/4; ...
	 [omal*opal,-omal^2-opal^2,omal^2, ...
		omal^2,-omal^2-opal^2,omal*opal]*ompsq3/6; ...
	 [0,-1,-1,1,1,0]/4];
  case  16, 
    cur_to_wave(10:15,10:15) = ...
	[[-1,0,0,0,0,1]/2;[0,1,-1,1,-1,0]/4; ...
	 [opal,omal,omal,omal,omal,opal]*ompsq2/6; ...
	 [-omal,0,opal,opal,0,-omal]*ompsq/4; ...
	 [omal*opal,-omal^2-opal^2,omal^2, ...
		omal^2,-omal^2-opal^2,omal*opal]*ompsq3/6; ...
	 [0,-1,-1,1,1,0]/4];
  case  19, 
    cur_to_wave(11:16,11:16) = ...
	[[1,-1,0,0,1,-1]/4;[opal,omal,omal,omal,omal,opal]*ompsq2/6; ...
	 [0,0,-1,1,0,0]/2;[-1,-1,0,0,1,1]/4; ...
	 [0,1,-1,-1,1,0]/4;[-2*omal,opal,opal,opal,opal,-2*omal]*ompsq2/6];
  case  22, 
    cur_to_wave([moh(1),mu(3),moh(2),moh(3),mu(4),moh(4)], ...
		[moh(1),mu(3),moh(2),moh(3),mu(4),moh(4)]) = ...
	[[1,1,1,1,1,1]/6;[-1,1,0,0,-1,1]/4;[0,0,-1,1,0,0]/2; ...
	 [-1,-1,0,0,1,1]/4;[1,-2,1,1,-2,1]/6;[1,0,-1,-1,0,1]/4];
  case  25, 
    cur_to_wave([10:12,14:16],[10:12,14:16]) = ...
	[[2,1,-1,1,-1,-2]/6;[1,-1,1,-1,1,-1]/6; ...
	 [opal,omal,omal,omal,omal,opal]*ompsq2/6; ...
	 [-1,0,1,1,0,-1]/4; ...
	 [omal,-omal-opal,omal,omal,-omal-opal,omal]*ompsq3/6; ...
	 [0,-1,-1,1,1,0]/4];
  case  26, 
    cur_to_wave(10:15,10:15) = ...
	[[2,1,-1,1,-1,-2]/6;[1,-1,1,-1,1,-1]/6; ...
	 [opal,omal,omal,omal,omal,opal]*ompsq2/6; ...
	 [-1,0,1,1,0,-1]/4; ...
	 [omal,-omal-opal,omal,omal,-omal-opal,omal]*ompsq3/6; ...
	 [0,-1,-1,1,1,0]/4];
  case  36, 
    cur_to_wave([11:14],[11:14])=0.25*[1,-1,1,-1;1,1,1,1;-1,1,1,-1;-1,-1,1,1];
end

if midplan == 8
	cur_to_wave = eye(16);
	cur_to_wave([9 12 13 16],[9 12 13 16]) = ...
		[1.54,-0.58,0.264,-0.64; ...
		1.226,0.908,-0.765,0.212; ...
		1.212,-0.765,0.908,0.226; ...
		1.064,0.264,0.508,-0.54];
end

for i=1:length(EF_Cur(:,1))
	EF_Wave(i,1:16) = transpose(cur_to_wave*EF_Cur(i,1:16)');
end

EF_Wave(:,18) = R_ref;
if midplan == 8
	EF_Wave(i,20)= Z_ref(i);
	EF_Wave(i,22)= Z_ref_b(i);
	EF_Wave(i,23)= R_ref_b(i);
end

if zip_sel(2)==2, EF_Wave(:,23) = Z_ref_b; end
% zip_sel(1) option introduced (SC, 21/04/05)
if zip_sel(1)==4, EF_Wave(:,3) = Amps(coil_n+7,:)';end







%---------------------------------------- 
%  
%%	MMATRIX subroutine
%---------------------------------------- 
Mmx_nr 	= 20; 	%Number of rows
Mmx_nz 	= 40;	%Number of columns
Mmx 	= zeros(Mmx_nr,Mmx_nz);

% Gains, below, give maximum load_mat elements of 0.495
%	ie_gain(2) = (0.495*650.7)/(M_cc(1,1)*(2020/50))	
%	if_gain(2) = (0.495*1250.1)/(M_cc(9,9)*(2020/50))	
%	ioh_gain(2)= (0.495*1398.6)/(M_cc(17,17)*(6868/50))	

Mmx_gain = diag([ie_gain(2)*ones(1,8) if_gain(2)*ones(1,8) ioh_gain(2)*ones(1,2)].*icoil_gain);

% Vloop feedback (SC, 23/09/03)
% ip_sel(1) = 5 Plasma current control by ECRH power (SC, 01/11/06)
% ip_sel(1) = 6 Plasma elongation control by ECRH power (SC, 02/11/06)
if ip_sel(1)==1|ip_sel(1)==2|ip_sel(1)==5|ip_sel(1)==6|ip_sel(1)==11|ip_sel(1)==12|ip_sel(1)==21 
	Mmx_gain(1,1) = 0;
end
% Two-component IOH feedback (SC, 06/04/05)
if ip_sel(1)==2
	Mmx_gain(2,2) = 0;
end
% zip_sel(1) option (SC, 25/04/05)
if zip_sel(1)==4
	Mmx_gain(3,3) = 0;
end

% Compute inductive voltages 
Mmx = M_aa*Mmx_gain;

% Compute resistive voltages
Mmx(:,coil_n+5:2*coil_n+4) = diag(R_a);

% ip_sel(1) = 5 Plasma current control by ECRH power (SC, 01/11/06)
if ip_sel(1) == 5
	Mmx(1,:) = 0;
	Mmx(1,1) = 1; % Different in ggg18.for -> to be checked (FP, 04/03/09)
end
% ip_sel(1) = 6 Plasma elongation control by ECRH power (SC, 02/11/06)
if ip_sel(1) == 6
	Mmx(1,:) = 0;
	Mmx(1,1) = 1; % Different in ggg18.for -> to be checked (FP, 04/03/09)
end
if zip_sel(3)==-5, zip_gain_d(3) = 0.85 * zip_gain_d(3); end % account for difference in observer, Nuno Cruz calculates 85% reduction need
if zip_sel(3)~=0, Mmx(20,22) = zip_gain_d(3); end %FPS
Mmx(19,21) = 6; %GAS

Mmx = repmat(Mmx,[1,1,msw]);









%---------------------------------------- 
%  
%%	AMATRIX subroutine
%---------------------------------------- 
% 	A phys_mat element of 1 gives a load_mat element of 0.5
Amx_nr 	= 24; 	%Number of rows
Amx_nz 	= 120;	%Number of columns
Amx 	= zeros(Amx_nr,Amx_nz);

if midplan ~= 8
	% PLasma current estimator
	%---------------------------------------- 
	Amx(19,38+1:2*38) = bp_l'; 
	
	% Vertical observer (Ip*z)
	%---------------------------------------- 
	%	Note that IpDz_xf is based on flux with minimum on magnetic axis,
	%	whereas the measured flux has maximum on axis.
	%	Also note that measured loop voltages are used here as vessel currents,
	%	and negative loop voltages give positive vessel currents.	
	%	
	%	for shot 3130 gains we have:
	%	psi inputs:	load = phys/600000
	%	ipol inpus:	load = phys/30
	%	bpol inputs:	load = -phys/173000
	
	if zip_sel(3) == 0
		Amx(20,1:2*38) 	= [-IpDz_xf IpDz_xm]; 	
	else
		Amx(20,1:2*38) 	= [-2*zip_w(2)*IpDz_xf 2*(1-zip_w(2))*IpDz_xm]; 	
	end
	
	if zip_sel(2) == 2
		if zip_sel(1) ~= 4 % zip_sel(1) option introduced (SC, 21/04/05)
			Amx(23,39:2*38) = IpDz_xm_m ;
		else
			Amx(23,1:2*38) = [-2*zip_w(2)*IpDz_xf 2*(1-zip_w(2))*IpDz_xm]; 
			Amx(3,39:2*38) = IpDz_xm_m;	
		end
	end
	
	if zip_sel(3) ~= 0
		Amx(20,38+[14 26]) = zip_w(1)*[1 -1];  
		if zip_sel(2)==2&(zip_sel(3)==-5|zip_sel(3)==-3)
			Amx(24,95:114) = IpDz_xm_m([2:6 8 11 17:19 21:23 29 32 34:38]); %JMMA24
		end		
	end
	
	if 	zip_sel(3) == -5, Amx(24,118) = zip_w(3);  
	elseif	zip_sel(3) == -3, 
		Amx(23,[52 64 117]) = zip_w(3)*[-1 1 1];  
		if zip_sel(1) == 4
			Amx(3,[52 64]) = zip_w(3)*[-1 1];  
		end
	end
	
	if zip_sel(1)==3|zip_sel(1)==4 %Coil correction allowed for zip_sel(1)=3,4 (SC, 31/03/05) 
		Amx(20,76+1:76+18) = -IpDz_xc(1:18);
	end
	
	% Radial observer 
	%---------------------------------------- 
	Amx(18,[midplad midout 38+midplad 38+midout]) = ...
		[-1 1 -rad_gap(1)*bp_r(midplad)*2*pi rad_gap(2)*bp_r(midout)*2*pi]*rad_obs(6);
	
	% E and F coils
	%---------------------------------------- 
	coil_sel = eye(16);
	
	% zip_sel(1)=11,21 (Vloop feedback) option addes (SC, 23/9/03)
	if ip_sel(1)==1|ip_sel(1)==2|ip_sel(1)==11|ip_sel(1)==12|ip_sel(1)==21
		coil_sel(1,1) = 0;
	end
	% zip_sel(1)=2 (two-componet IOH feedback) option added (SC, 06/04/05)
	if ip_sel(1)==2|ip_sel(1)==12, coil_sel(1,17) = 1; end 
	% zip_sel(1)=5 (plasma current/elongation control by ECRH power) option added (SC, 01/11/06) 
	if ip_sel(1)==5|zip_sel(1)==6, coil_sel(1,[1 17]) = [0 1]; end
	%
	if ip_sel(1)==11, coil_sel(1,43) = 1; end
	%
	if ip_sel(1)==21, coil_sel(1,1) = 1; end
	% zip_sel(1)=4 option added (SC, 25/04/05)
	if zip_sel(1)==4, coil_sel(3,3) = 0; end 
	%
	switch shape_sel(1)
	 case 1,
		coil_sel(mu(3:4),mu(3:4)) = [1 -1;1 1]*0.5;
	 case 2,
		coil_sel([mu(3) moh(1)],[mu(3) moh(1)]) = [1 1; -1 1]*0.5;
		coil_sel([mu(4) moh(4)],[mu(4) moh(4)]) = [1 1; -1 1]*0.5;
	 case 3,
		if Z_pla(1) > 0
			coil_sel(10,[10 11 15 16]) = 	[	0.25	-0.25	0.25	-0.25	];	
			coil_sel(11,[10 11 12 14 16]) = [	0.25*omal	0	-0.25*opal	-0.25*opal	0.25*omal]*ompsq;	
			coil_sel(12,[10 12 14 16]) = 	[	0.25*opal	0.25*omal	0.25*omal	0.25*opal]*ompsq;	
			coil_sel(14,[12 14]) = 		[	-0.5	0.5];	
			coil_sel(15,[11 15]) = 		[	0.5	0.5];	
			coil_sel(16,[10 11 15 16]) = 	[	-0.25	-0.25	0.25	0.25	];	
		else
			coil_sel(9,[9 10 14 15]) = 	[	0.25	-0.25	0.25	-0.25	];	
			coil_sel(10,[9 10 11 13 15]) = 	[	0.25*omal	0	-0.25*opal	-0.25*opal	0.25*omal]*ompsq;	
			coil_sel(11,[9 11 13 15]) = 	[	0.25*opal	0.25*omal	0.25*omal	0.25*opal]*ompsq;	
			coil_sel(13,[11 13]) = 		[	-0.5	0.5];	
			coil_sel(14,[10 14]) = 		[	0.5	0.5];	
			coil_sel(15,[9 10 14 15]) = 	[	-0.25	-0.25	0.25	0.25	];	
		end	
	 case 4,
		coil_sel(9,[9 10 11 14 15]) =	[	0	0.25	-0.25	-0.25	0.25	];
		coil_sel(10,[9 10 15 16]) =	[	-0.25	0.25	-0.25	0.25	];
		coil_sel(11,[10 11 14 15]) =	[	0.25	0.25	0.25	0.25	];
		coil_sel(14,[11 14]) =		[	-0.5	0.5	];
		coil_sel(15,[9 15 16]) =	[	0.5	0	0.5	];
		coil_sel(16,[9 10 15 16]) =	[	-0.25	-0.25	0.25	0.25	];
	 case 5,
		coil_sel(10,[10 11 12 14 15]) =	[	0	-0.25	0.25	-0.25	0.25	];	
		coil_sel(11,[10 11 12 14 16]) = [	-0.25*omal	0	0.25*opal	0.25*opal	-0.25*omal]*ompsq;	
		coil_sel(12,[10 12 14 16]) = 	[	0.25*opal	0.25*omal	0.25*omal	0.25*opal]*ompsq;	
		coil_sel(14,[10 14 16]) = 	[	-0.5	0	0.5];	
		coil_sel(15,[11 15]) = 		[	0.5	0.5];	
		coil_sel(16,[11 12 14 15 16]) =	[	-0.25	-0.25	0.25	0.25	0	];	
	 case 6,
		coil_sel(9,[9 11 14 16]) =	[	-0.25*omal	0.25*opal	0.25*opal	-0.25*omal]*ompsq;	
		coil_sel(11,[11 12 13 14]) = 	[	0.25		-0.25		0.25		-0.25	];	
		coil_sel(12,[9 11 12 14 16]) = 	[	0.25*opal	0.25*omal	0	0.25*omal	0.25*opal]*ompsq;	
		coil_sel(13,[9 13 16]) = 	[	-0.5	0	0.5];	
		coil_sel(14,[12 13 14]) = 	[	0.5	0.5	0	];	
		coil_sel(16,[11 12 13 14 16]) =	[	-0.25	-0.25	0.25	0.25	0	];	
	 case 7,
		coil_sel(11:12,11:12) = [1 -1; 1 1]*0.5;
		coil_sel(14:15,14:15) = [1 1; -1 1]*0.5;
	 case 8, %New coil combination for small plasmas (SC, 03/09/04)
		coil_sel(12:15,12:15) = 			...
		[	1 	-1 	1 	-1;		...
		 	-1 	-1 	1 	1; 		...
			[opal 	omal 	omal 	opal]*ompsq; 	...
			[omal 	-opal 	-opal 	omal]*ompsq]*0.25;
	 case 9, %New coil combination for small plasmas (SC, 03/09/04)
		coil_sel(11,[11 12 13 14 15]) =	[	0	0.25*omal	-0.25*opal	-0.25*opal	0.25*omal]*ompsq;
		coil_sel(12,[11 12 15 16]) =	[	-0.25	0.25	-0.25	0.25	];
		coil_sel(13,[12 13 14 15]) =	[	0.25*opal	0.25*omal	0.25*omal	0.25*opal]*ompsq;
		coil_sel(14,[13 14]) =		[	-0.5	0.5	];
		coil_sel(15,[11 15 16]) =	[	0.5	0	0.5	];
		coil_sel(16,[9 10 15 16]) =	[	-0.25	-0.25	0.25	0.25	];
	 case 10, %New coil combination for small plasmas at the top (SC, 18/01/05)
		coil_sel(13:16,13:16) = 			...	
		[	1 	-1 	1 	-1;		...
			-1 	-1 	1 	1;		...
		 	[opal 	omal 	omal 	opal]*ompsq; 	...
			[omal 	-opal 	-opal 	omal]*ompsq]*0.25;
	 case 12,
		coil_sel([mu(3:4) moh(1:4)],[mu(3:4) moh(1:4)]) =  ...
		[	1/4	-1/4	-1/4	0	0	1/4;	...
			-1/3	-1/3	1/6	1/6	1/6	1/6;	...
			1/6	1/6	1/6	1/6	1/6	1/6;	...
			0	0	0	-1/2	1/2	0;	...
			-1/4	1/4	-1/4	0	0	1/4;	...
			0	0	1/4	-1/4	-1/4	1/4 ];	
	 case 13,
		coil_sel(2,[2 8]) = 		[	0.5	-0.5	];	
		coil_sel(4,[4 6]) = 		[	0.5	-0.5	];	
		coil_sel(6,[2 4 6 8]) = 	[	0.25	0.25	0.25	0.25	];	
		coil_sel(8,2:2:16) =	 	[	0.25	-0.25	-0.25	0.25	 -ones(1,4)*0.25*rad_weight];	
		coil_sel(10,[10 11 15 16]) = 	[	0.25	-0.25	0.25	-0.25	];	
		coil_sel(11,[10 11 12 14 16]) = [	0.25*omal	0	-0.25*opal	-0.25*opal	0.25*omal]*ompsq;	
		coil_sel(12,2:2:16) = 		[	0.25*rad_weight	-0.25*rad_weight	-0.25*rad_weight	0.25*rad_weight ...
							0.25*opal	0.25*omal		0.25*omal		0.25*opal]*ompsq;	
		coil_sel(14,[12 14]) = 		[	-0.5	0.5];	
		coil_sel(15,[11 15]) = 		[	0.5	0.5];	
		coil_sel(16,[10 11 15 16]) = 	[	-0.25	-0.25	0.25	0.25	];	
	 case 14,
		coil_sel(1,[1 8]) =		[	0.5	-0.5	];
		coil_sel(4,[4 5]) =		[	0.5	-0.5	];
		coil_sel(5,[1 4 5 8]) =		[	0.25	0.25	0.25	0.25	];
		coil_sel(8,[1 4 5 8 10 11 14 15]) =[	0.25	-0.25	-0.25	0.25	-ones(1,4)*rad_weight/4	];
		coil_sel(9,[9 10 11 14 15]) =	[	0	0.25	-0.25	-0.25	0.25	];
		coil_sel(10,[9 10 15 16]) =	[	-0.25	0.25	-0.25	0.25	];
		coil_sel(11,[1 4 5 8 10 11 14 15]) =[	[1 -1 -1 1]*rad_weight/4	0.25	0.25	0.25	0.25	];
		coil_sel(14,[11 14]) =		[	-0.5	0.5	];
		coil_sel(15,[9 15 16]) =	[	0.5	0	0.5	];
		coil_sel(16,[9 10 15 16]) =	[	-0.25	-0.25	0.25	0.25	];
	 case 15,
		coil_sel([10:12 14:16],[10:12 14:16]) =  ...
		[	-1/2		0		0		0		0		1/2;			...
			0		1/4		-1/4		1/4		-1/4		0;			...
			[1/6*opal	1/6*omal	1/6*omal	1/6*omal	1/6*omal	1/6*opal]*ompsq2;	...
			[-1/4*omal	0		1/4*opal 	1/4*opal	0		-1/4*omal]*ompsq2;	...
			[opal^2		-omal^2-opal^2	omal^2		omal^2		-omal^2-opal^2	omal^2]*ompsq3/6;	...
			0		-1/4		-1/4		1/4		1/4		0 ];
	 case 16,
		coil_sel([10:12 13:15],[10:12 13:15]) =  ...
		[	-1/2		0		0		0		0		1/2;			...
			0		1/4		-1/4		1/4		-1/4		0;			...
			[1/6*opal	1/6*omal	1/6*omal	1/6*omal	1/6*omal	1/6*opal]*ompsq2;	...
			[-1/4*omal	0		1/4*opal 	1/4*opal	0		-1/4*omal]*ompsq2;	...
			[opal^2		-omal^2-opal^2	omal^2		omal^2		-omal^2-opal^2	omal*opal]*ompsq3/6;	...
			0		-1/4		-1/4		1/4		1/4		0 ];
	 case 19,
		coil_sel(11:16,11:16) =  ...
		[	1/4		-1/4		0		0		1/4		-1/4;			...
			[1/6*opal	1/6*omal	1/6*omal	1/6*omal	1/6*omal	1/6*opal]*ompsq2;	...
			0		0		-1/2		1/2		0		0;			...
			-1/4		-1/4		0 		0		1/4		1/4;			...
			0		1/4		-1/4		-1/4		1/4		0;			...
			[-1/3*omal 	1/6*opal	1/6*opal	1/6*opal	1/6*opal	-1/3*omal]*ompsq2 ];
	 case 22,
		coil_sel([mu(3:4) moh(1:4)],[mu(3:4) moh(1:4)]) =  ...
		[	1/4	-1/4	-1/4	0	0	1/4;	...
			-1/3	-1/3	1/6	1/6	1/6	1/6;	...
			1/6	1/6	1/6	1/6	1/6	1/6;	...
			0	0	0	-1/2	1/2	0;	...
			-1/4	1/4	-1/4	0	0	1/4;	...
			0	0	1/4	-1/4	-1/4	1/4 ];	
	 case 25,
		coil_sel([10:12 14:16],[10:12 14:16]) =  ...
		[	1/3		1/6		-1/6		1/6		-1/6		-1/3;			...
			1/6		-1/6		1/6		-1/6		1/6		-1/6;			...
			[1/6*opal	1/6*omal	1/6*omal	1/6*omal	1/6*omal	1/6*opal]*ompsq2;	...
			-1/4		0		1/4	 	1/4		0		-1/4;			...
			[omal		-omal-opal	omal		omal		-omal-opal	omal]*ompsq3/6;		...
			0		-1/4		-1/4		1/4		1/4		0 ];
	 case 26,
		coil_sel([10:12 13:15],[10:12 13:15]) =  ...
		[	1/3		1/6		-1/6		1/6		-1/6		-1/3;			...
			1/6		-1/6		1/6		-1/6		1/6		-1/6;			...
			[1/6*opal	1/6*omal	1/6*omal	1/6*omal	1/6*omal	1/6*opal]*ompsq2;	...
			-1/4		0		1/4	 	1/4		0		-1/4;			...
			[omal		-omal-opal	omal		omal		-omal-opal	omal]*ompsq3/6;		...
			0		-1/4		-1/4		1/4		1/4		0 ];
	 case 36, %New coil combination for small plasmas (SC, 06/09/04)
		coil_sel(11:14,11:14) = [1 -1 1 -1; 1 1 1 1; -1 1 1 -1; -1 -1 1 1]*0.5;
	end
	
	Amx(1:16,76+1:76+16) = coil_sel;
	
	
	% OH1 and OH2 coils
	%---------------------------------------- 
	Amx(17,115) = 2;
	
	% Gas
	%---------------------------------------- 
	Amx(21,116) = 1;
	
	% Fast coil
	%---------------------------------------- 
	% if zip_sel(3)~=0&shape_sel(1)~=12, Amx(22,117) = 1; end
	
	% Kappa
	%---------------------------------------- 
	Amx(22,1:2*38) = [-IpDz2_xf IpDz2_xm];
	
	% Add possibility of subtracting coil current corrections (SC, 13/05/04)
	if (kappa_sel>=10&kappa_sel<20)|(kappa_sel>=30&kappa_sel<40)
		Amx(22,76+1:76+18) = -IpDz2_xc; 
	else
		Amx(22,76+1:76+18) = zeros(1,18); 
	end
	
	%Conversion from relative to absolute flux input
	if ip_sel(1) ~= 21
		Amx(1:24,1) = -sum(Amx(1:24,2:fl_n),2);
	else
		Amx(2:24,1) = -sum(Amx(2:24,2:fl_n),2);
	end	
		
	Amx = repmat(Amx,[1,1,msw]);
else	
	% PLasma current estimator
	%---------------------------------------- 
	Amx(19,38+1:2*38) = bp_l'; 
		% develop an observer for the rwo plasma currents
	
	% Vertical observer (Ip*z)
	%---------------------------------------- 
	%	Note that IpDz_xf is based on flux with minimum on magnetic axis,
	%	whereas the measured flux has maximum on axis.
	%	Also note that measured loop voltages are used here as vessel currents,
	%	and negative loop voltages give positive vessel currents.	
	%	
	%	for shot 3130 gains we have:
	%	psi inputs:	load = phys/600000
	%	ipol inpus:	load = phys/30
	%	bpol inputs:	load = -phys/173000
	Amx(20,1:38)	= -zip_w(2)*IpDz_xf_t(1:38);
	Amx(20,39:2*38)	= (1-zip_w(2))*IpDz_xm_t(1:38);
	Amx(22,1:38)	= -zip_w(2)*IpDz_xf_b(1:38);
	Amx(22,39:2*38)	= (1-zip_w(2))*IpDz_xm_b(1:38);
	Amx(24,1:38)	= -zip_w(2)*IpDz_xf(1:38);
	Amx(24,39:2*38)	= (1-zip_w(2))*IpDz_xm(1:38);
	
	% E and F coils
	%---------------------------------------- 
	coil_sel = eye(16);
	coil_sel([9 12 13 16],[9 12 13 16]) = ...
		[0.54,-0.58,0.264,-0.064; ...
		0.226,0.908,-0.765,0.212; ...
		0.212,-0.765,0.908,0.226; ...
		0.064,-0.264,0.58,-0.54];	
	Amx(1:16,76+1:76+16) = coil_sel;
	
	% Radial observer 
	%---------------------------------------- 
	Amx(18,[midplat midoutt 38+midplat 38+midoutt]) = ...
		[-1 1 -rad_gap(1)*bp_r(midplat)*2*pi rad_gap(2)*bp_r(midoutt)*2*pi]*rad_obs(6);
	Amx(23,[midplab midoutb 38+midplab 38+midoutb]) = ...
		[-1 1 -rad_gap(1)*bp_r(midplab)*2*pi rad_gap(2)*bp_r(midoutb)*2*pi]*rad_obs(6);

	% OH1 and OH2 coils
	%---------------------------------------- 
	Amx(17,115) = 2;
	
	% Gas
	%---------------------------------------- 
	Amx(21,116) = 1;
	
	% Fast coil
	%---------------------------------------- 
	% if zip_sel(3)~=0&shape_sel(1)~=12, Amx(22,117) = 1; end

	%Conversion from relative to absolute flux input
	if ip_sel(1) ~= 21
		Amx(1:24,1) = -sum(Amx(1:24,2:fl_n),2);
	else
		Amx(2:24,1) = -sum(Amx(2:24,2:fl_n),2);
	end	
		
	Amx = repmat(Amx,[1,1,msw]);
	
	Amx(18,1:Amx_nz,4) = Amx(24,1:Amx_nz,4);
	Amx(24,:,:) = 0;
end







%---------------------------------------- 
%  
%%	GMATRIX subroutine
%---------------------------------------- 
% 	A phys_mat element of 1 gives a load_mat element of 0.5

Gmx_nr 	= 22; 	%Number of rows
Gmx_nz 	= 24;	%Number of columns

rad_weight1 	= 1/(1+rad_weight^2);
strang		= 0.006/(2*5.25*pi);
	
if midplan ~= 8
	Gmx_1_f = zeros(Gmx_nr,Gmx_nz);	%Integral gains	
	Gmx_2_f = zeros(Gmx_nr,Gmx_nz);	%Proportional gains
	Gmx_3_f = zeros(Gmx_nr,Gmx_nz);	%Differential gains
	Gmx_1_nf= zeros(Gmx_nr,Gmx_nz);	%Integral gains	(no feedback)
	Gmx_2_nf= zeros(Gmx_nr,Gmx_nz);	%Proportional gains (no feedback)
	Gmx_3_nf= zeros(Gmx_nr,Gmx_nz);	%Differential gains (no feedback)
	
	% Gas
	%---------------------------------------- 
	Gmx_1_f(21,21) = 0.1/6*dens_gain_i; 
	Gmx_2_f(21,21) = 0.1/6*dens_gain_p; 
	Gmx_3_f(21,21) = 0.1/6*dens_gain_d; 
	
	% OH coil 
	%---------------------------------------- 
	Gmx_1_f(17:18,17) = [1 -1]*0.25*dioh_gain_i;
	Gmx_2_f(17:18,17) = [1 -1]*0.25*dioh_gain_p;
	
	% Plasma Current 
	%---------------------------------------- 
	Gmx_1_f(17:18,19) = -ip_gain(2); 
	Gmx_2_f(17:18,19) = -ip_gain(1); 
	
	% EF Coils 
	%---------------------------------------- 
	Gmx_2_f(1:16,1:16) = diag([0.25*ones(1,8) ones(1,8)]); 
	
	% ip_sel(1)=11 and 21 (Vloop feedback) option added (SC, 23/09/03)
	% ip_sel(1)=5 and 6 (plasma current/elongation control by ECRH power) option added (SC, 01/11/06)
	if ip_sel(1)==1|ip_sel(1)==2|ip_sel(1)==5|ip_sel(1)==6|ip_sel(1)==11|ip_sel(1)==12|ip_sel(1)==21 
		Gmx_2_f(1,1) = 0;
	end
	% ip_sel(1)=2 (two-component IOH feedback) option added (SC, 06/04/05)
	if ip_sel(1)==2|ip_sel(1)==12
		Gmx_2_f(2,2) = 0;
	end
	% zip_sel(1)=4 option added (SC, 25/04/05)
	if zip_sel(1)==4
		Gmx_2_f(3,3) = 0;
	end
	
	% Plasma radial and vertical position
	%---------------------------------------- 
	switch shape_sel(1)
	  case 1
		Gmx_2_f(mu(3),mu(3)) 	= 0;
		Gmx_2_f(mu(4),mu(4)) 	= 0;
		Gmx_2_f(mu(3:4),18) 	= rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f(mu(3:4),20) 		= [-1 1]*zip_gain_p(2)*0.1;	
			Gmx_3_f(mu(3:4),20) 		= [-1 1]*zip_gain_d(2)*0.1*strang;	
			Gmx_3_f([mu(1)-1 mu(2)+2],20) 	= [-1 1]*zip_gain_d(1)*0.1*strang;	
		elseif zip_sel(3)==-1
			Gmx_2_f(mu(3:4),20) 		= [-1 1]*zip_gain_p(2)*0.1;	
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(mu(3:4),mu(3:4)) = [1 1; -1 1];
	  case 2
		Gmx_2_f(mu(3),mu(3)) 			= 0;
		Gmx_2_f(mu(4),mu(4)) 			= 0;
		Gmx_2_f([mu(3:4) moh(1) moh(4)],18) 	= rad_gain;
		Gmx_2_f(mu(3),moh(1))			= -1;
		Gmx_2_f(mu(4),moh(4))			= -1;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([mu(3:4) moh(1) moh(4)],23) = [-1 1 -1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_d(2)*0.05*strang;
			end			
		elseif zip_sel(3)==-1
			Gmx_2_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_p(2)*0.05;
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf([moh(1) mu(3)],mu(3)) = [1 1];
		Gmx_2_nf([moh(4) mu(4)],mu(4)) = [1 1];
	  case 3 %New coil combination for the case zax<0 (SC, 17/02/05)
		if Z_pla(1)>0
			Gmx_2_f([10:11 15:16],10)	= [1 -1 1 -1];
			Gmx_2_f([10 11 12 14 16],11)	= [omal 0 -opal -opal omal];
			Gmx_2_f(12,12)			= 0;
			Gmx_2_f([12 14],14)		= [-1 1];
			Gmx_2_f([11 15],15)		= [1 1];
			Gmx_2_f(16,16)			= 0;
			Gmx_2_f([10 12 14 16],18)	= [opal omal omal opal]*rad_gain;
			if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
				Gmx_2_f([10:11 15:16],20)	= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_p(2);
				if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
					Gmx_3_f([10:11 15:16],23)	= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_d(2)*strang;
				else	
					Gmx_3_f([10:11 15:16],20)	= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_d(2)*strang;
				end	
			Gmx_3_f([3 7],20)	= [-1 1]*zip_gain_d(1)*0.1*strang;
			elseif zip_sel(3)==-1
				Gmx_2_f([10:11 15:16],20) = [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_p(2);
			end
			%No feedback
			Gmx_1_nf = Gmx_1_f;
			Gmx_2_nf = Gmx_2_f;
			Gmx_3_nf = Gmx_3_f;
			Gmx_1_nf(:,[18 20 21:24]) = 0;
			Gmx_2_nf(:,[18 20 22:24]) = 0;
			Gmx_3_nf(:,[18 20 21:24]) = 0;
			if zip_sel(1)==4
				Gmx_1_nf(:,3) = 0;
				Gmx_2_nf(:,3) = 0;
				Gmx_3_nf(:,3) = 0;
			end
			Gmx_2_nf([10 12 14 16],12) = [opal omal omal opal];
			Gmx_2_nf([10 11 15 16],16) = [-1 -1 1 1];
		else
			Gmx_2_f([9:10 14:15],9)	= [1 -1 1 -1];
			Gmx_2_f([9:11 13 15],10)= [omal 0 -opal -opal omal];
			Gmx_2_f(11,11)		= 0;
			Gmx_2_f([11 13],13)	= [-1 1];
			Gmx_2_f([10 14],14)	= [1 1];
			Gmx_2_f(15,15)		= 0;
			Gmx_2_f([9 11 13 15],18)= [opal omal omal opal]*rad_gain;
			if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
				Gmx_2_f([9:10 14:15],20)	= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_p(2);
				if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
					Gmx_3_f([9:10 14:15],23)= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_d(2)*strang;
				else	
					Gmx_3_f([9:10 14:15],20)= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_d(2)*strang;
				end	
			Gmx_3_f([3 7],20)= [-1 1]*zip_gain_d(1)*0.1*strang;
			elseif zip_sel(3)==-1
				Gmx_2_f([9:10 14:15],20) = [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_p(2);
			end
			%No feedback
			Gmx_1_nf = Gmx_1_f;
			Gmx_2_nf = Gmx_2_f;
			Gmx_3_nf = Gmx_3_f;
			Gmx_1_nf(:,[18 20 21:24]) = 0;
			Gmx_2_nf(:,[18 20 22:24]) = 0;
			Gmx_3_nf(:,[18 20 21:24]) = 0;
			if zip_sel(1)==4
				Gmx_1_nf(:,3) = 0;
				Gmx_2_nf(:,3) = 0;
				Gmx_3_nf(:,3) = 0;
			end
			Gmx_2_nf([9 11 13 15],11) = [opal omal omal opal];
			Gmx_2_nf([9 10 14 15],15) = [-1 -1 1 1];
		end	
	  case 4
		Gmx_2_f([9:11 14:15],9) = [0 1 -1 -1 1];
		Gmx_2_f([9:10 15:16],10)= [-1 1 -1 -1];
		Gmx_2_f(11,11)	 	= 0;
		Gmx_2_f([11 14],14) 	= [-1 1];
		Gmx_2_f([9 15:16],15) 	= [1 0 1];
		Gmx_2_f(16,16)	 	= 0;
		Gmx_2_f([10:11 14:15],18)= rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([9:10 15:16],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([9:10 15:16],23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([9:10 15:16],20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		Gmx_3_f([3 6],20)= [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f([9:10 15:16],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf([10 11 14 15],11) = ones(1,4);
		Gmx_2_nf([9 10 15 16],16) = [-1 -1 1 1];
	  case 5
		Gmx_2_f([10:12 14:15],10) = [0 -1 1 -1 1];
		Gmx_2_f(11,11) 		= 0;
		Gmx_2_f([10 14 16],14) 	= [-1 0 1];
		Gmx_2_f([11 15],15) 	= [1 1];
		Gmx_2_f(16,16) 		= 0;
		Gmx_2_f([10 12 14 16],18)= [opal omal omal opal]*rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([11:12 14:15],23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		Gmx_3_f([3 7],20)	= [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(10:2:16,12) = [opal omal omal opal];
		Gmx_2_nf([11:12 14:16],16) = [-1 -1 1 1 0];
	  case 6
		Gmx_2_f([9 11 14 16],9) = [-omal opal opal -omal];
		Gmx_2_f(11:14,9) 	= [1 -1 1 -1];
		Gmx_2_f(12,12) 		= 0;
		Gmx_2_f([9 13 16],13) 	= [-1 0 1];
		Gmx_2_f(12:14,14) 	= [1 1 0];
		Gmx_2_f([9 11 14 16],18)= [opal omal omal opal]*rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f(11:14,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f(11:14,23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f(11:14,20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		Gmx_3_f([3 7],20)	= [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f(11:14,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf([9 11 12 14 16],12) = [opal omal 0 omal opal];
		Gmx_2_nf([11:14 16],16) = [-1 -1 1 1 0];
	  case 7
		Gmx_2_f(12,12) 		= 0;
		Gmx_2_f(14,14) 		= 0;
		Gmx_2_f([11:12 14:15],18)= rad_gain;
		Gmx_2_f(12,11) 		= -1;
		Gmx_2_f(14,15) 		= -1;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([11:12 14:15],23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		end	
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf([11 12],12) = [1 1];
		Gmx_2_nf([14 15],14) = [1 1];
	  case 8 %New coil combination for small plasmas (SC, 03/09/04)
		Gmx_2_f(13,13) 		= 0;
		Gmx_2_f(14,14) 		= 0;
		Gmx_2_f(12:15,12) 	= [1 -1 1 -1];
		Gmx_2_f(12:15,15) 	= [omal -opal -opal omal];
		Gmx_2_f(12:15,18) 	= [opal omal omal opal]*rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f(12:15,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f(12:15,23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f(12:15,20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		end	
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(12:15,13) = [-1 -1 1 1];
		Gmx_2_nf(12:15,14) = [opal omal omal opal];
	  case 9 %New coil combination for small plasmas (SC, 03/09/04)
		Gmx_2_f(11:15,11) 	= [0 omal -opal -opal omal];
		Gmx_2_f([11:12 15:16],12) = [-1 1 -1 1];
		Gmx_2_f(13,13) 		= 0;
		Gmx_2_f(13:14,14) 	= [-1 1];
		Gmx_2_f([11 15:16],15) 	= [1 0 1];
		Gmx_2_f(16,16) 		= 0;
		Gmx_2_f(12:15,18) 	= [opal omal omal opal]*rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([11:12 15:16],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([11:12 15:16],23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([11:12 15:16],20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		Gmx_3_f([3 6],20)	= [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f([11:12 15:16],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(12:15,13) = [opal omal omal opal];
		Gmx_2_nf([11 12 15 16],16) = [-1 -1 1 1];
	  case 10 %New coil combination for small plasmas at the top (SC, 18/01/05)
		Gmx_2_f(14,14) 		= 0;
		Gmx_2_f(15,15) 		= 0;
		Gmx_2_f(13:16,13) 	= [1 -1 1 -1];
		Gmx_2_f(13:16,16) 	= [omal -opal -opal omal];
		Gmx_2_f(13:16,18) 	= [opal omal omal opal]*rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f(13:16,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f(13:16,23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f(13:16,20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		end	
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(13:16,14) = [-1 -1 1 1];
		Gmx_2_nf(13:16,15) = [opal omal omal opal];
	  case 12
		Gmx_2_f([moh(1:4) mu(3:4)],18)	= rad_gain;
		Gmx_2_f([moh(1:4) mu(3:4)],moh(1))= 0;
		Gmx_2_f([moh(1:4) mu(3:4)],moh(2))= [0 -1 1 0 0 0];
		Gmx_2_f([moh(1:4) mu(3:4)],moh(3))= 0;
		Gmx_2_f([moh(1:4) mu(3:4)],moh(4))= [1 -1 -1 1 0 0];
		Gmx_2_f([moh(1:4) mu(3:4)],mu(3)) = [-1 0 0 1 1 -1];
		Gmx_2_f([moh(1:4) mu(3:4)],mu(4)) = [0.5 0.5 0.5 0.5 -1 -1];
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([mu(3:4) moh(1) moh(4)],23) = [-1 1 -1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_d(2)*0.05*strang;
			end			
		elseif zip_sel(3)==-1
			Gmx_2_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_p(2)*0.05;
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf([moh(1:4) mu(3:4)],moh(1)) = ones(1,6);
		Gmx_2_nf([moh(1:4) mu(3:4)],moh(3)) = [-1 0 0 1 -1 1];
	  case 13 %New coil combination for the case zax<0 (SC, 17/02/05)
		Gmx_2_f([2 8],2)			= [0.25 -0.25];
		Gmx_2_f([4 6],4)			= [0.25 -0.25];
		Gmx_2_f([2 4 6 8],6)			= [0.25 0.25 0.25 0.25];
		Gmx_2_f([2 4 6 8 10 11 13 16],8)	= [1 -1 -1 1 -rad_weight -rad_weight -rad_weight -rad_weight]*0.25*rad_weight1;
		Gmx_2_f([10:11 15:16],10)		= [1 -1 1 -1];
		Gmx_2_f([10 11 12 14 16],11)		= [omal 0 -opal -opal omal];
		Gmx_2_f(12,12)				= 0;
		Gmx_2_f([12 14],14)			= [-1 1];
		Gmx_2_f([11 15],15)			= [1 1];
		Gmx_2_f(16,16)				= 0;
		Gmx_2_f([2 4 6 8 10 12 14 16],18)	= [rad_weight -rad_weight -rad_weight rad_weight opal omal omal opal]*rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([10:11 15:16],20)	= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_p(2);
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([10:11 15:16],23)	= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_d(2)*strang;
			else	
				Gmx_3_f([10:11 15:16],20)	= [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_d(2)*strang;
			end	
		Gmx_3([3 7],20)	= [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f([10:11 15:16],20) = [-0.0448 -0.0448 0.0556 0.0556]*zip_gain_p(2);
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(2:2:16,12) = [rad_weight -rad_weight -rad_weight rad_weight 1 1 1 1]*rad_weight1;
		Gmx_2_nf([9 10 15 16],16) = [-1 -1 1 1];
	  case 14
		Gmx_2_f([1 8],1) 			= [0.25 -0.25];
		Gmx_2_f([4 5],4) 			= [0.25 -0.25];
		Gmx_2_f([1 4 5 8],5) 			= [0.25 0.25 0.25 0.25];
		Gmx_2_f([1 4 5 8 10:11 14:15],8) 	= [1 -1 -1 1 -rad_weight -rad_weight -rad_weight -rad_weight]*0.25*rad_weight1;
		Gmx_2_f([9:11 14:15],9) 		= [0 1 -1 -1 1];
		Gmx_2_f([9:10 15:16],10) 		= [-1 1 -1 -1];
		Gmx_2_f(11,11)	 			= 0;
		Gmx_2_f([11 14],14) 			= [-1 1];
		Gmx_2_f([9 15:16],15) 			= [1 0 1];
		Gmx_2_f(16,16)	 			= 0;
		Gmx_2_f([1 4 5 8 10:11 14:15],18)	= [rad_weight -rad_weight -rad_weight rad_weight 1 1 1 1]*rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([9:10 15:16],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([9:10 15:16],23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([9:10 15:16],20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		Gmx_3_f([3 6],20)	= [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f([9:10 15:16],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf([1 4 5 8 10 11 14 15],11) = [rad_weight -rad_weight -rad_weight rad_weight 1 1 1 1]*rad_weight1;
		Gmx_2_nf([9 10 15 16],16) = [-1 -1 1 1];
	  case 15 %New coil combination (SC, 03/09/04)
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([11:12 14:15],23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
			Gmx_3_f([mu(1)-1 mu(2)+1],20) = [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end	
		Gmx_2_f([10:12 14:16],18)	= [opal omal omal omal omal opal]*rad_gain;
		Gmx_2_f([10:12 14:16],10)	= [-1 0 0 0 0 1];
		Gmx_2_f([10:12 14:16],11)	= [0 1 -1 1 -1 0];
		Gmx_2_f([10:12 14:16],12)	= 0;
		Gmx_2_f([10:12 14:16],14)	= [-omal 0 opal opal 0 -omal];
		Gmx_2_f([10:12 14:16],15)	= [omal*opal -(omal^2+opal^2) omal^2 omal^2 -(omal^2+opal^2) omal*opal]*0.5;
		Gmx_2_f([10:12 14:16],16)	= 0;
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf([10:12 14:16],12) = [opal omal omal omal omal opal];
		Gmx_2_nf([10:12 14:16],16) = [0 -1 -1 1 1 0];
	  case 16 %New coil combination (SC, 03/09/04)
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f(11:14,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f(11:14,23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f(11:14,20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
			Gmx_3_f([mu(1)-1 mu(2)+1],20) = [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f(11:14,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end	
		Gmx_2_f(10:15,18)	= [opal omal omal omal omal opal]*rad_gain;
		Gmx_2_f(10:15,10)	= [-1 0 0 0 0 1];
		Gmx_2_f(10:15,11)	= [0 1 -1 1 -1 0];
		Gmx_2_f(10:15,12)	= 0;
		Gmx_2_f(10:15,13)	= [-omal 0 opal opal 0 -omal];
		Gmx_2_f(10:15,14)	= [omal*opal -(omal^2+opal^2) omal^2 omal^2 -(omal^2+opal^2) omal*opal]*0.5;
		Gmx_2_f(10:15,15)	= 0;
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(10:15,12) = [opal omal omal omal omal opal];
		Gmx_2_nf(10:15,15) = [0 -1 -1 1 1 0];
	  case 19 %New coil combination for small plasmas (SC, 03/09/04)
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([11:12 15:16],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([11:12 15:16],23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([11:12 15:16],20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
			Gmx_3_f([mu(1)-1 mu(2)+1],20) = [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f([11:12 15:16],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end	
		Gmx_2_f(11:16,18)	= [opal omal omal omal omal opal]*rad_gain;
		Gmx_2_f(11:16,11)	= [1 -1 0 0 1 -1];
		Gmx_2_f(11:16,12)	= 0;
		Gmx_2_f(11:16,13)	= [0 0 -1 1 0 0];
		Gmx_2_f(11:16,14)	= 0;
		Gmx_2_f(11:16,15)	= [0 1 -1 -1 1 0];
		Gmx_2_f(11:16,16)	= [-omal 0.5*opal 0.5*opal 0.5*opal 0.5*opal -omal];
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(11:16,12) = [opal omal omal omal omal opal];
		Gmx_2_nf(11:16,14) = [-1 -1 0 0 1 1];
	  case 22
		Gmx_2_f([moh(1:4) mu(3:4)],18)	= rad_gain;
		Gmx_2_f([moh(1:4) mu(3:4)],moh(1))= 0;
		Gmx_2_f([moh(1:4) mu(3:4)],moh(2))= [0 -1 1 0 0 0];
		Gmx_2_f([moh(1:4) mu(3:4)],moh(3))= 0;
		Gmx_2_f([moh(1:4) mu(3:4)],moh(4))= [1 -1 -1 1 0 0];
		Gmx_2_f([moh(1:4) mu(3:4)],mu(3))	= [-1 0 0 1 1 -1];
		Gmx_2_f([moh(1:4) mu(3:4)],mu(4))	= [0.5 0.5 0.5 0.5 -1 -1];
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([mu(3:4) moh(1) moh(4)],23) = [-1 1 -1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_d(2)*0.05*strang;
			end			
		elseif zip_sel(3)==-1
			Gmx_2_f([mu(3:4) moh(1) moh(4)],20) = [-1 1 -1 1]*zip_gain_p(2)*0.05;
		end
	  case 25 %New coil combination (SC, 03/09/04)
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f([11:12 14:15],23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
			Gmx_3_f([mu(1)-1 mu(2)+1],20) = [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f([11:12 14:15],20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end	
		Gmx_2_f([10:12 14:16],18)	= [opal omal omal omal omal opal]*rad_gain;
		Gmx_2_f([10:12 14:16],10)	= [1 0.5 -0.5 0.5 -0.5 -1];
		Gmx_2_f([10:12 14:16],11)	= [1 -1 1 -1 1 -1];
		Gmx_2_f([10:12 14:16],12)	= 0;
		Gmx_2_f([10:12 14:16],14)	= [-1 0 1 1 0 -1];
		Gmx_2_f([10:12 14:16],15)	= [omal -omal-opal omal omal -omal-opal omal]*0.5;
		Gmx_2_f([10:12 14:16],16)	= 0;
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf([10:12 14:16],12) = [opal omal omal omal omal opal];
		Gmx_2_nf([10:12 14:16],16) = [0 -1 -1 1 1 0];
	  case 26 %New coil combination (SC, 03/09/04)
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f(11:14,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f(11:14,23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f(11:14,20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
			Gmx_3_f([mu(1)-1 mu(2)+1],20) = [-1 1]*zip_gain_d(1)*0.1*strang;
		elseif zip_sel(3)==-1
			Gmx_2_f(11:14,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
		end	
		Gmx_2_f(10:15,18)	= [opal omal omal omal omal opal]*rad_gain;
		Gmx_2_f(10:15,10)	= [1 0.5 -0.5 0.5 -0.5 -1]; 
		Gmx_2_f(10:15,11)	= [1 -1 1 -1 1 -1]; 
		Gmx_2_f(10:15,12)	= 0; 
		Gmx_2_f(10:15,13)	= [-1 0 1 1 0 -1]; 
		Gmx_2_f(10:15,14)	= [omal -omal-opal omal omal -omal-opal omal]*0.5; 
		Gmx_2_f(10:15,15)	= 0; 
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(10:15,12) = [opal omal omal omal omal opal];
		Gmx_2_nf(10:15,15) = [0 -1 -1 1 1 0];
	  case 36 %New coil combination for small plasmas (SC, 06/09/04)
		Gmx_2_f(11:14,13) 	= [-1 1 1 -1];
		Gmx_2_f(11:14,11) 	= [1 -1 1 -1];
		Gmx_2_f(11:14,18) 	= rad_gain;
		if zip_sel(3)==0|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
			Gmx_2_f(11:14,20) = [-1 -1 1 1]*zip_gain_p(2)*0.05;
			if zip_sel(1)==2|zip_sel(1)==3|zip_sel(1)==4
				Gmx_3_f(11:14,23) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			else
				Gmx_3_f(11:14,20) = [-1 -1 1 1]*zip_gain_d(2)*0.05*strang;
			end			
		end	
		%No feedback
		Gmx_1_nf = Gmx_1_f;
		Gmx_2_nf = Gmx_2_f;
		Gmx_3_nf = Gmx_3_f;
		Gmx_1_nf(:,[18 20 21:24]) = 0;
		Gmx_2_nf(:,[18 20 22:24]) = 0;
		Gmx_3_nf(:,[18 20 21:24]) = 0;
		if zip_sel(1)==4
			Gmx_1_nf(:,3) = 0;
			Gmx_2_nf(:,3) = 0;
			Gmx_3_nf(:,3) = 0;
		end
		Gmx_2_nf(11:14,12) = [-1 -1 1 1];
		Gmx_2_nf(11:14,14) = [1 1 1 1];
	end
	
	% Fast coil 
	%---------------------------------------- 
	if zip_sel(3)==1
		Gmx_2_f(22,20) = -zip_gain_p(2)*0.1;
		Gmx_3_f(22,20) = -zip_gain_d(2)*0.1*strang;
	end
	if zip_sel(3)==-1|zip_sel(3)==-2|zip_sel(3)==-3|zip_sel(3)==-4|zip_sel(3)==-5
		Gmx_2_f(22,20) = -zip_gain_p(2)*0.1*kappa_gain(1);
		if zip_sel(2)~=2
			Gmx_3_f(22,20) = -zip_gain_d(2)*0.1*strang;
		elseif zip_sel(2)==2&zip_sel(3)~=5
			if zip_sel(1)==4 %zip_sel(1)=4 option introduced (SC, 21/04/05)
				Gmx_3_f(22,3) = -zip_gain_d(2)*0.1*strang;
			else
				Gmx_3_f(22,23) = -zip_gain_d(2)*0.1*strang;
			end
		elseif zip_sel(2)==2&zip_sel(3)==5
			Gmx_2_f(22,24) = -zip_gain_d(2)*2.5*strang;
		end
	end
	
	% Control-OFF
	Gmx_1(:,:,[1 6:msw]) 	= repmat(Gmx_1_nf,[1,1,msw-4]);
	Gmx_2(:,:,[1 6:msw]) 	= repmat(Gmx_2_nf,[1,1,msw-4]);
	Gmx_3(:,:,[1 6:msw]) 	= repmat(Gmx_3_nf,[1,1,msw-4]);
	% Control-ON		
	Gmx_1(:,:,2:5) 		= repmat(Gmx_1_f,[1,1,4]);
	Gmx_2(:,:,2:5) 		= repmat(Gmx_2_f,[1,1,4]);
	Gmx_3(:,:,2:5) 		= repmat(Gmx_3_f,[1,1,4]);
	
	if ip_sel(1)==1|ip_sel(1)==2|ip_sel(1)==12  
		if ip_gain(2)<=0, ip_gain(2) = 0.39; end
		Gmx_2(17:18,1,4:5) = ip_gain(2);
	end
	% ip_sel(1)=11, 21 (Vloop feedback) option added (SC, 23/9/03)
	% pegged to ip_gain (SC, 26/04/05)
	if ip_sel(1)==11|ip_sel(1)==21
		if ip_gain(2)<=0, ip_gain(2)=100; end
		Gmx_2(17:18,1,4:5) = ip_gain(2);
	end
	if ip_sel(1)==11
		Gmx_1(17:18,1,4:5) = ip_gain(3);
	end
	% ip_sel(1)=2 (two-component IOH feedback) option added (SC, 06/04/05)
	if ip_sel(1)==2|ip_sel(1)==12
		Gmx_2(17:18,2,4:5) = Gmx_2(17:18,1,4:5);
	end
	%ip_sel(1)=5 (plasma current control by ECRH power) option added (SC, 01/11/06)
	if ip_sel(1)==5
		if ip_gain(2)<=0, ip_gain(2)=0.39; end
		Gmx_2(17:18,1,4:5) = ip_gain(2);
		if ip_gain(3)<=0, ip_gain(3)=3.5; end
		if ip_sign==-1, ip_gain(3)=-ip_gain(3); end
		Gmx_2(1,19,4:5) = ip_gain(3);
	end
	%ip_sel(1)=6 (plasma elongation control by ECRH power) option added (SC, 02/11/06)
	if ip_sel(1)==6
		if ip_gain(2)<=0, ip_gain(2)=0.39; end
		Gmx_2(17:18,1,4:5) = ip_gain(2);
		if ip_gain(3)<=0, kappa_gain(1)=10; end
		if ip_sign==-1, kappa_gain(1)=-kappa_gain(1); end
		Gmx_2(1,22,4:5) = kappa_gain(1);
	end
	
	%Switch-off OH feedback
	Gmx_1(17:18,19,4) = 0;
	Gmx_2(17:18,19,4) = 0;
	if ip_sel(1)==1|ip_sel(1)==2|ip_sel(1)==5|ip_sel(1)==6|ip_sel(1)==11|ip_sel(1)==12|ip_sel(1)==21    
		Gmx_1(17:18,19,5) = 0;
		Gmx_2(17:18,19,5) = 0;
	end
	
	%FPS retarded
	Gmx_3(22,[20 23],2) = 0;
	if zip_sel(1)==4, Gmx_3(22,3,2) = 0; end
	
	%Gas gain reduced
	Gmx_2(21,21,1) = 0.0;
	Gmx_2(21,21,2) = 0.1;
	
	switch shape_sel(1)
	  case 12
		Gmx_2([moh(1:4),moh(4)],moh(4),5) = 0;
		Gmx_2([moh(1:4),moh(4)],22,5) = [1 -1 -1 1 0 0]*kappa_gain(1);
	  case 15 %New coil combination (SC, 03/09/04)
		Gmx_2([10:12 14:16],14,5) = 0;
		Gmx_2([10:12 14:16],22,5) = [1 0 -1 -1 0 1]*kappa_gain(1);
	  case 16 %New coil combination (SC, 03/09/04)
		Gmx_2(10:15,13,5) = 0;
		Gmx_2(10:15,22,5) = [1 0 -1 -1 0 1]*kappa_gain(1);
	  case 19 %New coil combination for small plasmas (SC, 03/09/04)
		Gmx_2(11:16,15,5) = 0;
		Gmx_2(11:16,22,5) = [0 1 -1 -1 1 0]*kappa_gain(1);
	  case 22
		Gmx_2([moh(1:4),moh(4)],moh(4),5) = 0;
		Gmx_2([moh(1:4),moh(4)],22,5)	= [1 -1 -1 1 0 0]*kappa_gain(1);
	  case 25 %New coil combination (SC, 03/09/04)
		Gmx_2([10:12 14:16],14,5) = 0;
		Gmx_2([10:12 14:16],22,5) = [1 0 -1 -1 0 1]*kappa_gain(1);
	  case 26 %New coil combination (SC, 03/09/04)
		Gmx_2(10:15,13,5) = 0;
		Gmx_2(10:15,22,5) = [1 0 -1 -1 0 1]*kappa_gain(1);
	  case 36 %New coil combination (SC, 06/09/04)
		Gmx_2(11:14,13,5) = 0;
		Gmx_2(11:14,22,5) = [1 -1 -1 1]*kappa_gain(1);
	end
	
	%Switch-off radial/vertical feddback
	if shape_sel(2) == 1
		switch shape_sel(1)
		  case 1
			Gmx_2(mu(3:4),[18 20],3) = 0;
			Gmx_3([mu(3:4) mu(1)-1 mu(2)+1],20,3) = 0;
		  case 2
			Gmx_2([mu(3:4) moh([1 4])],[18 20],3) = 0;
			Gmx_3([mu(3:4) moh([1 4]) mu(1)-1 mu(2)+1],20,3) = 0;
		  case 4
			Gmx_2([9 10 15 16],20,3) = 0;
			Gmx_2([11 14],11,3) = 0;
			Gmx_3([3 6 9 10 15 16],20,3) = 0;
		  case 7
			Gmx_2([11 12 14 15],[18 20],3) = 0;
			Gmx_3([11 12 14 15],20,3) = 0;
		  case 8 %New combination for small plasmas (SC, 03/09/04)
			Gmx_2([12 13 14 15],[18 20],3) = 0;
			Gmx_3([12 13 14 15],20,3) = 0;
		  case 9 %New combination for small plasmas (SC, 03/09/04)
			Gmx_2([13 14],13,3) = 0;
			Gmx_2([11 12 15 16],20,3) = 0;
			Gmx_3([3 6 11 12 15 16],20,3) = 0;
			if zip_sel(3)~=0
				Gmx_2(22,[20 23],3) = 0;
				Gmx_3(22,[20 23],3) = 0;
			end	
		  case 10 %New combination for small plasmas at top (SC, 18/01/05)
			Gmx_2([13 14 15 16],[18 20],3) = 0;
			Gmx_3([13 14 15 16],20,3) = 0;
		end
	end

elseif midplan == 8
	Gmx_1	= zeros(Gmx_nr,Gmx_nz,msw); %Integral gains
	Gmx_2	= zeros(Gmx_nr,Gmx_nz,msw); %Proportional gains
	Gmx_3	= zeros(Gmx_nr,Gmx_nz,msw); %Differential gains
	
	%Gas control
	%------------------------
	Gmx_1(21,21,1:4)	= 1/6*dens_gain_i;
	Gmx_2(21,21,1:4)	= 1/6*dens_gain_p;
	Gmx_3(21,21,1:4)	= 1/6*dens_gain_d;

	%OH control
	%------------------------
	Gmx_1(17,17,1:4)	= 0.25*dioh_gain_i;
	Gmx_1(18,17,1:4)	= -0.25*dioh_gain_i;
	Gmx_2(17,17,1:4)	= 0.25*dioh_gain_p;
	Gmx_2(18,17,1:4)	= -0.25*dioh_gain_p;

	%Plasma current control
	%------------------------
	Gmx_1(17,19,1:4)	= -ip_gain(2);
	Gmx_1(18,19,1:4)	= -ip_gain(2);
	Gmx_2(17,19,1:4)	= -ip_gain(1);
	Gmx_2(18,19,1:4)	= -ip_gain(1);
	
	%EF Control
	%------------------------
	Gmx_2(1:8,1:8,1:4)	= 0.25;
	Gmx_2([10 11 14 15],[10 11 14 15],1:4)	= repmat(eye(4),[1,1,4]);
	%msw = 1
	Gmx_2([9 12 13 16],[9 12 13 16],1) = ...
		[1.167,1.177,0.35,0.472; ...
		-1.069,1.448,0.856,1.056; ...
		-1.056,0.856,1.448,1.069; ...
		-0.472,0.35,1.177,-1.167];
	%msw = 2	
	if iplatop == 1
		Gmx_2([9 12 13 16],[9 12 16 18],2) = ...
			[0.77,0.15,0.091,0.141*rad_gain; ...
			-0.827,0.603,-0.377,-0.508*rad_gain; ...
			0.377,-0.508,0.827,0.603*rad_gain; ...
			-0.091,0.141,-0.77,0.15*rad_gain];
	elseif iplatop == -1
		Gmx_2([9 12 13 16],[9 13 16 23],2) = ...
			[0.77,0.141,0.091,0.15*rad_gain; ...
			-0.827,-0.508,-0.377,0.603*rad_gain; ...
			0.377,0.603,0.827,-0.508*rad_gain; ...
			-0.091,0.15,-0.77,0.141*rad_gain];
	elseif iplatop == 0
		Gmx_2([9 12 13 16],[9 16 18 23],2) = ...
			[0.77,0.091,0.141*rad_gain,0.15*rad_gain; ...
			-0.827,-0.377,-0.508*rad_gain,0.603*rad_gain; ...
			0.377,0.827,0.603*rad_gain,-0.508*rad_gain; ...
			-0.091,-0.77,0.15*rad_gain,0.141*rad_gain];	
	end
	%msw = 3:4	
	if iplatop == 1
		Gmx_2([9 12 13 16],[9 12 18 20],3:4) = repmat( ... 
			[0.77,0.15,0.141*rad_gain,-0.091*0.1*zip_gain_p(2); ...	
			-0.827,0.603,-0.508*rad_gain,0.377*0.1*zip_gain_p(2); ...
			0.377,-0.508,0.603*rad_gain,-0.827*0.1*zip_gain_p(2); ...
			-0.091,0.141,0.15*rad_gain,0.77*0.1*zip_gain_p(2)],[1,1,2]);
		Gmx_3([9 12 13 16],20,3:4) = repmat( ...
			[-0.091,0.377,-0.827,0.77].*0.1*zip_gain_d(2)*strang,[1,1,2]);
	elseif iplatop == -1
		Gmx_2([9 12 13 16],[13 16 22 23],3:4) = repmat( ...
			[0.141,0.091,0.77*0.1*zip_gain_p(2),0.15*rad_gain; ...
			-0.508,-0.377,-0.827*0.1*zip_gain_p(2),0.603*rad_gain; ...
			0.603,0.827,0.377*0.1*zip_gain_p(2),-0.508*rad_gain; ...
			0.15,-0.77,-0.091*0.1*zip_gain_p(2),0.141*rad_gain],[1,1,2]);
		Gmx_3([9 12 13 16],22,3:4) = repmat( ...
			[0.77,-0.827,0.377,-0.091].*0.1*zip_gain_d(2)*strang,[1,1,2]);
	elseif iplatop == 0
		Gmx_2([9 12 13 16],[18 20 22 23],3:4) = repmat( ...
			[0.141*rad_gain,-0.091*0.1*zip_gain_p(2),0.77*0.1*zip_gain_p(2),0.15*rad_gain; ...
			-0.508*rad_gain,0.377*0.1*zip_gain_p(2),-0.827*0.1*zip_gain_p(2),0.603*rad_gain; ...
			0.603*rad_gain,-0.827*0.1*zip_gain_p(2),0.377*0.1*zip_gain_p(2),-0.508*rad_gain; ...
			0.15*rad_gain,0.77*0.1*zip_gain_p(2),-0.091*0.1*zip_gain_p(2),0.141*rad_gain],[1,1,2]);
		Gmx_3([9 12 13 16],[20 22],3:4) = repmat( ...
			[-0.091,0.377,-0.827,0.77; ...
			0.77,-0.827,0.377,-0.091].*0.1*zip_gain_d(2)*strang,[1,1,2]);
	end
end


%---------------------------------------- 
%  
%%	WRIMXDR subroutine
%---------------------------------------- 
pos_cor	=	[IpDz_xc(1:coil_n)'; ...
		 NT; ...
		 t(:); ...
		 EF_Cur(:); ...
		 diohdt_n; ...
		 diohdt_time(:); ...
		 aipcor(:); ...
		 Amx_nr;Amx_nz;msw;Amx(:); ...
		 Gmx_nr;Gmx_nz;msw;Gmx_1(:);Gmx_2(:);Gmx_3(:); ...
		 Mmx_nr;Mmx_nz;msw;Mmx(:); ...
		 reshape(EF_Wave(1:NT,:),NT*length(EF_Wave(1,:)),1); ...
		 reshape(EF_Volts(1:NT,:),NT*length(EF_Volts(1,:)),1); ...
		 bt_oft(:); ...
		 ohcur(:); ...
		 Z_ref(1:NT); ...
		 K_ref(:); ...
		 it];
save pos_cor.dat -ascii pos_cor

xdr.nra     = Amx_nr;
xdr.nca     = Amx_nz;
xdr.nrg     = Gmx_nr;
xdr.ncg     = Gmx_nz;
xdr.nrm     = Mmx_nr;
xdr.ncm     = Mmx_nz;
xdr.ntoft   = diohdt_n;
xdr.noht    = NT;
xdr.midplan = midplan;
xdr.iscramb = shape_sel(1);
xdr.nsw     = msw;
xdr.nfast   = zip_sel(3);
xdr.mvloop  = ip_sel(1);
xdr.relovo  = vloop;
xdr.aipgain = ip_gain;
xdr.inova   = zip_sel(1);
xdr.aaasw   = Amx(:);
xdr.g1sw    = Gmx_1(:);
xdr.g2sw    = Gmx_2(:);
xdr.g3sw    = Gmx_3(:);
xdr.amlsw   = Mmx(:);
xdr.efwave  = reshape(EF_Wave(1:NT,:),NT*size(EF_Wave,2),1);
xdr.efcur   = reshape(EF_Cur(1:NT,:),NT*size(EF_Cur,2),1);
xdr.efvolt  = reshape(EF_Volts(1:NT,:),NT*size(EF_Volts,2),1);
xdr.toft    = diohdt_time(:);
xdr.aipoft  = aipcor(:);
xdr.bzeroft = bt_oft(:);
xdr.ohcur   = ohcur(:);
xdr.toh     = t(:);
xdr.zeref   = Z_ref(1:NT);
xdr.cayref  = K_ref(:);
save('/tmp/mgams18.mat','-struct','xdr');
mat2xdr('/tmp/mgams18.mat',['conmat18-' int2str(shot) '-mat.xdr']);
