pro wave_put,name,wave_in,time_in,as_is,filt_in,quiet=quiet

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : WAVE_PUT.pro

; PURPOSE :
; To prepare a valid waveform for putting into a drawable

; ARGUMENTS :
; name		MDS node name
; wave_in	y-axis, either 1-D or 8 stacked traces
; time_in	x-axis
; 'as_is'	optional argument, if absent, then filtering
; filt_in	tolerance for removing points (= eps in routine erp)

; RESTRICTIONS :

; UPDATED/REASONS :
; 	Jo Lister 	Oct 1992	Original
;	Jo Lister 	Mar 93		Faster with virtual dim_of
;	Jo Lister	Aug 1994	Optional filtering
;	Jo Lister	May 95		Limit on points after filter
;	Jo Lister	Dec 97		Remove control put, change pl
;	XLl/SC		Dec 06		Adapted for using tracks
;-
; Controlled by :       Jo
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

; leave the traces untouched

time = time_in
wave = wave_in

sizew = size(wave)
ndims = sizew(0)
if ((ndims ne 1) and (sizew(1) eq 1)) then begin
  wave = transpose(wave)
  sizew = size(wave)
  ndims = sizew(0)
endif
npts  = sizew(1)
trackflag = 1
dimflag   = 1

if ((ndims ne 1) and (sizew(2) ne 1)) then $
  if (ndims ne 2) then dimflag = 0         $
  else if (sizew(2) ne 8) then dimflag = 0 $
       else dimflag = 8

if (dimflag eq 0) then begin
   pwint,' WAVE_PUT: Wrong dimensions of second argument'
   !tcvcs_error = 'WAVE_PUT : BAD VIBES '+name
   return
endif 

ntime = n_elements(time)

if (npts ne ntime) then begin
  pwint,' WAVE_PUT : BAD VIBES TRY AGAIN !!',name
  help,wave,time
  !tcvcs_error = 'WAVE_PUT : BAD VIBES '+name
  return
endif

; align the points with integral milliseconds for the snap grid in waveedit
; !!To be modified for new Wavegens!! */
; YM 26.1.2007 Modified for new Wavegens !! (1e-3 -> 1e-4 / 0.9e-3 -> 0.9e-4)
dt = 1.e-4
time = -10.0 + dt*long((time+10.0+dt/2.)/dt)
; check that the times are never the same
min_delta_time = min( time(1:ntime-1)-time(0:ntime-2), cmin)
if(min_delta_time lt 0.9e-4) then begin
  pwint,' WAVE_PUT : BAD TIME-BASE DELTAS min separation '+name
  pwint,min_delta_time,' @ ',time(cmin+1 : cmin+2)
  help,time
  pwint,time
  !tcvcs_error = 'WAVE_PUT : BAD TIME-BASE DELTAS '+name
  return
endif

node = strtrim(strupcase(name))
if (strmid(node, strlen(node)-10, 9) eq ':TRACK_00') then begin
   track = strmid(node, strlen(node)-9, 9)
   node  = strmid(node, 0, strlen(node)-10)
endif else track = 'TRACK_000'

mds$tcl,'set def '+node

if (strtrim(node) ne '\PCS::DRAW_FEEDFOR_TOR_I:ALIM_001') then begin

  limits = mds$value(node+':LIMITS')

  wave=float(wave)

  count = 0
  for i=0,ndims-1 do begin
    ind = where(wave(*,i) gt limits(1) or wave(*,i) lt limits(0),count)
    if ( count gt 0 ) then begin
      pwint,'WAVE_PUT Clamping the proposed signal ',node+':TRACK_'+iii(i)
      pwint,' Limits  are ',limits,' Min/Max were',min(wave(*,i)),max(wave(*,i))
      plot,time,wave(*,i),title=node+' CLAMPING',yrange=[limits(0)*0.9,limits(1)*1.1]
      oplot,time,fltarr(n_elements(time))+limits(0)
      oplot,time,fltarr(n_elements(time))+limits(1)
      wait,0.5
      ind0 = where(wave(*,i) lt limits(0),count0)
      ind1 = where(wave(*,i) gt limits(1),count1)
      if(count0 gt 0) then wave(ind0,i)=limits(0)
      if(count1 gt 0) then wave(ind1,i)=limits(1)
    endif
  endfor
endif

children = mds$value('getnci($1,"node_name")',node+":*")
indf = where(strpos(strtrim(strupcase(children)),'TRACK_000') eq 0) 
if (indf(0) eq -1) then begin
  trackflag=0
  if (dimflag eq 8) then begin
     pwint,' WAVE_PUT: attempted to write tracks in node without tracks'
     !tcvcs_error = 'WAVE_PUT : BAD VIBES '+node
     return
  endif
endif 

if (strtrim(!tcvcs_error) ne '') then begin
  pwint,' WAVE_PUT : NO PUT - TCVCS ERROR '+!tcvcs_error
  return
endif

; here we do the filtering
; !!To be modified for new Wavegens!! */
ind = -1
if(n_params() ne 4 and npts gt 5) then begin	; filter out redundant points
  filter = 0.005
  if(n_params() eq 5) then filter=filt_in
  if (dimflag eq 1) then begin
    ind = erp(time(*),wave(*),filter)
    npts = n_elements(ind)

;   plot,time,wave,psym=1
;   oplot,time(ind),wave(ind),psym=2
    pwint,node,' ',n_elements(wave),npts
    wave = wave(ind)
    time = time(ind)
  endif 
endif else begin		; DON'T filter the wave (i.e. as_is)
  pwint,node,' ',n_elements(wave),'  (as_is)'
endelse

; !!To be modified for new Wavegens!! */
; Modified for new Wavegens (SC, 21/02/07)
; if (npts gt 800) then begin
if (npts gt 30000) then begin
  !tcvcs_error = 'WAVE_PUT : TOO MANY POINTS after Filtering '+node
  pwint,!tcvcs_error
  help,wave,time
;!!  return
endif

if (trackflag eq 1) then begin
  mds$put,'TIME','$',time
  for i=0,7 do $
    mds$put,'TRACK_'+iii(i),'Build_Signal($,*,TIME)',wave(*, i*(dimflag eq 8))
  mds$put,'CONTROL','Build_Signal(DRAW_KNOTS, *, TIME)'
endif else begin
  mds$put,node,'Build_Signal($,*,$)',wave(*),time(*)
  mds$put,'CONTROL','Build_Signal(DRAW_KNOTS,*,Dim_of('+node+'))'
endelse
mds$put,'DRAW_KNOTS','$', bytarr(npts)+1b

end
