pro fbte18,index,pcs_path,ioh1values,nobphi=nobphi
;ympro fbte18,index,nogas=nogas,nobphi=nobphi

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

; TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; As such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

; Updated/Reason:
; Sept 98 to add keywords to stop FBTE overwriting the gas/bphi

; Controlled by :       Jo

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

; *****************************************************

; Jo Lister October 1992

; Provides a template for interfacing individual algorithms to the
; TCV Plasma Control System (PCS)

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; obligatory code is defined like this, between the + and the -
;----------------------------------------------------------------

; Obligatory user-actions are defined with an end-of-line               ;!!!!!!!!

; *****************************************************

; F. Hofmann, November 1994

; To control a circular plasma corresponding to equilibrium fbte36

ALGO = 'FBTE18'								;!!!!!!!!

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Obligatory bookkeeping                             ;
!tcvcs_error = ' '                                              ;
algo = string(algo)                                             ;
print,'STARTING '+algo+' @ '+!stime                             ;

; check that there is an index argument                         ;
if (n_params() lt 1) then begin                                 ;
 print,algo+' takes at least 1 argument'                        ;
 return                                                         ;
endif                                                           ;
if (not keyword_set(pcs_path)) then begin                       ;
  pcs_path='hybrid'
endif
pcs_path=strlowcase(pcs_path)
print,'PCS_PATH is '+pcs_path
; ########## Get the Mutual Matrix, and use its labelling list  ;
mds$open,'tcv_shot',-1                                          ;
mds$put,'\PCS::TOP:ID','"""'+algo+'"""'                         ;

; initialize the Wavegen masks
wave_mask=fltarr(128)+1.0
mds$put,'\load_wave_mask','$',wave_mask

; ########## Define the A Matrix lists                          ;
;----------------------------------------------------------------

; read conmat18.sav 

; Set up MGAMS default directory according to Physicien-du-Jour.
; if  FH --> USER:[HOFMANN.MGA]
; if  HW --> USER:[WEISEN.MGAMS]
; if  JM --> USER:[MORET.MGAMS]  
; if  CN --> USER:[NIESWAND.MGAMS]
; if  YM --> USER:[MARTIN.MGAMS]    
;pdj=strupcase(strmid(vcs_sget('OPERATORDB::PDJ:NAME'),0,2))
;case pdj of
;	'JM': mga_dir='USER:[MORET.MGAMS]' 
;	'HW': mga_dir='USER:[WEISEN.MGAMS]' 
;	'FH': mga_dir='USER:[HOFMANN.MGA]'
;	'CN': mga_dir='USER:[NIESWAND.MGAMS]' 
;	'YM': mga_dir='USER:[MARTIN.MGAMS]' 
;;	ELSE: mga_dir='USER:[HOFMANN.MGA]' ; !! Too dangerous, better to STOP
;	ELSE: begin
;		print,'STOPPING: Unknown PdJ - Please specify and retry'
;		!tcvcs_error = 'FBTE18: A valid "PdJ" must be specified --> retry'
;		return
;	      end
;endcase
;mga_dir='TCV_ROOT:[TCV_OPER.MGAMS]'
;print,'Setting MGAMS directory for the PdJ to : ',mga_dir
;restore,mga_dir+'CONMAT18.SAV'

; instructions for reading from nodes instead (SC, 11/03/11)
mds$tcl,'set def \mgams.mga'

;; The automatic way below does not work in IDL because:
;;   "Do not use EXECUTE to create new variables 
;;    inside procedures or functions. Attempts to create 
;;    new variables result in the error "Program data area full"."
;; However, this can be used as a template for Matlab translation using eval
;nodes=mds$value('getnci("\\mgams.mga:*","path")')    
;ind=strpos(nodes(0),'MGA:')
;for nn=0,n_elements(nodes)-1 do begin
;  node=nodes(nn)
;  varname=strlowcase(strmid(node,ind+4,strlen(node)-ind-4))
;  dummy=execute(varname+' = mds$value(''execute(_nodes['+ii(nn)+'])'')')
;endfor

; the explicit list below is a block generated by mgaread_generate.pro and
;   contained in mgaread.pro
aaasw = mds$value('aaasw')
aipoft = mds$value('aipoft')
amlsw = mds$value('amlsw')
bzeroft = mds$value('bzeroft')
cayref = mds$value('cayref')
efcur = mds$value('efcur')
efvolt = mds$value('efvolt')
efwave = mds$value('efwave')
g1sw = mds$value('g1sw')
g2sw = mds$value('g2sw')
g3sw = mds$value('g3sw')
midplan = mds$value('midplan')
nca = mds$value('nca')
ncg = mds$value('ncg')
ncm = mds$value('ncm')
noht = mds$value('noht')
nra = mds$value('nra')
nrg = mds$value('nrg')
nrm = mds$value('nrm')
nsw = mds$value('nsw')
ntoft = mds$value('ntoft')
ohcur = mds$value('ohcur')
toft = mds$value('toft')
toh = mds$value('toh')
zeref = mds$value('zeref')

; Additional reads from \mgams.data
mds$tcl,'set def \mgams.data'
aipgain = mds$value('aipgain')
inova = mds$value('inova')
iscramb = mds$value('iscramb')
mvloop = mds$value('mvloop')
nfast = mds$value('nfast')
relovo = mds$value('relovo')

mds$tcl,'set def \top'

!error=0

toh2=toh

;get real to virtual flux/voltage transformation matrix 
tfr=mds$value('\MAGNETICS::T_F_R')

; ##########################################  create the A-Matrix

; specify the inputs to be used

; MODIFIED TO REMOVE RVLOOP_003
; replace CTLAMP:UPOL_G_001 on ch. 118 by 1MM_FRINGE (SC, 27/02/11)
amat_inputs = [                                            	$  !!!!!!!
 	'CTLINT:VLOOP_001', 					$
	'CTLINT:RVLOOP_'+iii(indgen(37)+2), 			$
       	'CTLINT:BPOL_AVG_'+iii(indgen(38)+1), 			$
       	'CTLAMP:IPOL_E_'+iii(indgen(8)+1),			$
 	'CTLAMP:IPOL_F_'+iii(indgen(8)+1),			$
 	'CTLAMP:IPOL_OH_'+iii(indgen(2)+1),			$
	'CTLAMP:BPOL_AVG_'+iii([2,3,4,5,6,8,11,17,18,19]),	$
	'CTLAMP:BPOL_AVG_'+iii([21,22,23,29,32,34,35,36,37,38]), $
      	'CTLAMP:IPOL_DOH_001',                                  $
        'FIR_FRINGE',                                           $
        'CTLAMP:IPOL_G_001',                                    $
        '1MM_FRINGE','CTLAMP:VLOOP_001','CTLAMP:IPHI_001']
                         
; specify the outputs to be used				;!!!!!!!!!
amat_outputs = [				$
 'cp001', 'cp002', 'cp003', 'cp004', 'cp005',   $	; eps-psi
 'cp006', 'cp007', 'cp008', 'cp009', 'cp010',   $	; eps-psi
 'cp011', 'cp020', 'cp019', 'cp014', 'cp015',   $	; eps-psi
 'cp016', 'cp017', 'cp018',		  	$	; eps-psi
 'cp013_IP',					$    	; Ip    
 'cp012_IP*Z',					$    	; Ip*Zp 
 'cp021_DENS',					$    	; Fringes
 'cp022', 'cp023', 'cp024']
; #################################################### GATES

if midplan ne 8 then begin
   if nfast eq 0 then begin 
   if iscramb ne 12 and iscramb ne 15 and iscramb ne 16 and iscramb ne 19 $
	and iscramb ne 25 and iscramb ne 26 and iscramb ne 36 $
	and mvloop(0) ne 6 then begin
 amat_outputs = amat_outputs+[replicate('_P',16),            $
            '_DELTA_OH','_DELTA_R','A','A','A','!','!','!']
   endif
   if iscramb eq 12 or iscramb eq 15 or iscramb eq 16 or iscramb eq 19 $
	or iscramb eq 25 or iscramb eq 26 or iscramb eq 36 $
	or mvloop(0) eq 6 then begin
 amat_outputs = amat_outputs+[replicate('_P',16),            $
            '_DELTA_OH','_DELTA_R','A','A','A','A','!','!']
   endif 
   endif
   if nfast ne 0 then begin
   if nfast ne -5 then begin
   if iscramb ne 12 and iscramb ne 15 and iscramb ne 16 and iscramb ne 19 $
	and iscramb ne 25 and iscramb ne 26 and iscramb ne 36 $
	and mvloop(0) ne 6 then begin
 amat_outputs = amat_outputs+[replicate('_P',16),            $
            '_DELTA_OH','_DELTA_R','A','A','A','!','A','!']
   endif
   if iscramb eq 12 or iscramb eq 15 or iscramb eq 16 or iscramb eq 19 $
	or iscramb eq 25 or iscramb eq 26 or iscramb eq 36 $
	or mvloop(0) eq 6 then begin
 amat_outputs = amat_outputs+[replicate('_P',16),            $
            '_DELTA_OH','_DELTA_R','A','A','A','A','A','!']
   endif 
   endif else begin
   if iscramb ne 12 and iscramb ne 15 and iscramb ne 16 and iscramb ne 19 $
	and iscramb ne 25 and iscramb ne 26 and iscramb ne 36 $
	and mvloop(0) ne 6 then begin
 amat_outputs = amat_outputs+[replicate('_P',16),            $
            '_DELTA_OH','_DELTA_R','A','A','A','!','A','A']
   endif
   if iscramb eq 12 or iscramb eq 15 or iscramb eq 16 or iscramb eq 19 $
	or iscramb eq 25 or iscramb eq 26 or iscramb eq 36 $
	or mvloop(0) eq 6 then begin
 amat_outputs = amat_outputs+[replicate('_P',16),            $
            '_DELTA_OH','_DELTA_R','A','A','A','A','A','A']
   endif 
   endelse
   endif
   
endif
if mvloop(0) eq 8 then begin
 amat_outputs = amat_outputs+[replicate('_P',16),            $
            '_DELTA_OH','A','A','A','A','A','A','!']
endif
;
if mvloop(0) eq 18 then begin
 amat_outputs = amat_outputs+[replicate('!',8),replicate('_P',8),     $
            '_DELTA_OH','A','A','A','A','A','A','!']
endif 
;
; specify whether the references are 'Ip' or '10V' Volts	;!!!!!!
amat_refs = replicate('10V',24)

; specify the desired output scales in MKSA/Volt
; ??  out_scales are twice in_scales to give calibration factor of 0.5
;
if mvloop(0) ne 1 and mvloop(0) ne 11 and mvloop(0) ne 21 and mvloop(0) ne 2 $
	and mvloop(0) ne 12 and (mvloop(0) mod 10) ne 5 then begin
; increased amat_out_scale[22] to 1.7e4(1.4e4) to avoid overflows (SC, 23/04/03)
; back to 1.4e4 because 1.7e4 produces overflows for z=0 bd (JMM, 06/05/03)
; back to 1.7e4 because 1.4e4 produces overflows for z=0 bd (JMM, 09/05/03)
; back to 1.4e4 because 1.7e4 produces overflows for z=0 bd (HW, 09/05/03, late shift)
; back to 1.7e4 along with change in feed_gains (see below) (SC, 12/05/03)
; increased to 1.8e4 to avoid overflows (SC, 14/05/04)
;
; increased amat_out_scale[21] to 1.2e4(1.0e4) to avoid overflows (SC, 31/03/05)
; increased amat_out_scale[21] to 1.3e4(1.2e4) to avoid overflows (SC, 18/05/05)
; increased amat_out_scale[21] to 1.4e4(1.3e4) to avoid overflows (SC, 12/12/05)
amat_out_scale = [				$
 replicate(2.200e3,16), 7.48e3,			$	; Amp/volt
 2.2e3, 1.1e5,					$	; Ip
 2.7e4,						$	; Amp*meter/volt
 4.0,						$	; Fringes/volt
 1.4e4,						$	; Amp/volt
 1.8e4, 240.0e4					]	; Amp*m**2/volt
endif  
;
if mvloop(0) eq 1 or (mvloop(0) mod 10) eq 5 then begin
; increased amat_out_scale[22] to 1.7e4(1.4e4) to avoid overflows (SC, 23/04/03)
; back to 1.4e4 because 1.7e4 produces overflows for z=0 bd (JMM, 06/05/03)
; back to 1.7e4 because 1.4e4 produces overflows for z=0 bd (JMM, 09/05/03)
amat_out_scale = [				$  
 7.48e3, replicate(2.200e3,15), 7.48e3,		$	; Amp/volt
 2.2e3, 1.1e5,					$	; Ip
 2.7e4,						$	; Amp*meter/volt
 4.0,						$	; Fringes/volt
 1.0e4,						$	; Amp/volt
 1.7e4,120.0e4					]	; Amp*m**2/volt
endif
;
if (mvloop(0) mod 10) eq 5 then begin
 if mvloop(0) le 100 then begin
   amat_out_scale(18)=1.1e5/1.5;
 endif else begin
   amat_out_scale(3)=1.1e5/3;
 endelse
endif
if mvloop(0) eq 6 then begin
   amat_out_scale(21)=1.4e4;
   amat_out_scale(0)=1.4e4;
endif
;
; Vloop feedback option added (SC, 23/09/03)
if mvloop(0) eq 11 then begin
amat_out_scale = [				$  
 10., replicate(2.200e3,15), 7.48e3,		$	; Amp/volt
 2.2e3, 1.1e5,					$	; Ip
 2.7e4,						$	; Amp*meter/volt
 4.0,						$	; Fringes/volt
 1.0e4,						$	; Amp/volt
 1.7e4,120.0e4					]	; Amp*m**2/volt
endif
if mvloop(0) eq 21 then begin
amat_out_scale = [				$  
 1., replicate(2.200e3,15), 7.48e3,		$	; Amp/volt
 2.2e3, 1.1e5,					$	; Ip
 2.7e4,						$	; Amp*meter/volt
 4.0,						$	; Fringes/volt
 1.0e4,						$	; Amp/volt
 1.7e4,120.0e4					]	; Amp*m**2/volt
endif
;
; Two-component IOH feedback (SC, 06/04/05)
if mvloop(0) eq 2 or mvloop(0) eq 12 then begin
; set amat_out_scale[1] based on actual max current required, to maximize
;   resolution (0.85 V -> 8.5 V at G2 input)
amatout2 = max(abs(ioh1values))/.85;
amat_out_scale = [				$  
 7.48e3,amatout2, replicate(2.200e3,14), 7.48e3,$	; Amp/volt
 2.2e3, 1.1e5,					$	; Ip
 2.7e4,						$	; Amp*meter/volt
 4.0,						$	; Fringes/volt
 1.0e4,						$	; Amp/volt
 1.7e4,120.0e4					]	; Amp*m**2/volt
endif
;
; inova=4 option added (SC, 25/04/05)
if inova eq 4 then amat_out_scale(2) = 1.7e4		; 
;
if midplan eq 8 then begin
amat_out_scale = [				$
 replicate(2.200e3,16), 7.48e3,			$	; Amp/volt
 1.2e3, 1.0e5,					$	; Ip
 8.0e3,						$	; Amp*meter/volt
 4.0,						$	; Fringes/volt
 8.0e3,						$	; Amp/volt
 1.200e3, 2.2e5					]	; Amp*m**2/volt
endif
if midplan eq 9 then begin
amat_out_scale = [				$
 replicate(2.200e3,16), 7.48e3,			$	; Amp/volt
 2.2e3, 1.0e5,					$	; Ip
 2.3e4,						$	; Amp*meter/volt
 4.0,						$	; Fringes/volt
 2.2e3,						$	; Amp/volt
 2.200e3, 2.2e3					]	; Amp*m**2/volt
endif

if iscramb eq 0 then amat_out_scale(17)=7.48e3

a_out_scale = amat_out_scale

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Prepare the A Matrix                               ;
amat= fltarr(n_elements(amat_outputs),n_elements(amat_inputs),1);
; ########## Prepare the A Matrix observer outputs in turn      ;
;----------------------------------------------------------------

;prepare transformation to virtual flux/voltages
;
;construct complete transformation matrix
tf=fltarr(120,120)
tf(0,0)=tfr
for i=38,119 do tf(i,i)=1.0
;
;calculate the modified a matrix and convert from 3D to 2D
a=aaasw(*,*,0)#tf
g1=g1sw
g2=g2sw
g3=g3sw
aml=amlsw(*,*,0)
ioh=-1500.
ioh1=0.
if midplan ne 8 then begin
 if mvloop(0) ne 1 and mvloop(0) ne 11 and mvloop(0) ne 21 and mvloop(0) ne 2 $
	and mvloop(0) ne 12 and (mvloop(0) mod 10) ne 5 then begin
  if iscramb ne 12 and iscramb ne 15 and iscramb ne 16 and iscramb ne 19 $
	and iscramb ne 25 and iscramb ne 26 and iscramb ne 36 $
	and mvloop(0) ne 6 then begin
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:A',[0,0,0,0,0],[-0.3,0.01,0.07,2.7,2.8]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:G',[0,1,2,3,0],[-0.3,0.01,0.07,2.7,2.8]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:M',[0,0,0,0,0],[-0.3,0.01,0.07,2.7,2.8]
  endif else begin
  ton=0.3
  toff=2.45
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:A',[0,0,0,0,0,0,0],[-0.3,0.01,0.07,ton,toff,2.7,2.8]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:G',[0,1,2,4,2,3,2],[-0.3,0.01,0.07,ton,toff,2.7,2.8]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:M',[0,0,0,0,0,0,0],[-0.3,0.01,0.07,ton,toff,2.7,2.8]
  endelse
 endif
;
 if mvloop(0) eq 1 or mvloop(0) eq 11 or mvloop(0) eq 21 or mvloop(0) eq 2 or $
	mvloop(0) eq 12 or (mvloop(0) mod 10) eq 5 then begin
  ton=0.4
  toff=2.5
  if iscramb ne 12 and iscramb ne 15 and iscramb ne 16 and iscramb ne 19 $
	and iscramb ne 25 and iscramb ne 26 and iscramb ne 36 then begin
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:A',[0,0,0,0,0],[-0.3,0.01,0.07,ton,toff]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:G',[0,1,2,3,2],[-0.3,0.01,0.07,ton,toff]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:M',[0,0,0,0,0],[-0.3,0.01,0.07,ton,toff]
  endif else begin
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:A',[0,0,0,0,0],[-0.3,0.01,0.07,ton,toff]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:G',[0,1,2,4,2],[-0.3,0.01,0.07,ton,toff]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:M',[0,0,0,0,0],[-0.3,0.01,0.07,ton,toff]
  endelse
;
 endif
endif
if midplan eq 8 then begin
wave_put,'\PCS::PHYS_MAT_ADDRESSES:A',[0,0,0,0],[-0.3,0.01,2.00,2.1]
wave_put,'\PCS::PHYS_MAT_ADDRESSES:G',[0,2,3,0],[-0.3,0.01,2.00,2.1]
wave_put,'\PCS::PHYS_MAT_ADDRESSES:M',[0,0,0,0],[-0.3,0.01,2.00,2.1]
endif  
if iscramb eq 0 then begin
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:A',[0,0,0,0,0],[-0.3,0.01,0.07,2.7,2.8]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:G',[0,0,0,0,0],[-0.3,0.01,0.07,2.7,2.8]
  wave_put,'\PCS::PHYS_MAT_ADDRESSES:M',[0,0,0,0,0],[-0.3,0.01,0.07,2.7,2.8]
endif

; #################################################### GAINS		;!!!!!!

; increased feed_gains[22] to 2(1) to avoid overflows (SC, 12/05/03)
; increased feed_gains[21] to 2(1) to avoid overflows (SC, 29/09/04)
; increased feed_gains[22] to 4(2) to avoid overflows (SC, 30/10/09)
feed_gains=[1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,4,4,8]
if mvloop(0) eq 11 then feed_gains(0) = 8
if (mvloop(0) mod 10) eq 5 then begin
  feed_gains(18) = 8
  if mvloop(0) gt 100 then feed_gains(3)=8
endif
if mvloop(0) eq 6 then feed_gains(0) = 8

; inova=4 option added (SC, 25/04/05)
if inova eq 4 then feed_gains(2) = 2		; 

amat=a
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Put the A-Matrix to the tree, Prepare the refs     ;
mat_put,'A',amat,amat_inputs,amat_outputs,amat_out_scale        ;
gmat_inputs = amat_outputs                                      ;
set_gains,feed_gains                                            ;
setup_refs,amat_out_scale,amat_outputs,amat_refs                ;
for i=0,n_elements(amat_outputs)-1 do  $                        ;
        print,amat_outputs(i),amat_refs(i),amat_out_scale(i),$  ;
        format='(a15,a10,1e12.3)'                               ;
; The G-matrices are defined so that output = - G1 * error      ;
; ########## Create the G1..3 Matrices variable lists           ;
;----------------------------------------------------------------

; specify the G Matrix outputs						;!!!!!!!
gmat_outputs = 'GO'+iii(indgen(22)+1)

; specify the desired G Matrix output sensitivities
; the factor 50, below, divided by the factor 100, which is hard-wired
; into mat_do, gives a G matrix calibration of 0.500
; If the full_scale of G is changed from 0.5 to 2.0, and the factor 100
; in mat_do is changed according to the variable gain setting,the factor
; 50 must be adapted!
; MAT_OUT_SCALE=MAT_OUT_SCALE/50
 if nfast eq -5 then begin
 gmat_out_scale = [				$
 replicate(4.400e1,16), 14.96e1, 14.96e1,	$	; Amp/volt
 2.0e3,						$	; Ip
 2.4e2,						$	; Amp*meter/volt
 0.15,						$	; Fringes/volt
 88.						]	; Amp/volt
 endif
 if nfast ne -5 then begin
 gmat_out_scale = [				$
 replicate(4.400e1,16), 14.96e1, 14.96e1,	$	; Amp/volt
 2.0e3,						$	; Ip
 2.4e2,						$	; Amp*meter/volt
 0.15,						$	; Fringes/volt
 66.						]	; Amp/volt
 endif 
if (mvloop(0) mod 10) eq 5 then begin
  gmat_out_scale(0) = 1.e4 ; RHVPS volts/volt
  if (mvloop(0) mod 100) eq 25 then gmat_out_scale(1) = 1.e4 ; RHVPS volts/volt
endif
if mvloop(0) eq 6 then begin
; RHVPS volt/volt or mirror angle/volt
  for imv=0,1 do begin
    if mvloop(imv+1) ne 0 then begin
      if (mvloop(imv+1) mod 10) lt 3 then gmat_out_scale(imv) = 1.e4 else $
		       gmat_out_scale(imv) = -2.85
    endif
  endfor
  for imv=2,6 do begin
    if mvloop(imv+1) ne 0 then begin
      if (mvloop(imv+1) mod 10) lt 3 then gmat_out_scale(imv+1) = 1.e4 else $
		       gmat_out_scale(imv+1) = -2.85
    endif
  endfor
endif
; ########## Specify the time constants in the feedback (unused) ;!!!!!!!
tauint=0
tauprop=0
taudiff=0
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Prepare the G1 Matrix                              ;
g1mat=fltarr(n_elements(gmat_outputs),n_elements(gmat_inputs),1);
mds$put,'\PCS::LOAD_TAU:D','$',taudiff                          ;
mds$put,'\PCS::LOAD_TAU:I','$',tauint                           ;
mds$put,'\PCS::LOAD_TAU:P','$',tauprop                          ;
; ########## Define the G1 outputs in turn      Integral        ;
;----------------------------------------------------------------

; extract G1 
g1mat=g1
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Put the G1 Matrix, Prepare the G2 Matrix           ;
mat_put,'G1',g1mat,gmat_inputs,gmat_outputs,gmat_out_scale      ;
g2mat=fltarr(n_elements(gmat_outputs),n_elements(gmat_inputs),1);
; ########## Define the G2 outputs in turn      Proportional    ;
;----------------------------------------------------------------
; extract G2
g2mat=g2

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Put the G2 Matrix, Prepare the G3 Matrix           ;
mat_put,'G2',g2mat,gmat_inputs,gmat_outputs,gmat_out_scale      ;
g3mat=fltarr(n_elements(gmat_outputs),n_elements(gmat_inputs),1);
; ########## Define the G3 outputs in turn      Derivative      ;
;----------------------------------------------------------------

; extract G3
g3mat=g3
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Put the G3 Matrix                                  ;
mat_put,'G3',g3mat,gmat_inputs,gmat_outputs,gmat_out_scale      ;
; ########## Define the M-Matrix                                ;
;----------------------------------------------------------------

; we use all inputs, by default

mmat_inputs = [	 gmat_outputs, $
                 'CTLAMP:IPOL_E_' +iii(indgen(8)+1), $
                 'CTLAMP:IPOL_F_' +iii(indgen(8)+1), $
                 'CTLAMP:IPOL_OH_'+iii(indgen(2)+1) ]

mmat_outputs=['E_001','E_002','E_003','E_004','E_005','E_006','E_007','E_008', $
              'F_001','F_002','F_003','F_004','F_005','F_006','F_007','F_008', $
              'OH_001','OH_002','GAS','FAST']

if (mvloop(0) mod 100) eq 5 or (mvloop(0) mod 100) eq 25 then $
	mmat_outputs(0)='RHVPSA'
if (mvloop(0) mod 100) eq 15 then $
	mmat_outputs(0)='RHVPSB'
if (mvloop(0) mod 100) eq 25 then $
	mmat_outputs(1)='RHVPSB'
if mvloop(0) eq 6 then begin
  for imv=0,6 do begin
    if imv lt 2 then icor=0 else icor=1
    if mvloop(imv+1) ne 0 then begin
      if (mvloop(imv+1) mod 10) eq 1 then mmat_outputs(imv+icor)='RHVPSA'
      if (mvloop(imv+1) mod 10) eq 2 then mmat_outputs(imv+icor)='RHVPSB'
      if (mvloop(imv+1) mod 10) eq 3 then mmat_outputs(imv+icor)='MIRROR1'
      if (mvloop(imv+1) mod 10) eq 4 then mmat_outputs(imv+icor)='MIRROR2'
      if (mvloop(imv+1) mod 10) eq 5 then mmat_outputs(imv+icor)='MIRROR3'
      if (mvloop(imv+1) mod 10) eq 6 then mmat_outputs(imv+icor)='MIRROR4'
      if (mvloop(imv+1) mod 10) eq 7 then mmat_outputs(imv+icor)='MIRROR5'
      if (mvloop(imv+1) mod 10) eq 8 then mmat_outputs(imv+icor)='MIRROR6'
    endif
  endfor
endif

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Prepare the M Matrix                               ;
mmat=fltarr(n_elements(mmat_outputs),n_elements(mmat_inputs),1) ;
; mat_out_scale is defined by the hardware, and is in MAT_DO    ;
mmat_out_scale = fltarr(n_elements(mmat_outputs))               ;
; ########## Fill the M Matrix                                  ;
;----------------------------------------------------------------

; extract AML- matrix

; set up the alim mode + set all of the NECESSARY alims on
if (mvloop(0) ne 1 and mvloop(0) ne 11 and mvloop(0) ne 21 and mvloop(0) ne 2 $
	and mvloop(0) ne 12 and (mvloop(0) mod 10) ne 5 ) or iscramb eq 0 $
	then begin
if nfast eq 0 then request_modes=[replicate('B',19),'A']
if nfast ne 0 then request_modes=[replicate('B',19),'B']
endif
;
if (mvloop(0) eq 1 or mvloop(0) eq 11 or mvloop(0) eq 21 $
	or (mvloop(0) mod 10) eq 5) and iscramb ne 0 then begin
if nfast eq 0 then request_modes=['C',replicate('B',18),'A']
if nfast ne 0 then request_modes=['C',replicate('B',18),'B']
endif
;
if (mvloop(0) mod 100) eq 25 and iscramb ne 0 then begin
if nfast eq 0 then request_modes=['C','C',replicate('B',17),'A']
if nfast ne 0 then request_modes=['C','C',replicate('B',17),'B']
endif
;
; Two-component IOH feedback (SC, 06/04/05)
if (mvloop(0) eq 2 or mvloop(0) eq 12) and iscramb ne 0 then begin
if nfast eq 0 then request_modes=['C','C',replicate('B',17),'A']
if nfast ne 0 then request_modes=['C','C',replicate('B',17),'B']
endif
; inova=4 option added (SC, 25/04/05)
if inova eq 4 and iscramb ne 0 then request_modes(2) = 'C'		; 
;
if (mvloop(0) mod 10) eq 5 and mvloop(0) gt 100 and iscramb ne 0 $
	then request_modes(3) = 'C'
;
if mvloop(0) eq 6 and iscramb ne 0 then begin
  for imv=0,6 do begin
    if imv lt 2 then icor=0 else icor=1
    if mvloop(imv+1) ne 0 then request_modes(imv+icor) = 'C'
  endfor
endif
;
if mvloop(0) eq 18 and iscramb ne 0 then begin
request_modes=[replicate('C',8),replicate('B',11),'A']
endif
;  
request_select = [replicate('ON',8),replicate('ON',8),replicate('ON',4)]
;
;-----------automatic level setting-----------------------
;
request_levels = [replicate('50',18),'100','75']
lim80  = 0.75*3850.
lim100 = 0.75*5544.
oh80   = 27000.*0.5
oh100  = 27000.*0.8
for i=0,15 do if max(abs(efcur(*,i))) gt lim80  then request_levels(i)='80'
for i=0,15 do if max(abs(efcur(*,i))) gt lim100 then request_levels(i)='100'
if max(abs(efcur(*,16))) gt oh80  then request_levels(16)='80'
if max(abs(efcur(*,16))) gt oh100 then request_levels(16)='100'
if max(abs(efcur(*,16))) gt oh80  then request_levels(17)='80'
if max(abs(efcur(*,16))) gt oh100 then request_levels(17)='100'
;
;if midplan eq 3 then begin
;  request_levels = ['80','50','100','80',replicate('100',4),     $
;	    '50','50','80',replicate('50',5),replicate('100',3),'50']
;endif
;
;if midplan eq 37 then begin
;  request_levels = ['80','50','80','100','50','100','50','50',  $
;		    replicate('50',8),replicate('100',3),'50']
;endif 
; 
;if midplan eq 1 then begin
;  request_levels = [replicate('80',2),replicate('100',4),replicate('80',2),  $
;		     replicate('50',3),replicate('80',2), replicate('50',3),  $
;                    replicate('100',3),'75']
;endif
;
;if midplan eq 8 then begin
;  request_levels = [replicate('80',3),replicate('100',2),replicate('50',3),  $
;                    replicate('50',3),replicate('100',2),replicate('50',3),  $
;                    replicate('100',3),'0']
;endif
; 
;if midplan eq 9 then begin
;  request_levels = [replicate('50',3),replicate('80',2),replicate('50',3),  $
;                    replicate('50',3),replicate('80',2),replicate('50',3),  $
;                    replicate('100',3),'0']
;endif 

; set up 19 alims only
;;;request_levels = request_levels(0:18)
;;;request_select = request_select(0:18)

 mmat=aml
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ########## Put the M-Matrix to the tree                       ;
mat_put,'M',mmat,mmat_inputs,mmat_outputs,mmat_out_scale        ;
; ########## Load the matrices into hardware units              ;
mat_do,index,pcs_path                                           ;
; ########## Check on the matrix statistics for the model       ;
mat_overflow,-1                                                 ;
;----------------------------------------------------------------

; added 3-way switch set-up (SC, 05/05/09)
switch_status=mds$value('jp_set_sum_sys("'+pcs_path+'")')
if (switch_status ne 1) then begin
  print,'THREE-WAY SWITCH SET-UP FAILED'
  return
endif

; read currents from file if iscramb=0 and inova=5
if iscramb eq 0 and inova eq 5 then begin
 openr,unit,'MAC:[PIRAS]TCV_CURRENT_TRACES.DAT',/get_lun
 readf,unit,nohtf
 noht=floor(nohtf)
 toh=fltarr(noht)
 efcur=fltarr(noht,17)
 readf,unit,toh
 readf,unit,efcur
 free_lun,unit
endif
; ########################################### times for the bit set

if iscramb eq 0 and inova eq 5 then begin
  init_time = [-36.,-30.,-24.]*1.e-3 + min(toh) 
endif else begin
  init_time = [-36.,-30.,-24.]*1.e-3 + min(toft) 
endelse
init_val  = [0.,1000.,0.]

if (pcs_path eq 'rtdtacq') then begin
; adjust the Wavegen masks for real-time
  wave_mask=[0.,0.,0.,1.,replicate(1.,12),replicate(0.,16), $
	     replicate(1.,16),replicate(0.,16), $
	     replicate(1.,64)]
  mds$put,'\load_wave_mask','$',wave_mask
endif
if (pcs_path eq 'rtdtacqden') then begin
; adjust the Wavegen masks for real-time
  wave_mask=[1.,1.,0.,replicate(1.,125)]
  mds$put,'\load_wave_mask','$',wave_mask
endif

; ##############################   Load the first waveforms

; Put all current references to zero to start with
vbit=[0.0,0.0]
if iscramb eq 0 and inova eq 5 then begin
  tbit=[min(toh),max(toh)]
endif else begin
  tbit=[min([toft,toh]),max([toft,toh])]
endelse
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_001',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_002',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_003',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_004',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_005',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_006',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_007',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_008',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_001',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_002',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_003',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_004',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_005',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_006',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_007',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_008',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_OH_I:ALIM_001',vbit,tbit
wave_put,'\PCS::DRAW_FEEDFOR_OH_I:ALIM_002',vbit,tbit


signbit = intarr(18)

; load OH1 and OH2
bit_set = aipoft(13)/abs(aipoft(13))
if iscramb eq 0 and inova eq 5 then begin
  fbte1,toh,efcur(*,16),tbit,vbit
  wave_put,'\PCS::DRAW_FEEDFOR_OH_I:ALIM_001',vbit,tbit
  wave_put,'\PCS::DRAW_FEEDFOR_OH_I:ALIM_002',vbit,tbit
endif else begin
  wave_put,'\PCS::DRAW_FEEDFOR_OH_I:ALIM_001',			$
  	[0.8*init_val*bit_set, 0, -0.8*init_val*bit_set, 0],	$
        [init_time, min(toft), init_time+0.500, toh(n_elements(toh)-1)]
;        [0.8*init_val*bit_set, 0],                           $
;        [init_time, min(toft)]
  wave_put,'\PCS::DRAW_FEEDFOR_OH_I:ALIM_002',			$
	[0.8*init_val*bit_set, 0, -0.8*init_val*bit_set, 0],	$
        [init_time,min(toft), init_time+0.500, toh(n_elements(toh)-1)]
;        [0.8*init_val*bit_set, 0],                           $
;        [init_time, min(toft)]
endelse
;  Initial coil current sign when operating in automatic sign switching mode
;    (SC, 05/09/05)
signbit(16)=init_val(1)*bit_set/abs(init_val(1)*bit_set)
signbit(17)=init_val(1)*bit_set/abs(init_val(1)*bit_set)


; #######################################  get the E,F requirements

; E
;
if (mvloop(0) ne 1 and mvloop(0) ne 11 and mvloop(0) ne 21 and mvloop(0) ne 18 and $
   mvloop(0) ne 2 and mvloop(0) ne 12 and (mvloop(0) mod 10) ne 5) $
	or iscramb eq 0  then begin
fbte1,toh,efcur(*,0),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_001',vbit,tbit
endif
;
if (mvloop(0) ne 2 and mvloop(0) ne 12 and mvloop(0) ne 25) or iscramb eq 0 $
	then begin
fbte1,toh,efcur(*,1),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_002',vbit,tbit
endif
; inova=4 option added (SC, 25/04/05)
if inova ne 4 or iscramb eq 0 then begin
fbte1,toh,efcur(*,2),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_003',vbit,tbit
endif
;
if (mvloop(0) mod 10) ne 5 or mvloop(0) le 100 or iscramb eq 0 then begin
fbte1,toh,efcur(*,3),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_004',vbit,tbit
endif
;
if iscramb ne 0 then begin
if mvloop(0) eq 1 or mvloop(0) eq 11 or mvloop(0) eq 21 or mvloop(0) eq 2 or $
	mvloop(0) eq 12 or (mvloop(0) mod 10) eq 5 then begin
efcur(1,0) = 50.
efcur(2,0) = 100.
efcur(3,0) = 150.
efcur(4,0) = 200.
efcur(5,0) = 150.
efcur(6,0) = 100.
efcur(7,0) = 50.
; set 8th track to zero (SC, 21/08/08)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_001',efcur(*,0),toh)
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_001',efcur(*,0),toh
endif
;
; Two-component IOH feedback (SC, 06/04/05)
; or double-RHVPS ECRH feedback (SC, 11/01/07)
if mvloop(0) eq 2 or mvloop(0) eq 12 or (mvloop(0) mod 100) eq 25 then begin
efcur(1,1) = 50.
efcur(2,1) = 100.
efcur(3,1) = 150.
efcur(4,1) = 200.
efcur(5,1) = 150.
efcur(6,1) = 100.
efcur(7,1) = 50.
; set 8th track to zero (SC, 21/08/08)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_002',efcur(*,1),toh)
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_002',efcur(*,1),toh
endif
; inova=4 option added (SC, 25/04/05)
if inova eq 4 then begin
efcur(1,2) = 50.
efcur(2,2) = 100.
efcur(3,2) = 150.
efcur(4,2) = 200.
efcur(5,2) = 150.
efcur(6,2) = 100.
efcur(7,2) = 50.
; set 8th track to zero (SC, 21/08/08)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_003',efcur(*,2),toh)
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_003',efcur(*,2),toh
endif
;
endif

if mvloop(0) eq 18 and iscramb ne 0 then begin
for i=0,7 do begin
efcur(1,i) = 50.
efcur(2,i) = 100.
efcur(3,i) = 150.
efcur(4,i) = 200.
efcur(5,i) = 150.
efcur(6,i) = 100.
efcur(7,i) = 50.
endfor
endif   
;
if mvloop(0) ne 18 or iscramb eq 0 then begin
fbte1,toh,efcur(*,4),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_005',vbit,tbit
fbte1,toh,efcur(*,5),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_006',vbit,tbit
fbte1,toh,efcur(*,6),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_007',vbit,tbit
fbte1,toh,efcur(*,7),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_008',vbit,tbit
endif
;
if (mvloop(0) eq 6 and iscramb ne 0) then begin
  for imv=0,6 do begin
    if imv lt 2 then icor=0 else icor=1
    if mvloop(imv+1) ne 0 then begin
	efcur(1,imv+icor) = -50.
	efcur(2,imv+icor) = -100.
	efcur(3,imv+icor) = -150.
	efcur(4,imv+icor) = -200.
	efcur(5,imv+icor) = -150.
	efcur(6,imv+icor) = -100.
	efcur(7,imv+icor) = -50.
; set 8th track to zero (SC, 21/08/08)
	status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	   '\PCS::DRAW_FEEDFOR_E_I:ALIM_'+iii(imv+icor+1),$
			efcur(*,imv+icor),toh)
;	wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_'+iii(imv+icor+1),$
;			efcur(*,imv+icor),toh)
    endif
  endfor
endif

if mvloop(0) eq 18 and iscramb ne 0 then begin
; set 8th track to zero (SC, 21/08/08)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_001',efcur(*,0),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_002',efcur(*,1),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_003',efcur(*,2),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_004',efcur(*,3),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_005',efcur(*,4),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_006',efcur(*,5),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_007',efcur(*,6),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_E_I:ALIM_008',efcur(*,7),toh)
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_001',efcur(*,0),toh
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_002',efcur(*,1),toh
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_003',efcur(*,2),toh
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_004',efcur(*,3),toh
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_005',efcur(*,4),toh
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_006',efcur(*,5),toh
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_007',efcur(*,6),toh
;wave_put,'\PCS::DRAW_FEEDFOR_E_I:ALIM_008',efcur(*,7),toh
endif
; F

fbte1,toh,efcur(*,8),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_001',vbit,tbit
fbte1,toh,efcur(*,9),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_002',vbit,tbit
fbte1,toh,efcur(*,10),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_003',vbit,tbit
fbte1,toh,efcur(*,11),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_004',vbit,tbit
fbte1,toh,efcur(*,12),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_005',vbit,tbit
fbte1,toh,efcur(*,13),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_006',vbit,tbit
fbte1,toh,efcur(*,14),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_007',vbit,tbit
fbte1,toh,efcur(*,15),tbit,vbit
wave_put,'\PCS::DRAW_FEEDFOR_F_I:ALIM_008',vbit,tbit

;  Initial coil current sign when operating in automatic sign switching mode
;    (SC, 05/09/05)
for i=0,15 do begin
  indcur=where(abs(efcur(*,i)) gt 100)
  if indcur(0) ne -1 then begin
    signbit(i)=efcur(indcur(0),i)/abs(efcur(indcur(0),i))
  endif else begin
    signbit(i)=1
  endelse
endfor

; ########## Put the ALIM Usage to the tree                     ;
;  Added sign bit argument (SC, 26/09/05)
alim_mode,request_modes,request_levels,request_select,signbit   ;

;  #######################################   now the toroidal field

radius = 0.88
constant = 2*!pi*radius/(4*!pi*1.e-7*16*6)

;bphi= 	abs([0.0, $
;        vcs_rget('SHOTDB::SHOT_DESIGN:' + ['BPHI','BPHI']), $
;        0.0])
;
;top_time=vcs_rget('SHOTDB::SHOT_DESIGN:BPHI_FLAT_START_TIME')
;start_time = top_time -      $
;       bphi(1)/vcs_rget('SHOTDB::SHOT_DESIGN:BPHI_RAMP_RATE')
;stop_time=vcs_rget('SHOTDB::SHOT_DESIGN:BPHI_FLAT_END_TIME')
;end_time = stop_time +       $
;       bphi(1)/vcs_rget('SHOTDB::SHOT_DESIGN:BPHI_RAMP_RATE')
;bphi_time=  [start_time,top_time,stop_time,end_time]

   bphi               = bzeroft*1.02 ; correction for power supply error
   bphi_time          = toft
   bphi_time(1)       = -0.103
   bphi_time(0)       = bphi_time(1) - bphi(1)/1.2
   bphi_time(ntoft-1) = bphi_time(ntoft-2) + bphi(ntoft-2)/1.2

if(not keyword_set(nobphi)) then begin
; set 8th track to zero (SC, 21/08/08)
; do not set 8th track to zero because it leads to overly abrupt changes 
;   (SC, 09/07/09)
;  status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
;  	'\PCS::DRAW_FEEDFOR_TOR_I:ALIM_001',bphi*constant,bphi_time)
; remove filtering (SC, 17/02/11)
  wave_put,'\PCS::DRAW_FEEDFOR_TOR_I:ALIM_001',bphi*constant,bphi_time,'as_is'
endif

; load the FPS

;  ############################################### now the FPS
fps_u        = [0.0, 0.0]
fps_u_time   = [min(toh),max(toh)]

;-----------------square wave for FPS test--------------------
; fps_u_p      = [ 0.0, 100.,100.,-100.,-100.,0.0]
; fps_u_time_p = [.000,.001,.010,.012,.020,.021]
; deltat=.03
; ncycle=30
; fps_u        = [0.0]
; fps_u_time   = [min(toh)]
; for i=0,ncycle-1 do begin & $
;       fps_u=[fps_u, fps_u_p] & $
;  fps_u_time=[fps_u_time, fps_u_time_p+i*deltat] & $
; endfor
;     fps_u=[fps_u, 0.0]
;fps_u_time=[fps_u_time, max(toh)]
;------------------------------------------------------------- 
fps_i        = [0.0, 0.0]
fps_i_time   = [min(toh),max(toh)]
if nfast eq 0 or iscramb eq 0 then fps_udc      = [1.0,1.0]*350.0
if nfast ne 0 then fps_udc      = [1.0,1.0]*270.0
fps_udc_time = [min(toh)-0.1,max(toh)]

wave_put,'\PCS::DRAW_FPS:UDCREF_001', fps_UDC, fps_UDC_time
; set 8th track to zero (SC, 21/08/08)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FPS:UREF_001',   fps_U,   fps_U_time)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FPS:IREF_001',   fps_I,   fps_I_time)
;wave_put,'\PCS::DRAW_FPS:UREF_001',   fps_U,   fps_U_time
;wave_put,'\PCS::DRAW_FPS:IREF_001',   fps_I,   fps_I_time


;  #####################################################   now the GAS

eps = 1.e-3
; --get Ip flattop start/stop from aipoft trace--
ind=where((abs(aipoft(1:*)-aipoft(0:*)) lt 10.0) and $
          (abs(aipoft) gt 0.5*max(abs(aipoft))) )  ; delta Ip lt 10 Amps

; Modified to take into account possibility of no flattop (amagic=0); if
;   no Ip flattop is found, flattop is formally described as a 0-length trace
;   at the Ip peak (SC, 16/01/03)
;nflat=((ntoft-15)/2)+12
;if ind(0) eq -1 then begin   ; no Ip flattop (use nflat)
;   nipflat1=nflat & nipflat2=nflat+1
if ind(0) eq -1 then begin
   dummy = max(aipoft,nipflat1)
   nipflat2 = nipflat1
endif else begin
   nipflat1=min(ind) & nipflat2=max(ind)+1
endelse
nflat = nipflat1
   

; All gas-related lines commented out (SC, 16/01/03)
;xtime=  [vcs_rget('SHOTDB::SHOT_DESIGN:' + ['FILL_ON_TIME','FILL_OFF_TIME',$
;        'BLEED_ON_TIME','PUFF_ON_TIME','PUFF_OFF_TIME']),toft(nflat+1)]
;if (xtime(4) ge xtime(5)-eps) then xtime(4)=xtime(5)-2*eps
;
;xamp = vcs_rget('SHOTDB::SHOT_DESIGN:' + $
;        ['FILL_VOLTS','PEDESTAL_VOLTS','BLEED_VOLTS','PUFF_VOLTS'])
;
;gas_time = [xtime(0)-eps,xtime(0),xtime(1),xtime(1)+eps,xtime(2),xtime(2)+eps,$ 
;        xtime(3),xtime(3)+eps,xtime(4),xtime(4)+eps,xtime(5),xtime(5)+eps]
;gas_amp = [0,xamp(0),xamp(0),xamp(1),xamp(1),xamp(2),xamp(2),xamp(3),xamp(3), $
;        0.,0.,0.]
;
;; adjust the gas timing 
;gas_time = gas_time - xtime(0) + toft(3) - 0.045

;ymif(not keyword_set(nogas)) then begin
 ;wave_put,'\PCS::DRAW_FEEDFOR_GAS:ALIM_001',gas_amp,gas_time
;ym  wave_put,'\PCS::DRAW_FEEDFOR_GAS:ALIM_001',                           $
;ym  [0.000, 4.800, 4.800, 1.800, 1.800,3.000,3.000,3.000,3.000,0.000],  $
;ym  [-0.046,-0.045,-0.030,-0.029,-0.000,0.001,0.300,0.301,0.7500,0.751]
;ymendif	; nogas

; set 8th gas track to zero (SC, 08/08)
gas = mds$value('\PCS::DRAW_FEEDFOR_GAS:ALIM_001');
tgas = mds$value('dim_of(\PCS::DRAW_FEEDFOR_GAS:ALIM_001)');
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_GAS:ALIM_001',gas,tgas)

; ##################################################### TIMING

if iscramb eq 0 and inova eq 5 then begin
 pol_start_time = toft(0)
 pol_stop_time  = max(toft)
endif else begin
 pol_start_time = toh(0)
 pol_stop_time  = max(toh)
endelse

bphi_start_time = bphi_time(0)
bphi_stop_time  = max(bphi_time)

; setup the timing references

;x=vcs_rput('SHOTDB::SHOT_DESIGN:'+['IP','POL','BPHI','ECRH','ECRH_A','ECRH_B','ECRH_C','FLAT','RAMP']+ $
;   '_START_REF',[0.,pol_start_time,bphi_start_time,0.,0.,0.,0.,toft(nipflat1),toft(3)])

;x=vcs_rput('SHOTDB::SHOT_DESIGN:'+['IP','POL','BPHI','ECRH','ECRH_A','ECRH_B','ECRH_C','FLAT','RAMP']+ $
;   '_STOP_REF',[max(toft),pol_stop_time,bphi_stop_time,0.,0.,0.,0.,toft(nipflat2),toft(nflat)])

; JBL Sept 98 remove ecrh
if iscramb eq 0 and inova eq 5 then begin
 x=vcs_rput('SHOTDB::SHOT_DESIGN:'+['IP','POL','BPHI','FLAT','RAMP']+ $
   '_START_REF',[0.,pol_start_time,bphi_start_time,toh(0),toh(n_elements(toh)-1)])

 x=vcs_rput('SHOTDB::SHOT_DESIGN:'+['IP','POL','BPHI','FLAT','RAMP']+ $
   '_STOP_REF',[max(toft),pol_stop_time,bphi_stop_time,toh(0),toh(n_elements(toh)-1)])
endif else begin
 x=vcs_rput('SHOTDB::SHOT_DESIGN:'+['IP','POL','BPHI','FLAT','RAMP']+ $
   '_START_REF',[0.,pol_start_time,bphi_start_time,toft(nipflat1),toft(3)])

 x=vcs_rput('SHOTDB::SHOT_DESIGN:'+['IP','POL','BPHI','FLAT','RAMP']+ $
   '_STOP_REF',[max(toft),pol_stop_time,bphi_stop_time,toft(nipflat2),toft(nflat)])
endelse

; -- delay PID integrator unclamp --
x=vcs_rput('TIMER3_OPERDB::TIMER_019:ABSOLUTE',-5.00)
x=vcs_rput('TIMER3_OPERDB::TIMER_01A:ABSOLUTE',-4.00)
if mvloop(0) eq 6 then begin
  x=vcs_rput('TIMER3_OPERDB::TIMER_01B:ABSOLUTE',ton)
  x=vcs_rput('TIMER3_OPERDB::TIMER_01C:ABSOLUTE',toff)
endif else begin
  x=vcs_rput('TIMER3_OPERDB::TIMER_01B:ABSOLUTE',0.300)
  x=vcs_rput('TIMER3_OPERDB::TIMER_01C:ABSOLUTE',2.500)
endelse

;set voltage feed_forward signals to zero
; and DONT DO VOLTAGE_DO LATER IN SHOT_DESIGN!!!

alim = strarr(18)
for i=1,2 do alim(i-1)='\PCS::DRAW_FEEDFOR_OH_U:ALIM_'+iii(i)
for i=1,8 do alim(i+1)='\PCS::DRAW_FEEDFOR_E_U:ALIM_' +iii(i)
for i=1,8 do alim(i+9)='\PCS::DRAW_FEEDFOR_F_U:ALIM_' +iii(i)
volts=[0.0,0.0]
if iscramb eq 0 and inova eq 5 then begin
  tvolts=[min(toh),max(toh)]
endif else begin
  tvolts=[min([toft,toh]),max([toft,toh])]
endelse
; set 8th track to zero (SC, 21/08/08)
for i=0,17 do begin
  status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3),$4),', $
  	alim(i),volts,tvolts,'as_is')
endfor
;for i=0,17 do wave_put,alim(i),volts,tvolts,'as_is'

;zero all reference signals to A matrix
; Remove 021 if the nogas is defined
for i=1,20 do wave_put,'\PCS::DRAW_REFS:REF_'+iii(i),   $
                            volts,tvolts,'as_is'
;ymif(not keyword_set(nogas) ) then wave_put,'\PCS::DRAW_REFS:REF_021',   $
;ym                            volts,tvolts,'as_is'
for i=22,24 do wave_put,'\PCS::DRAW_REFS:REF_'+iii(i),   $
                            volts,tvolts,'as_is'

;zero all perts
for i=1,24 do wave_put,'\PCS::DRAW_PERTS:PERT_'+iii(i),   $
                            volts,tvolts,'as_is'

;draw  wavegen references
;
if (mvloop(0) ne 1 and mvloop(0) ne 11 and mvloop(0) ne 21 and mvloop(0) ne 18 and $
   mvloop(0) ne 2 and mvloop(0) ne 12 and (mvloop(0) mod 10) ne 5) $
	or iscramb eq 0 then begin
 if iscramb eq 0 and inova eq 5 then begin
  wave_put,'\PCS::DRAW_REFS:REF_001',efcur(*,0),toh
 endif else begin
  wave_put,'\PCS::DRAW_REFS:REF_001',efwave(*,0),toh
 endelse
endif
;
if (mvloop(0) ne 2 and mvloop(0) ne 12) or iscramb eq 0 then begin
 if iscramb eq 0 and inova eq 5 then begin
  wave_put,'\PCS::DRAW_REFS:REF_002',efcur(*,1),toh
 endif else begin
  wave_put,'\PCS::DRAW_REFS:REF_002',efwave(*,1),toh
 endelse
endif
;
if (mvloop(0) eq 1 or mvloop(0) eq 2 or mvloop(0) eq 12 $
	or (mvloop(0) mod 10) eq 5) and iscramb ne 0 then begin
;nn1=where(toh gt ton)
;nn2=nn1(0)
;ioh=efcur(nn2,16)
nnn=n_elements(toh)
iohref=replicate(ioh,nnn) 
wave_put,'\PCS::DRAW_REFS:REF_001',iohref,toh,'as_is'
endif
;
if (mvloop(0) eq 11 or mvloop(0) eq 21) and iscramb ne 0 then begin
nnn=n_elements(toh)
vlref=replicate(relovo,nnn) 
wave_put,'\PCS::DRAW_REFS:REF_001',vlref,toh
endif

;
; Two-component IOH feedback (SC, 06/04/05)
if iscramb ne 0 then begin
if mvloop(0) eq 2 then begin
nnn=n_elements(toh)
ioh1ref=replicate(ioh1,nnn) 
wave_put,'\PCS::DRAW_REFS:REF_002',ioh1ref,toh,'as_is'
endif
if mvloop(0) eq 12 then begin
nnn=n_elements(toh)
ioh1ref=replicate(ioh1,nnn)* $
	mds$value('\PCS::LOAD_FEED_GAINS[1]*\HYBRID::PID_P[1]')
wave_put,'\PCS::DRAW_PERTS:PERT_002',ioh1ref,toh,'as_is'
endif
endif
;
if mvloop(0) ne 18 or iscramb eq 0 then begin
 if iscramb eq 0 and inova eq 5 then begin
  wave_put,'\PCS::DRAW_REFS:REF_003',efcur(*,2),toh
  wave_put,'\PCS::DRAW_REFS:REF_004',efcur(*,3),toh
  wave_put,'\PCS::DRAW_REFS:REF_005',efcur(*,4),toh
  wave_put,'\PCS::DRAW_REFS:REF_006',efcur(*,5),toh
  wave_put,'\PCS::DRAW_REFS:REF_007',efcur(*,6),toh
  wave_put,'\PCS::DRAW_REFS:REF_008',efcur(*,7),toh
 endif else begin
  wave_put,'\PCS::DRAW_REFS:REF_003',efwave(*,2),toh
  wave_put,'\PCS::DRAW_REFS:REF_004',efwave(*,3),toh
  wave_put,'\PCS::DRAW_REFS:REF_005',efwave(*,4),toh
  wave_put,'\PCS::DRAW_REFS:REF_006',efwave(*,5),toh
  wave_put,'\PCS::DRAW_REFS:REF_007',efwave(*,6),toh
  wave_put,'\PCS::DRAW_REFS:REF_008',efwave(*,7),toh
 endelse
endif
;
if mvloop(0) eq 18 and iscramb ne 0 then begin
nnn=n_elements(toh)
zero=replicate(0.0,nnn)
wave_put,'\pcs::draw_refs:ref_001',zero,toh
wave_put,'\pcs::draw_refs:ref_002',zero,toh
wave_put,'\pcs::draw_refs:ref_003',zero,toh
wave_put,'\pcs::draw_refs:ref_004',zero,toh
wave_put,'\pcs::draw_refs:ref_005',zero,toh
wave_put,'\pcs::draw_refs:ref_006',zero,toh
wave_put,'\pcs::draw_refs:ref_007',zero,toh
wave_put,'\pcs::draw_refs:ref_008',zero,toh
endif
;
if (mvloop(0) eq 6 and iscramb ne 0) then begin
  volts=[0.0,0.0]
  tvolts=[min([toft,toh]),max([toft,toh])]
  wave_put,'\PCS::DRAW_REFS:REF_001',volts,tvolts,'as_is'
  for imv=1,6 do begin
    if imv lt 2 then icor=0 else icor=1
    if mvloop(imv+1) ne 0 then wave_put,'\PCS::DRAW_REFS:REF_'+$
			iii(imv+icor+1),volts,tvolts,'as_is'
  endfor
endif
;
if iscramb eq 0 and inova eq 5 then begin
 wave_put,'\PCS::DRAW_REFS:REF_009',efcur(*,8),toh
 wave_put,'\PCS::DRAW_REFS:REF_010',efcur(*,9),toh
 wave_put,'\PCS::DRAW_REFS:REF_011',efcur(*,10),toh
 wave_put,'\PCS::DRAW_REFS:REF_020',efcur(*,11),toh
 wave_put,'\PCS::DRAW_REFS:REF_019',efcur(*,12),toh
 wave_put,'\PCS::DRAW_REFS:REF_014',efcur(*,13),toh
 wave_put,'\PCS::DRAW_REFS:REF_015',efcur(*,14),toh
 wave_put,'\PCS::DRAW_REFS:REF_016',efcur(*,15),toh
endif else begin
 wave_put,'\PCS::DRAW_REFS:REF_009',efwave(*,8),toh
 wave_put,'\PCS::DRAW_REFS:REF_010',efwave(*,9),toh
 wave_put,'\PCS::DRAW_REFS:REF_011',efwave(*,10),toh
 wave_put,'\PCS::DRAW_REFS:REF_020',efwave(*,11),toh
 wave_put,'\PCS::DRAW_REFS:REF_019',efwave(*,12),toh
 wave_put,'\PCS::DRAW_REFS:REF_014',efwave(*,13),toh
 wave_put,'\PCS::DRAW_REFS:REF_015',efwave(*,14),toh
 wave_put,'\PCS::DRAW_REFS:REF_016',efwave(*,15),toh
endelse
if iscramb eq 0 then begin
 wave_put,'\PCS::DRAW_REFS:REF_018',efcur(*,16),toh 
endif else begin
 wave_put,'\PCS::DRAW_REFS:REF_018',efwave(*,17),toh 
endelse

if midplan ne 8 and iscramb ne 0 then begin
 wave_put,'\PCS::DRAW_REFS:REF_012',zeref,toh
 wave_put,'\PCS::DRAW_REFS:REF_024',efwave(*,23),toh   
 wave_put,'\PCS::DRAW_REFS:REF_023',efwave(*,22),toh
; Make kappa reference always available (SC, 11/01/07)
; if iscramb eq 12 or iscramb eq 15 or iscramb eq 16 or iscramb eq 19 $
;	or iscramb eq 25 or iscramb eq 26 or iscramb eq 36 $
;	or mvloop(0) eq 6 then $
	wave_put,'\PCS::DRAW_REFS:REF_022',cayref,toh
endif

;ymif(not keyword_set(nogas)) then begin
;ym  wave_put,'\PCS::DRAW_REFS:REF_021',                   $
;ym          [0.,0.,3.5,4.5,4.5,0.,0.],[-.28,0.,.2,.4,0.75,1.8,2.1]
;         [0.,0.,3.5,3.5,3.5,0.,0.],[-.28,0.,.2,.4,0.75,1.8,2.1]
;         [0.,0.,2.5,2.5,2.5,0.,0.],[-.28,0.,.1,.4,0.75,1.8,2.1]
;ym  if nfast ne 0 then wave_put,'\PCS::DRAW_REFS:REF_021',aipoft*0.85e-5,toft
;ymendif	; nogas

wave_put,'\PCS::DRAW_REFS:REF_017',ohcur,toft
wave_put,'\PCS::DRAW_REFS:REF_013',aipoft,toft

if (mvloop(0) mod 10) eq 5 and mvloop(0) gt 100 then $
	wave_put,'\PCS::DRAW_REFS:REF_004',aipoft,toft

;   if midplan eq 8 then begin
;   wave_put,'\PCS::DRAW_REFS:REF_013',aipoft*0.5,toft
;   endif

if midplan eq 8 and iscramb ne 0 then begin
 wave_put,'\PCS::DRAW_REFS:REF_012',efwave(*,19),toh
 wave_put,'\PCS::DRAW_REFS:REF_022',efwave(*,21),toh
 wave_put,'\PCS::DRAW_REFS:REF_023',efwave(*,22),toh
 wave_put,'\PCS::DRAW_REFS:REF_018',efwave(*,17),toh
endif

if midplan eq 9 and iscramb ne 0 then begin 
 wave_put,'\PCS::DRAW_REFS:REF_022',efwave(*,21),toh
 wave_put,'\PCS::DRAW_REFS:REF_023',efwave(*,22),toh 
endif 

toh=toh2

; set 8th track to zero (SC, 21/08/08)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\PCS::DRAW_FEEDFOR_OH_U:ALIM_001',efvolt(*,16)+20.,toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_oh_u:alim_002',efvolt(*,17),toh)

status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_e_u:alim_001',efvolt(*,0),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_e_u:alim_002',efvolt(*,1),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_e_u:alim_003',efvolt(*,2),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_e_u:alim_004',efvolt(*,3),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_e_u:alim_005',efvolt(*,4),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_e_u:alim_006',efvolt(*,5),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_e_u:alim_007',efvolt(*,6),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_e_u:alim_008',efvolt(*,7),toh)

status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_f_u:alim_001',efvolt(*,8),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_f_u:alim_002',efvolt(*,9),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_f_u:alim_003',efvolt(*,10),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_f_u:alim_004',efvolt(*,11),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_f_u:alim_005',efvolt(*,12),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_f_u:alim_006',efvolt(*,13),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_f_u:alim_007',efvolt(*,14),toh)
status=mds$value('WAVE_PUT($1,[REPLICATE(SET_RANGE(,1,F_FLOAT($2)),1,7),ZERO(SHAPE($2),F_FLOAT(0.0))],F_FLOAT($3))', $
	'\pcs::draw_feedfor_f_u:alim_008',efvolt(*,15),toh)

;wave_put,'\PCS::DRAW_FEEDFOR_OH_U:ALIM_001',efvolt(*,16)+20.,toh
;wave_put,'\pcs::draw_feedfor_oh_u:alim_002',efvolt(*,17),toh

;wave_put,'\pcs::draw_feedfor_e_u:alim_001',efvolt(*,0),toh
;wave_put,'\pcs::draw_feedfor_e_u:alim_002',efvolt(*,1),toh
;wave_put,'\pcs::draw_feedfor_e_u:alim_003',efvolt(*,2),toh
;wave_put,'\pcs::draw_feedfor_e_u:alim_004',efvolt(*,3),toh
;wave_put,'\pcs::draw_feedfor_e_u:alim_005',efvolt(*,4),toh
;wave_put,'\pcs::draw_feedfor_e_u:alim_006',efvolt(*,5),toh
;wave_put,'\pcs::draw_feedfor_e_u:alim_007',efvolt(*,6),toh
;wave_put,'\pcs::draw_feedfor_e_u:alim_008',efvolt(*,7),toh

;wave_put,'\pcs::draw_feedfor_f_u:alim_001',efvolt(*,8),toh
;wave_put,'\pcs::draw_feedfor_f_u:alim_002',efvolt(*,9),toh
;wave_put,'\pcs::draw_feedfor_f_u:alim_003',efvolt(*,10),toh
;wave_put,'\pcs::draw_feedfor_f_u:alim_004',efvolt(*,11),toh
;wave_put,'\pcs::draw_feedfor_f_u:alim_005',efvolt(*,12),toh
;wave_put,'\pcs::draw_feedfor_f_u:alim_006',efvolt(*,13),toh
;wave_put,'\pcs::draw_feedfor_f_u:alim_007',efvolt(*,14),toh
;wave_put,'\pcs::draw_feedfor_f_u:alim_008',efvolt(*,15),toh
;
liuqe_params
;
end
