pro add_rog,mat_inputs,mat_outputs,mat

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : ADD_ROG.pro

; PURPOSE :
; Takes a User-defined A-Matrix, and looks for an output name *IPLA*
; If it finds this, it fills the JMM definition of Iplasma

; ARGUMENTS :
; mat_inputs	Vector of A-Matrix input names
; mat_outputs	Vector of A-Matrix output names
; mat		A-Matrix

; RESTRICTIONS :

; UPDATED/REASONS :
; 	Jo Lister	May 92	Original
; 	Jo Lister	Feb 94	Finalised
;	Jo Lister	Mar 94	Revectorised
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

mat_inputs = strupcase(mat_inputs)
mat_outputs = strupcase(mat_outputs)

; check if there are any IPLA outputs to be filled
count = fix(0)
; Changed for compatibility w. FBTE18 (SC, 13/08/09)
;out_index = where(strpos(mat_outputs,'IPLA',0) ne -1,count)
out_index = where(strpos(mat_outputs,'IPA',0) ne -1,count)
if (count eq 0) then return
print,'ADD ROG to ',out_index

; ##### INCREASE THE DIMENSIONS of MAT if necessary to include more inputs
prein=n_elements(mat_inputs)
nmat = n_elements(mat(0,0,*))

; we ned all of the BPOL signals
integs = 'CTLINT:BPOL_AVG_'+iii(indgen(38)+1)
count = fix(0)
extra = 0
for i=1,38 do begin
  integ = integs(i-1)
  in_index = where(mat_inputs eq integ , count)
  if(count eq 0) then begin
    extra = extra + 1
    mat_inputs = [mat_inputs,integ]
  endif
endfor

; get the full backoff coil list E F and OH
back_list=strupcase(mds$value('\magnetics::ipol:dim'))
back_list = back_list(0:17)

; check that all of these IPOLs are there
for i=0,n_elements(back_list)-1 do begin
  in_index = where(mat_inputs eq 'CTLAMP:IPOL_'+back_list(i),count)
  if(count eq 0) then begin
    extra = extra + 1
    mat_inputs = [mat_inputs,'CTLAMP:IPOL_'+back_list(I)]
  endif
endfor

; pad out the A-MAT if necessary
if(extra gt 0) then begin mat = [[mat], $
	[fltarr(n_elements(mat_outputs),extra,nmat)]] &$
	print,' PRE/POST inputs are :',prein,n_elements(mat(0,*,0))&end

; ########## FIRST DO THE BPOL contributions to the IP

lengths = mds$value('\magnetics::iplasma:trapeze:coeff') / (!pi*4.e-7)

in_index=intarr(38)
for i=0,37 do in_index(i) = where(mat_inputs eq integs(i))
for i=0,n_elements(out_index)-1 do  $
	for j=0,nmat-1 do mat(out_index(i),in_index,j) = lengths
; temporary for snowflakes because they bugger probe #22: uncomment 
;	(SC, 21/4/10)
;for i=0,n_elements(out_index)-1 do  $
;	for j=0,nmat-1 do mat(out_index(i),in_index(21),j) = 0


; ##### Now do the IPOL BACKOFF contributions

back_contrib = mds$value('\magnetics::iplasma:trapeze:crosstalk')

in_index = intarr(n_elements(back_list))
for i=0,n_elements(back_list)-1  do in_index(i) =  $
	where(mat_inputs eq 'CTLAMP:IPOL_'+back_list(i))

; we add minus the crosstalk to the current measurement
for i=0,n_elements(out_index)-1 do  $
	for j=0,nmat-1 do mat(out_index(i),in_index,j) = - back_contrib

end
