pro add_backoffs,mat_inputs,mat_outputs,mat

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : ADD_BACKOFFS.PRO

; PURPOSE :
; This routine takes an A-Matrix which is in terms of pure B and PSI
; It corrects the B and PSI for the Toroidal Field pickup

; ARGUMENTS :
; mat_inputs	Vector of A-Matrix input names
; mat_outputs	Vector of A-Matrix output names
; mat		A-Matrix

; RESTRICTIONS :

; UPDATED/REASON :
; 	Jo Lister 	Aug 93		Original
; 	Jo Lister	Feb 94		Finalised
;	Jo Lister	Mar 94		Re-vectorised
;	Jo Lister	Sept 98		Cancel old and forget the dzdt
;	Jo Lister	Nov 98		Delete the extraneous IPHI inputs
;-
; Controlled by :       Jo
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

print,'ADD BPHI BACKOFFS ',!stime

mat_inputs 	= strupcase(mat_inputs)+'           '
mat_outputs 	= strupcase(mat_outputs)
nmat 	= n_elements(mat(0,0,*))
matout	= mat

; ##### INCREASE THE DIMENSIONS of MAT_INPUTS if necessary
bphi_input = 'CTLAMP:IPHI_001'
count 	= fix(0)
bphi_index = where(strtrim(mat_inputs) eq bphi_input , count)
if(count eq 0) then begin
   mat_inputs = [mat_inputs,bphi_input]
   print,'PRE/POST inputs are increased for BPHI'
   matout = [[matout],[fltarr(n_elements(mat_outputs),1)]]  
endif else begin
  if(count gt 1) then begin
    in_index = where(strtrim(mat_inputs) ne bphi_input , count)
    mat_inputs = [mat_inputs(in_index),bphi_input]
    matout	= mat(*,[in_index,bphi_index(0)],*)
  endif
endelse

; locate the position of the BPHI input
bphi_index = where(strtrim(mat_inputs) eq bphi_input)

; create the correction matrix
correction 	= fltarr(n_elements(mat_inputs))

count	= 0
bpol_index = where (strmid(mat_inputs,0,12) eq 'CTLINT:BPOL_',count)
if(count gt 0) then begin
  index = strmid(mat_inputs(bpol_index),16,3)
  search = '['+arr2str(index)+']'
  correction(bpol_index) =  $
	(mds$value('\magnetics::bpol_003:crosstalk'+search) + $
	 mds$value('\magnetics::bpol_011:crosstalk'+search) )/ 2.0
endif

rvloop_index = where (strmid(mat_inputs,0,12) eq 'CTLINT:RVLOO',count)
if(count gt 0) then begin
  index = strmid(mat_inputs(rvloop_index),14,3)
  search = '['+arr2str(index)+']'
  correction(rvloop_index) = mds$value('\magnetics::rflux:crosstalk'+search) 
endif

vloop_index = where (strmid(mat_inputs,0,12) eq 'CTLINT:VLOOP',count)
if(count gt 0) then begin
  index = strmid(mat_inputs(vloop_index),13,3)
  search = '['+arr2str(index)+']'
  correction(vloop_index) = mds$value('\magnetics::flux:crosstalk'+search) 
endif

; Make the correction matrix 
corrector = fltarr(n_elements(matout(0,*)),n_elements(mat_inputs))
for i=0,n_elements(matout(0,*,0))-1 do corrector(i,i)=1.0

; we add minus the correction vector 
print,size(correction)
print,size(corrector(*,bphi_index))
corrector(*,bphi_index) = - correction

; apply the correction
mat2 	= [[[matout(*,*,0) # corrector]]]
if(nmat gt 1) then for j=1,nmat-1 do mat2 = [[[mat2]],[[matout(*,*,j) # corrector]]]

; which is the FH dz/dt output in the final matrix?
count	= 0
forget	= where(strpos(mat_outputs, 'DZDT') ne -1,count)
if(count gt 0) then begin
  print,'FH Cancel the row ',forget+1
  matout(forget(0),bphi_index(0),*) = 0.
endif

; replace with the new version
mat 	= mat2

end
