function g = gas_trace_bd(s)
% GAS_TRACE_BD Converts lists of parameters into a gas trace
%
% See also: gas_params_bd

g.t = NaN(9,1);
g.x = NaN(9,1);

dt = 1e-3;

% Start of trace
g.t(1)   = -3.97;
g.x(1)   = 0;
% Valve unsticking
g.t(2:5) = cumsum([s.t_valve,dt,s.w_valve,dt]);
g.x(2:5) = [0 s.h_valve*[1 1] 0];
% Gas prefill
g.t(6:8) = [cumsum([-s.w_prefill,dt]),0];
g.x(6:8) = [0 s.h_prefill*[1 1]];
% Gas postfill
if ~isnan(s.t_postfill) && s.t_postfill <= 0.01
  g.t(9) = s.t_postfill;
  g.x(9) = s.h_postfill;
end

mask = ~isnan(g.t) & ~isnan(g.x);
g.t = g.t(mask);
g.x = g.x(mask);
end