function enmac(mode,varargin)

% [NOTE 30.06.2017, amerle; inherited from wgame.m]
% Introduced persistent ZCLEANUP object to try and recover the state of
% enmac when the persistent variables are cleared. This happens for example
% when the .m file is modified.
% Previous behavior would in most cases result in having two enmac windows
% open.
% It is approximately working. Approximately because when cleared, the
% action is triggered twice, I imagine this is linked with the
% implementation of the clear function and we are just lucky that it does
% not enter an infinite recursion loop.
% Another option is to trigger the quit action with the old figure handle
% to force it to be closed.

% Editor for Non-Magnetic ACtuators

global MGnmac MGvarst
persistent HFIG PAN KPAN FULL ZCLEANUP

% Check state of persistent variables unless we are quitting.
if (~isscalar(HFIG) || ~ishghandle(HFIG) || isempty(PAN) || isempty(KPAN) || isempty(FULL) ...
        || isempty(ZCLEANUP)) && ~(nargin > 0 && strcmpi(mode,'quit'))
 
 % Attempt recovery after variables were cleared
 if nargin > 1 && strcmpi(mode,'recover')
  hfig = varargin{1};
  if isscalar(hfig) && ishghandle(hfig)
   % Recovery successful
   HFIG = hfig;
   % Recovery object will be recreated
   ZCLEANUP = onCleanup(@() enmac('recover',HFIG));
  else
   % Recovery unsuccessful -> Re-init all variables and return
   clear enmac
   return
  end
 end
 
 % Check state of PAN
 shc = 0;
 if mdsdata('getdbi("NUMBER_OPENED")')
  shc = mdsdata('$SHOT');
 end
 if isempty(PAN) 
  mdsopen('pcs',-1);
  PAN = {'Density/Gas'       {'density','gas_ref/1'}                         {'Fringes','\PCS::CALIB_GAS_001:NAME'};
         'Density/Piezo REF' {'density','gas_ref/1','gas_ref/2','gas_ref/3'} {'Fringes','\PCS::CALIB_GAS_001:NAME','\PCS::CALIB_GAS_002:NAME','\PCS::CALIB_GAS_003:NAME'};
         'GAS REF'           {'gas_ref'}                                     {'\PCS::GASCS_CALIBRATION:VALVE_*:NAME'};
         'GAS FF'            {'gas_ff'}                                      {'\PCS::GASCS_CALIBRATION:VALVE_*:NAME'};
         'GAS REF|FF'        {'gas_ff','gas_ref'}                            {'\PCS::GASCS_CALIBRATION:VALVE_*:NAME','\PCS::GASCS_CALIBRATION:VALVE_*:NAME'};
         'FRINGES'           {'density'}                                     {'Fringes'};
         'NBI'               {'nbi_power'}                                   {'Power','Power'}};
  PAN = struct('label',PAN(:,1),'field',PAN(:,2),'legend',PAN(:,3));
  for k = 1:length(PAN)
   l = 0;
   for j = 1:length(PAN(k).field)
    MGfield = PAN(k).field{j};
    fieldsep = strfind(MGfield,'/');indf = 0;
    if ~isempty(fieldsep),indf = str2num(MGfield(fieldsep+1:end));MGfield = MGfield(1:fieldsep-1);end
    inds = find(strcmp({MGnmac.label},MGfield));
    MGnodes = getfield(MGnmac,{inds},'node');
    if indf,
     MGnodes = MGnodes(indf);
     PAN(k).inds(l+1:l+length(MGnodes),:) = [inds*ones(length(MGnodes),1) indf];
    else
     PAN(k).inds(l+1:l+length(MGnodes),:) = [inds*ones(length(MGnodes),1) [1:length(MGnodes)]'];
    end
    PAN(k).node(l+1:l+length(MGnodes)) = MGnodes;
    l = length(PAN(k).node);
   end
  end
  for k = 1:length(PAN)
   if contains(PAN(k).legend{1},'*')
    PAN(k).legend = deblank(mdsdata('GETNCI($1,"PATH")',PAN(k).legend));
   end
   if ischar(PAN(k).legend), PAN(k).legend = {PAN(k).legend}; end
   for l = 1:length(PAN(k).legend)
    if strcmp(PAN(k).legend{l}(1),'\')
     PAN(k).legend{l} = mdsdata('if_error(execute($1),$2)',PAN(k).legend{l},'');
    end
    PAN(k).legend{l} = [PAN(k).legend{l},replace([' (',deblank(mdsdata('if_error(execute($1),$2)', ...
              ['units_of(',replace(upper(PAN(k).node{l}),':VAL',''),')'],' ')),')'],' ()','')];
   end
   PAN(k).name = cell(length(PAN(k).node),1);
   PAN(k).lim  = NaN(2,length(PAN(k).node));
   for l = 1:length(PAN(k).node)
    if contains(PAN(k).node{l},'REF_021','IgnoreCase',true)
     PAN(k).name{l} = 'Density';
    elseif contains(PAN(k).node{l},{'GAS_FEEDFOR','GAS_REF'},'IgnoreCase',true)
     PAN(k).name{l} = PAN(k).node{l}(regexp(PAN(k).node{l},'\d\d')+[1:2]);
    elseif contains(PAN(k).node{l},'NBI','IgnoreCase',true)
     PAN(k).name{l} = ['NBI ',PAN(k).node{l}(regexp(PAN(k).node{l},'\d'))];
    else
     PAN(k).name{l} = 'No Name';
    end
   end
  end
  if shc,mdsopen('pcs',shc);end
 end

 % Check state of HFIG
 if ~isscalar(HFIG) || ~ishghandle(HFIG)
  HFIG = figure(...
    'menubar','none','numbertitle','off','position',[910 65 950 865],...
    'DefaultAxesColor',0*[1 1 1],'DefaultAxesXColor',1*[1 1 1],'DefaultAxesYColor',1*[1 1 1],...
    'Color',0.5*[1 1 1]);
  % For versions 8.4.0 and later, set the grid color as well (for
  % earlier versions the parameter did not exist and the grid had
  % the same color as the X and Y axes
  if ~verLessThan('matlab','8.4.0'),set(HFIG,'DefaultAxesGridColor',1*[1 1 1]);end
  %
  set(HFIG,'windowbuttondownfcn','enmac btndwn','windowbuttonupfcn','enmac btnup',...
    'resizefcn','enmac resize','deletefcn',{@(~,~) enmac('quit',HFIG,'delete')});
  h = uimenu('label','Shot');
  uimenu(h,'label','Load',            'accelerator','L','callback','enmac pan')
  uimenu(h,'label','Apply',           'accelerator','S','callback','enmac apply')
  uimenu(h,'label','View full traces','accelerator','F','callback','enmac full','separator','on','Checked','off')
  uimenu(h,'label','Close',           'accelerator','Q','callback','enmac quit','separator','on')
  h = uimenu('label','Panel');
  for k = 1:length(PAN)
   tmp = k; if k > 9, tmp = []; end
   uimenu(h,'label',PAN(k).label,'accelerator',int2str(tmp),'tag','pan','UserData',k,'callback',['enmac pan ' int2str(k)])
  end
  
  h = uimenu('label','Knot');
  uimenu(h,'label','Select - Mouse Left')
  uimenu(h,'label','Move - Mouse Middle')
  uimenu(h,'label','New - Mouse Right')
  uimenu(h,'label','Previous Knot',                'accelerator','G','callback','enmac selknot -1','separator','on')
  uimenu(h,'label','Next Knot',                    'accelerator','H','callback','enmac selknot  1')
  uimenu(h,'label','Previous Wave',                'accelerator','T','callback','enmac selwave -1')
  uimenu(h,'label','Next Wave',                    'accelerator','B','callback','enmac selwave  1')
  uimenu(h,'label','Delete Knot - Select Previous','accelerator','Z','callback','enmac del     -1','separator','on')
  uimenu(h,'label','Delete Knot - Select Next',    'accelerator','X','callback','enmac del      0')
  uimenu(h,'label','Lock Horizontal',              'accelerator','Y','callback','enmac onoff','tag','hlock','separator','on')
  uimenu(h,'label','Lock Vertical',                'accelerator','U','callback','enmac onoff','tag','vlock')
  
  uicontrol('style','text','tag','txtw')
  uicontrol('style','edit','tag','txtx','callback','enmac txt')
  uicontrol('style','edit','tag','txty','callback','enmac txt')
  uicontrol('style','pushbutton','callback','enmac loadsel','string','loadsel','tag','loadsel')
  uicontrol('style','edit','tag','origin')
  
  % Persistent cleanup object. Clearing enmac will clear persistent variable
  % and trigger the cleanup action.
  % The cleanup object will try to recover the original figure when possible.
  ZCLEANUP = onCleanup(@() enmac('recover',HFIG));
 end
 
 % Check state of FULL
 if isempty(FULL)
  FULL = false;
  set(findobj(HFIG,'label','View full traces'),'Checked','off');
 end
 
 % Check state of KPAN
 if isscalar(KPAN)
  enmac('pan',int2str(KPAN))
 else
  KPAN=1;
  enmac pan 1
 end
 
 set(HFIG,'Handlevisibility','off');
end

if (isscalar(HFIG) && ishghandle(HFIG))
 figvis = get(HFIG,'Handlevisibility');
 set(HFIG,'Handlevisibility','on');
 ax = get(HFIG,'CurrentAxes');
end

if nargin
 switch mode

  case 'pan'
   if nargin == 1, kpan = KPAN; else, kpan = str2double(varargin{1}); end
   if isempty(kpan), return, end
   if ~strcmp(get(findobj(HFIG,'tag','nbi_power_energy'),'string'),'Plot power') && ...
      ~isempty([findobj(HFIG,'type','line','tag','wave','color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4]); ...
                findobj(HFIG,'type','uicontrol','backgroundcolor',[1 0.4 0.4])])
    switch questdlg('Apply mods on this Panel?','enmac')
     case 'Yes', enmac apply
     case 'Cancel', return
    end
   end 
   KPAN = kpan;
   set(HFIG,'name',['ENMAC - ' PAN(kpan).label])
   delete(findobj(HFIG,'type','axes'))
   delete(findobj(HFIG,'tag','fftitle'))
   delete(findobj(HFIG,'tag','gas_enable'))
   delete(findobj(HFIG,'tag','gas_enable_all'))
   delete(findobj(HFIG,'tag','gas_disable_all'))
   delete(findobj(HFIG,'tag','convert'))
   delete(findobj(HFIG,'tag','ctrl_convert'))
   delete(findobj(HFIG,'tag','toggle'))
   delete(findobj(HFIG,'tag','unstick'))
   delete(findobj(HFIG,'tag','zero_traces'))
   delete(findobj(HFIG,'tag','gas_ctrl'))
   delete(findobj(HFIG,'tag','ctrl'))
   delete(findobj(HFIG,'tag','gas_type'))
   delete(findobj(HFIG,'tag','gas'))
   delete(findobj(HFIG,'tag','gas_drive'))
   delete(findobj(HFIG,'tag','drive'))
   delete(findobj(HFIG,'tag','gas_analog_act'))
   delete(findobj(HFIG,'tag','analog'))
   delete(findobj(HFIG,'tag','gas_analog_gain'))
   delete(findobj(HFIG,'tag','gain'))
   delete(findobj(HFIG,'tag','nbi_enable'))
   delete(findobj(HFIG,'tag','nbi_enable_all'))
   delete(findobj(HFIG,'tag','nbi_disable_all'))
   delete(findobj(HFIG,'tag','nbi_drive'))
   delete(findobj(HFIG,'tag','nbi_ff'))
   delete(findobj(HFIG,'tag','nbi_rtc_on'))
   delete(findobj(HFIG,'tag','nbi_rtc_t_on'))
   delete(findobj(HFIG,'tag','nbi_rtc_off'))
   delete(findobj(HFIG,'tag','nbi_rtc_t_off'))
   delete(findobj(HFIG,'tag','nbi_species'))
   delete(findobj(HFIG,'tag','nbi_gas'))
   delete(findobj(HFIG,'tag','nbi_power_energy'))
   ly = length(PAN(kpan).node);
   tmp = get(HFIG,'position');
   menutitg = 0;
   menutitg2 = 0;
   menutitn = 0;
   for l = 1:ly
    shc = 0;
    if mdsdata('getdbi("NUMBER_OPENED")')
     shc = mdsdata('$SHOT');
    end
    mdsopen('pcs',-1);
    if contains(PAN(kpan).node{l},'nbi','IgnoreCase',true)
     if nargin<=2 || ~varargin{2}
      x = [0,mdsdata('IF_ERROR(GETNCI($1,"RECORD"),$ROPRAND)',['\PCS::LIM_NBI_',PAN(kpan).node{l}(regexp(PAN(kpan).node{l},'\d')),':PMAX'])];
     else
      x = [-Inf;Inf];
     end
% Temporary blocks until old shots are filled retroactively with new nodes (from prepared filling scripts): delimited by TEMP FROM and TEMP TO
% TEMP FROM
     for iin=1:2
      dt(iin) = mdsdata(['\LIM_NBI_',int2str(iin),':DT']);
     end
% TEMP TO
    elseif contains(PAN(kpan).node{l},'gas','IgnoreCase',true)
     x = mdsdata('IF_ERROR(GETNCI($1,"RECORD"),$ROPRAND)',['\PCS::LIM_GAS_',PAN(kpan).node{l}(regexp(PAN(kpan).node{l},'\d')),':YMAX']);
     if contains(PAN(kpan).node{l},'ref','IgnoreCase',true)
      ctrl_mode = MGnmac(strcmp({MGnmac.label},'gas_ctrl')).data{PAN(kpan).inds(l,2)};
     else
      ctrl_mode = 0;
     end
     if ctrl_mode >= 0
      x = [0,x(ctrl_mode+1)];
     else
      x = [0,x(1)];
     end
    elseif contains(PAN(kpan).node{l},'ref_021','IgnoreCase',true)
     x = mdsdata('IF_ERROR(GETNCI($1,"RECORD"),[$ROPRAND,$ROPRAND])',[PAN(kpan).node{l} ':LIMITS']);
    else
     x = [-Inf;Inf];
    end
    k = find(isnan(x)); x(k) = Inf * (2*k-3);
    PAN(kpan).lim(:,l) = x;
    y = MGnmac(PAN(kpan).inds(l,1)).data{PAN(kpan).inds(l,2)};
    if MGnmac(PAN(kpan).inds(l,1)).stdwave
     x = MGnmac(PAN(kpan).inds(l,1)).time{PAN(kpan).inds(l,2)};
    else
     x = MGnmac(strcmp({MGnmac.label},[MGnmac(PAN(kpan).inds(l,1)).label,'_t'])).data{PAN(kpan).inds(l,2)};
    end
    if contains(PAN(kpan).node{l},'nbi','IgnoreCase',true)
     if nargin>2 && varargin{2}
      q1 = mdsdata('vdbget($)',['tcv_nbhdb::nb',replace(PAN(kpan).name{l}(end),'1','i'),':ion_mass']);
      qi = {'H2','D2'};
      conv2 = mdsdata('if_error(execute($1),$2)', ...
                      ['_c=\PCS::energy_nbi_',PAN(kpan).name{l}(end),'_',qi{q1}],NaN);
      conv1 = mdsdata('if_error(execute($1),$2)','dim_of(_c)',NaN);
      try
       y = interp1(conv1,conv2,y,'spline',0);
      catch
       y = zeros(size(y));
      end
      PAN(kpan).node{l} = replace(upper(PAN(kpan).node{l}),'POWER','ENERGY');
      PAN(kpan).legend{l} =  'Energy';
     else
      PAN(kpan).legend{l} =  'Power';
     end
     PAN(kpan).legend{l} = [PAN(kpan).legend{l},replace([' (',deblank(mdsdata('if_error(execute($1),$2)', ...
              ['units_of(',replace(upper(PAN(kpan).node{l}),':VAL',''),')'],' ')),')'],' ()','')];
    end
    if contains(PAN(kpan).node{l},'gas_ref','IgnoreCase',true)
     indl = str2num(PAN(kpan).name{l});
     inds = find(strcmp({MGnmac.label},'gas_ctrl'));
     n = char(regexp(PAN(kpan).node{l},'\d\d\d','match'));
     PAN(kpan).legend{l} = [regexprep(PAN(kpan).legend{l},'\s\(\S*\)',''), ...
                           replace([' (',deblank( ...
         mdsdata('if_error(execute($1),$2)', ...
                 [replace(lower(PAN(kpan).node{l}),':val',''),':units[',int2str(MGnmac(inds).data{indl}),']'],' ') ...
                                         ),')'],' ()','')];
    end
    deltax = 0.001;
    if contains(PAN(kpan).node{l},'gas','IgnoreCase',true) && isempty(regexp(PAN(kpan).node{l},'0[1-3]')),deltax = 0.0005;end
    if contains(PAN(kpan).node{l},'nbi','IgnoreCase',true),deltax = 0.0001;end
    ax=axes('UserData',struct('name',PAN(kpan).name{l},'node',PAN(kpan).node{l},'sel',[],'lim',[-8 8 PAN(kpan).lim(:,l)'],'delta',[deltax NaN]),...
      'xticklabel','','box','on','xgrid','on','ygrid','on','Parent',HFIG);
    col = [.5 .5 1];
    line(x,y,'linestyle','-','marker','s','color',col,'markerfacecolor',col,'UserData',PAN(kpan).node{l},'tag','wave','Parent',ax);
    ylabel(ax,PAN(kpan).name{l},'interpreter','none','fontsize',7);
    text(0.05,0.95,PAN(kpan).legend{l}, ...
         'units','normalized','color','g','horizontalalignment','left','verticalalignment','top','Parent',ax);
    PAN(kpan).node{l} = replace(upper(PAN(kpan).node{l}),'ENERGY','POWER');
    gases = mdsdata('\PCS::GAS_LIST[0:11]');
    if shc,mdsopen('pcs',shc);end
    if contains(PAN(kpan).node{l},'gas','IgnoreCase',true)
     if ~contains(PAN(kpan).label,'GAS REF|FF','IgnoreCase',true) || l<=ly/2
      indl = str2num(PAN(kpan).name{l});
      inds = find(strcmp({MGnmac.label},'gas_enable'));
      h = mgcheckbox(HFIG,'gas_enable','set(gcbo,''BackgroundColor'',[1 0.4 0.4])',1, ...
                     'Value',MGnmac(inds).data{indl},'UserData',PAN(kpan).name{l});
      inds = find(strcmp({MGnmac.label},'gas_ctrl'));
      h = mgpopupmenu(HFIG,'gas_ctrl', ...
                      {' ','open-loop','voltage','pressure','flux'},'set(gcbo,''BackgroundColor'',[1 0.4 0.4])', ...
                      1,'Value',MGnmac(inds).data{indl}+2,'UserData',PAN(kpan).name{l});
      inds = find(strcmp({MGnmac.label},'gas_type'));
      h = mgpopupmenu(HFIG,'gas_type', ...
                      [' ';gases],'set(gcbo,''BackgroundColor'',[1 0.4 0.4])', ...
                      1,'Value',MGnmac(inds).data{indl}+1,'UserData',PAN(kpan).name{l});
      inds = find(strcmp({MGnmac.label},'gas_drive'));
      h = mgpopupmenu(HFIG,'gas_drive', ...
                      {' ','Int','SCD','Ext'},'set(gcbo,''BackgroundColor'',[1 0.4 0.4])', ...
                      1,'Value',MGnmac(inds).data{indl}+2,'UserData',PAN(kpan).name{l});
      if contains(PAN(kpan).node{l},{'001','002','003'})
       inds = find(strcmp({MGnmac.label},'gas_analog_act'));
       h = mgpopupmenu(HFIG,'gas_analog_act', ...
                       {' ',1,2,3,4},'set(gcbo,''BackgroundColor'',[1 0.4 0.4])', ...
                       1,'Value',MGnmac(inds).data{indl}+1,'UserData',PAN(kpan).name{l});
       inds = find(strcmp({MGnmac.label},'gas_analog_gain'));
       h = mgedit(HFIG,'gas_analog_gain','set(gcbo,''BackgroundColor'',[1 0.4 0.4])', ...
                  1,'String',num2str(MGnmac(inds).data{indl}),'UserData',PAN(kpan).name{l});
       menutitg2 = 1;
      end
      menutitg = 1;
     end
    end
    if contains(PAN(kpan).node{l},'nbi','IgnoreCase',true)
     indl = str2num(PAN(kpan).name{l}(end));
     gas_type = mdsdata('vdbget($)',['tcv_nbhdb::nb',replace(PAN(kpan).name{l}(end),'1','i'),':ion_mass']);
     inds = find(strcmp({MGnmac.label},'nbi_enable'));
     switch MGnmac(inds).data{indl}
      case 'ON',qi = 1;
      otherwise,qi = 0;
     end
     h = mgcheckbox(HFIG,'nbi_enable','set(gcbo,''BackgroundColor'',[1 0.4 0.4])',1, ...
                    'Value',qi,'UserData',PAN(kpan).name{l}(end));
     inds = find(strcmp({MGnmac.label},'nbi_drive'));
     switch MGnmac(inds).data{indl}
      case 'NONE',qi = 1;
      case 'DRAWN',qi = 2;
      otherwise,qi = 3;
     end
     h = mgpopupmenu(HFIG,'nbi_drive', ...
                     {' ','Drawn','Console'},'set(gcbo,''BackgroundColor'',[1 0.4 0.4])', ...
                     1,'Value',qi,'UserData',PAN(kpan).name{l}(end));
     inds = find(strcmp({MGnmac.label},'nbi_rtc_on'));
     h = mgedit(HFIG,'nbi_rtc_on','set(gcbo,''BackgroundColor'',[1 0.4 0.4])', ...
                     1,'String',num2str(MGnmac(inds).data{indl}),'UserData',PAN(kpan).name{l}(end));
     inds = find(strcmp({MGnmac.label},'nbi_rtc_off'));
     h = mgedit(HFIG,'nbi_rtc_off','set(gcbo,''BackgroundColor'',[1 0.4 0.4])', ...
                     1,'String',num2str(MGnmac(inds).data{indl}),'UserData',PAN(kpan).name{l}(end));
     qi = {'H2','D2'};
     if ismember(gas_type,[1,2])
      h = mgtext(HFIG,'nbi_species',qi{gas_type},1);
     else
      h = mgtext(HFIG,'nbi_species','?',1);
     end
     menutitn = 1;
    end
   end
   if contains(PAN(kpan).label,'GAS FF','IgnoreCase',true)
    h = mgtext(HFIG,'fftitle','Advanced applications only',4);
   end
   if contains(PAN(kpan).label,'GAS REF|FF','IgnoreCase',true)
    h = mgtext(HFIG,'toggle','toggle',1);
    h = mgpushbutton(HFIG,'unstick',['enmac(''unstick'')'],1,'string','Unstick/f.f.');
   end
   if ~contains(PAN(kpan).label,'FRINGES','IgnoreCase',true)
    h = mgpushbutton(HFIG,'zero_traces',['enmac(''zero_traces'')'],1,'string','Zero traces');
   end
   if menutitg
    h = mgtext(HFIG,'ctrl','CTRL',1);
    h = mgtext(HFIG,'gas','GAS',1);
    h = mgtext(HFIG,'drive','DRV',1);
    if menutitg2
     h = mgtext(HFIG,'analog','PCS',1);
     h = mgtext(HFIG,'gain','gain',1);
    end
    if ~contains(PAN(kpan).label,'GAS FF','IgnoreCase',true)
     h = mgpushbutton(HFIG,'convert', ...
          ['[h1,hfig]=gcbo;c2=get(findobj(hfig,''tag'',''ctrl_convert''),''Value'');enmac(''convert'',c2)'], ...
               1,'string','Convert to');
     h = mgpopupmenu(HFIG,'ctrl_convert', ...
                    {' ','Voltage','Pressure','Flux'},'',1,'Value',1);
    end
    h = mgpushbutton(HFIG,'gas_enable_all', ...
          '[h1,hfig]=gcbo;set(findobj(hfig,''tag'',''gas_enable''),''value'',1,''BackgroundColor'',[1 0.4 0.4]);', ...
          1,'string','Select all');
    h = mgpushbutton(HFIG,'gas_disable_all', ...
          '[h1,hfig]=gcbo;set(findobj(hfig,''tag'',''gas_enable''),''value'',0,''BackgroundColor'',[1 0.4 0.4]);', ...
          1,'string','Deselect all');
   end
   if menutitn
    h = mgtext(HFIG,'nbi_ff',sprintf('FF\nTRACE'),1);
    h = mgtext(HFIG,'nbi_rtc_t_on',sprintf('RTC\nt_on'),1);
    h = mgtext(HFIG,'nbi_rtc_t_off',sprintf('RTC\nt_off'),1);
    h = mgtext(HFIG,'nbi_gas','GAS',1);
    h = mgpushbutton(HFIG,'nbi_enable_all', ...
          '[h1,hfig]=gcbo;set(findobj(hfig,''tag'',''nbi_enable''),''value'',1,''BackgroundColor'',[1 0.4 0.4]);', ...
          1,'string','Select all');
    h = mgpushbutton(HFIG,'nbi_disable_all', ...
          '[h1,hfig]=gcbo;set(findobj(hfig,''tag'',''nbi_enable''),''value'',0,''BackgroundColor'',[1 0.4 0.4]);', ...
          1,'string','Deselect all');
    pe_label = 'Plot energy';
    if nargin > 2 && varargin{2}
     pe_label = 'Plot power';
    end
    h = mgpushbutton(HFIG,'nbi_power_energy', ...
          ['v2 = 1;if strcmp(get(gcbo,''string''),''Plot power''),v2 = 0;end;', ...
           'enmac(''pan'',int2str(get(gcbo,''UserData'')),v2)'], ...
               1,'string',pe_label,'UserData',KPAN);
   end
   if contains(PAN(kpan).label,{'gas','piezo'},'IgnoreCase',true)
    set(findobj(HFIG,'tag','loadsel'),'string','load gas from','visible','on');
   elseif contains(PAN(kpan).label,{'FRINGES'},'IgnoreCase',true)
    set(findobj(HFIG,'tag','loadsel'),'string','load density from','visible','on');
   elseif contains(PAN(kpan).label,{'NBI'},'IgnoreCase',true)
    set(findobj(HFIG,'tag','loadsel'),'string','load NBI from','visible','on');
   else
    set(findobj(HFIG,'tag','loadsel'),'string','','visible','off');
   end
   set(ax,'xticklabelmode','auto'); % Last axes created
   set([findobj(HFIG,'tag','txtw') findobj(HFIG,'tag','txtx') findobj(HFIG,'tag','txty') findobj(HFIG,'tag','origin')],'string','')
   enmac resize

  case 'apply'
   for h = findobj(HFIG,'type','line','tag','wave')'
    for l = 1:length(PAN(KPAN).node)
     if strcmp(PAN(KPAN).node{l},get(h,'UserData'))
      inds = PAN(KPAN).inds(l,1);
      indl = PAN(KPAN).inds(l,2);
      MGnmac(inds).data{indl} = get(h,'ydata')';
      if MGnmac(inds).stdwave
       MGnmac(inds).time{indl} = get(h,'xdata')';
      else
       MGnmac(strcmp({MGnmac.label},[MGnmac(inds).label,'_t'])).data{indl} = get(h,'xdata')';
      end
      if contains(get(h,'UserData'),'NBI','IgnoreCase',true)
       nn = char(regexp(PAN(KPAN).name{l},'\d','match'));
       q = mdsdata('vdbget($)',['tcv_nbhdb::nb',replace(nn,'1','i'),':ion_mass']);
       qi = {'H2','D2'};
       conv2 = mdsdata('if_error(execute($1),$2)', ...
                       ['_c=\PCS::ENERGY_NBI_',nn,'_',qi{q}],NaN);
       conv1 = mdsdata('if_error(execute($1),$2)','dim_of(_c)',NaN);
       try
	y = interp1(conv1,conv2,get(h,'ydata')','spline',0);
       catch
	y = zeros(size(get(h,'ydata')))';
       end
       MGnmac(strcmp({MGnmac.label},[MGnmac(inds).label(1:end-5),'energy'])).data{indl} = y;
       MGnmac(strcmp({MGnmac.label},[MGnmac(inds).label(1:end-5),'energy_t'])).data{indl} = get(h,'xdata')';
      end
     end
    end
   end
   for h = findobj(HFIG,'tag','gas_enable')'
    inds = find(strcmp({MGnmac.label},'gas_enable'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(MGnmac(inds).node{l}(regexp(MGnmac(inds).node{l},'\d\d')+[1:2]),get(h,'UserData'))
      MGnmac(inds).data{l} = get(h,'value');
     end
    end
   end
   for h = findobj(HFIG,'tag','gas_ctrl')'
    inds = find(strcmp({MGnmac.label},'gas_ctrl'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(MGnmac(inds).node{l}(regexp(MGnmac(inds).node{l},'\d\d')+[1:2]),get(h,'UserData'))
      MGnmac(inds).data{l} = get(h,'value')-2;
     end
    end
   end
   for h = findobj(HFIG,'tag','gas_type')'
    inds = find(strcmp({MGnmac.label},'gas_type'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(MGnmac(inds).node{l}(regexp(MGnmac(inds).node{l},'\d\d')+[1:2]),get(h,'UserData'))
      MGnmac(inds).data{l} = get(h,'value')-1;
     end
    end
   end
   for h = findobj(HFIG,'tag','gas_drive')'
    inds = find(strcmp({MGnmac.label},'gas_drive'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(MGnmac(inds).node{l}(regexp(MGnmac(inds).node{l},'\d\d')+[1:2]),get(h,'UserData'))
      MGnmac(inds).data{l} = get(h,'value')-2;
     end
    end
   end
   for h = findobj(HFIG,'tag','gas_analog_act')'
    inds = find(strcmp({MGnmac.label},'gas_analog_act'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(MGnmac(inds).node{l}(regexp(MGnmac(inds).node{l},'\d\d')+[1:2]),get(h,'UserData'))
      MGnmac(inds).data{l} = get(h,'value')-1;
     end
    end
   end
   for h = findobj(HFIG,'tag','gas_analog_gain')'
    inds = find(strcmp({MGnmac.label},'gas_analog_gain'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(MGnmac(inds).node{l}(regexp(MGnmac(inds).node{l},'\d\d')+[1:2]),get(h,'UserData'))
      MGnmac(inds).data{l} = str2double(get(h,'string'));
     end
    end
   end
   for h = findobj(HFIG,'tag','nbi_enable')'
    qi = {'OFF','ON'};
    inds = find(strcmp({MGnmac.label},'nbi_enable'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(regexp(MGnmac(inds).node{l},'\d','match'),get(h,'UserData'))
      MGnmac(inds).data{l} = qi{get(h,'value')+1};
     end
    end
   end
   for h = findobj(HFIG,'tag','nbi_drive')'
    qi = {' ','DRAWN','CONSOLE'};
    inds = find(strcmp({MGnmac.label},'nbi_drive'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(regexp(MGnmac(inds).node{l},'\d','match'),get(h,'UserData'))
      MGnmac(inds).data{l} = qi{get(h,'value')};
     end
    end
   end
   for h = findobj(HFIG,'tag','nbi_rtc_on')'
    inds = find(strcmp({MGnmac.label},'nbi_rtc_on'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(regexp(MGnmac(inds).node{l},'\d','match'),get(h,'UserData'))
      MGnmac(inds).data{l} = str2double(get(h,'string'));
     end
    end
   end
   for h = findobj(HFIG,'tag','nbi_rtc_off')'
    inds = find(strcmp({MGnmac.label},'nbi_rtc_off'));
    for l = 1:length(MGnmac(inds).node)
     if strcmp(regexp(MGnmac(inds).node{l},'\d','match'),get(h,'UserData'))
      MGnmac(inds).data{l} = str2double(get(h,'string'));
     end
    end
   end
   set(findobj(HFIG,'type','line','tag','wave','color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4]),'color',[.5 .5 1],'markerfacecolor',[.5 .5 1])
   set(findobj(HFIG,'type','uicontrol','Style','PopUpMenu','Backgroundcolor',[1 0.4 0.4]),'Backgroundcolor',[1 0.6 0.2])
   set(findobj(HFIG,'type','uicontrol','Style','Checkbox','Backgroundcolor',[1 0.4 0.4]),'Backgroundcolor',[1 1 1]*.5)
   set(findobj(HFIG,'type','uicontrol','Style','Edit','Backgroundcolor',[1 0.4 0.4]),'Backgroundcolor',[1 1 1])
   MGvarst = false;
   enmac pan

  case 'loadsel'
   shot = str2double(get(findobj(HFIG,'tag','origin'),'string'));
   jshot = mdsopen('pcs',str2double(get(findobj(HFIG,'tag','origin'),'string')));
   if isempty(jshot) | jshot~=shot
    disp(setstr(7))
    dummy = questdlg('PCS tree to load from cannot be opened','','OK','OK');
    return
   end
%
   if contains(PAN(KPAN).label,{'gas','piezo'},'IgnoreCase',true)
    for h = findobj(HFIG,'tag','gas_enable')'
     q0 = get(h,'value');
     n = get(h,'UserData');
     if q0,
% TEMP FROM
      qset = false;
      sh0 = mdsdata('$SHOT');
      valve_nb = str2num(n);
      if (sh0 <= 77678 && sh0 >= 75000 && ismember(valve_nb,[4,5,6,7,8,9,10,12,13,14,15])) || ...
         (sh0 <= 78666 && sh0 >= 3872 && ismember(valve_nb,[1,2,3]))
       if valve_nb > 3
        try
         [gas_info] = GASget_info(valve_nb,'',sh0,true);
         if ~all(isfield(gas_info,{'dev','valve_id'})),gas_info = [];end
        catch
         gas_info = [];
        end
       else
        gas_info.dev = valve_nb;
        gas_info.valve_id = valve_nb;
       end
       if ~isempty(gas_info)
        yr = mdsdata('if_error(execute($1),$2)',['\pcs::draw_feedfor_gas:alim_' num2str(gas_info.dev,'%03.f')],[0;0]);
% change retroactivly for shots where X-point GPI LFS was switched
% from controller 15 to 12 when it failed, nevertheless write in
% valve 15
        if gas_info.valve_id == 12 && max(yr)>0 % non zero request
         n = '15';
	end
        xr = mdsdata('if_error(execute($1),$2)',['dim_of(\pcs::draw_feedfor_gas:alim_' num2str(gas_info.dev,'%03.f'),')'],[0;2]);
       else
        yr = [0;0];
        xr = [0;2];
       end
       if max(yr) > 0,
        q.enable = 1;
       else
        q.enable = 0;
       end
       if valve_nb > 3 && max(yr) >= 0,
        q.gas_ctrl = 3;% flux feedback control
       else
        q.gas_ctrl = 1;
       end
       yf = [0,0];
       xf = [0,2];
       q.gas_type = 0;
% Special case: we put D2 by default in valve 1
       if valve_nb == 1,q.gas_type = 2;end
       if valve_nb > 3
        q.gas_drive = 0;% all discharges so far were performed in internal drive mode
       else
        q.gas_drive = 2;
       end
       q.gas_analog_act = valve_nb;
       q.gas_analog_gain = 1;
       qset = true;
      end
% TEMP TO
      for h1 = findobj(HFIG,'type','line','tag','wave')'
       n1 = get(h1,'UserData');
       n1 = n1(1:regexp(n1,'\d\d')+2);
       if strcmp(n1(end-1:end),n)
% TEMP FROM
        if ~qset
% TEMP TO
        x = mdsdata('if_error(execute($1),$2)',[n1,':time'],[0;2]);
        y = mdsdata('if_error(execute($1),$2)',[n1,':val'],[0;0]);
% TEMP FROM
        else
         if contains(n1,'FEEDFOR')
          x = xf;
          y = yf;
         elseif contains(n1,'REF')
          x = xr;
          y = yr;
         end
        end
% TEMP TO
        set(h1,'ydata',y,'xdata',x,'color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4])
       end
      end
% TEMP FROM
      if ~qset
% TEMP TO
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_enable')'
       set(h1,'value',mdsdata('if_error(execute($1),$2)',['\PCS::GAS_VALVE_0',n,':ENABLE'],0), ...
           'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_ctrl')'
       set(h1,'value',mdsdata('if_error(execute($1),$2)',['\PCS::GAS_CTRL_0',n,':VAL'],-1)+2, ...
           'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_type')'
       gas_type = mdsdata('if_error(execute($1),$2)',['\PCS::GAS_TYPE_0',n,':VAL'],0);
% Special case: we assume D2 by default in valve 1
       if strcmp(n,'01') && ~gas_type,gas_type = 2;end
       set(h1,'value',gas_type+1, ...
           'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_drive')'
       set(h1,'value',mdsdata('if_error(execute($1),$2)',['\PCS::GAS_DRIVE_0',n,':VAL'],-1)+2, ...
           'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_analog_act')'
       set(h1,'value',mdsdata('if_error(execute($1),$2)',['\PCS::GAS_VALVE_0',n,':ANALOG_ACT:VAL'],0)+1, ...
           'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_analog_gain')'
       set(h1,'value',mdsdata('if_error(execute($1),$2)',['\PCS::GAS_VALVE_0',n,':ANALOG_GAIN:VAL'],0), ...
           'BackgroundColor',[1 0.4 0.4])
      end
% TEMP FROM
      else
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_enable')'
       set(h1,'value',q.enable,'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_ctrl')'
       set(h1,'value',q.gas_ctrl+2,'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_type')'
       set(h1,'value',q.gas_type+1,'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_drive')'
       set(h1,'value',q.gas_drive+2,'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_analog_act')'
       set(h1,'value',q.gas_analog_act+1,'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','gas_analog_gain')'
       set(h1,'value',q.gas_analog_gain,'BackgroundColor',[1 0.4 0.4])
      end
      end
% TEMP TO
     end
    end
    mgamsmsge(sprintf('Gas loaded from shot #%d',jshot));
   elseif contains(PAN(KPAN).label,{'FRINGES'},'IgnoreCase',true)
    for h1 = findobj(HFIG,'type','line','tag','wave')'
     n1 = get(h1,'UserData');
     set(h1,'ydata',mdsdata('if_error(execute($1),$2)',n1,[0;0]), ...
          'xdata',mdsdata('if_error(execute($1),$2)',[n1,':time'],[0;2]), ...
          'color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4])
    end
    mgamsmsge(sprintf('Density loaded from shot #%d',jshot));
   elseif contains(PAN(KPAN).label,{'NBI'},'IgnoreCase',true)
% TEMP FROM
    shc = 0;
    if mdsdata('getdbi("NUMBER_OPENED")')
     shc = mdsdata('$SHOT');
    end
    mdsopen('pcs',-1);
    for iin=1:2
     dt(iin) = mdsdata(['\LIM_NBI_',int2str(iin),':DT']);
    end
    if shc,mdsopen('pcs',shc);end
% TEMP TO
    for h = findobj(HFIG,'tag','nbi_enable')'
     q0 = get(h,'value');
     n = get(h,'UserData');
     if q0,
% TEMP FROM
      qset = false;
      sh0 = mdsdata('$SHOT');
      if sh0 <= 78666 && sh0 >= 51411
       dbss = ['I','2'];
       for is = 1:2
        iss = int2str(is);
	if contains(n,iss,'IgnoreCase',true)
         [js,s] = mdsopen('atlas',sh0);
	 if isempty(js) | js~=sh0,
	  disp(setstr(7))
	  dummy = questdlg(['Shot ',int2str(sh0),' (Atlas tree) cannot be opened'], ...
		'','OK','OK');
	  return
	 end
         y = mdsdata('if_error(execute($1),$2)',['\atlas::nb',iss,'.data.model:powr_neutral'],[0;0])*1e6;
         x = mdsdata('if_error(execute($1),$2)',['dim_of(\atlas::nb',iss,'.data.model:powr_neutral)'],[0;2]);
         mdsclose;
         if max(y) > 0,
          q.online = 'ON';
	  x = [x(1)-dt(1);x;x(end)+dt(1)];
	  y = [0;y;0];
         else
          q.online = 'OFF';
         end
         q.drive = 'DRAWN';
         [js,s] = mdsopen('vsystem',sh0);
	 if isempty(js) | js~=sh0,
	  disp(setstr(7))
	  dummy = questdlg(['Shot ',int2str(sh0),' (Vsystem tree) cannot be opened'], ...
		'','OK','OK');
	 end
         if ~strncmpi(mdsdata('if_error(execute($1),$2)',['\vsystem::tcv_nbhdb_b["NB',dbss(is),':RT_READY"]'],'OFF'),'ON',2)
          q.t_rt_on = 0;
          q.t_rt_off = 0;
         else
          q.t_rt_on = mdsdata('if_error(execute($1),$2)',['\vsystem::tcv_nbhdb_r["NB',dbss(is),':RT_TIMEON"]'],0);
          q.t_rt_off = mdsdata('if_error(execute($1),$2)',['\vsystem::tcv_nbhdb_r["NB',dbss(is),':RT_TIMEOFF"]'],0);
         end
         q.gas_type = mdsdata('if_error(execute($1),$2)',['\vsystem::tcv_nbhdb_i["NB',dbss(is),':ION_MASS"]'],0);
         mdsclose;
         qset = true;
        end
       end
      end
% TEMP TO
      for h1 = findobj(HFIG,'type','line','tag','wave')'
       n1 = get(h1,'UserData');
       n1 = n1(1:regexp(n1,'\d'));
       if strcmp(n1(end),n)
% TEMP FROM
        if ~qset
% TEMP TO
        set(h1,'ydata',mdsdata('if_error(execute($1),$2)',[n1,':val'],[0;0]), ...
            'xdata',mdsdata('if_error(execute($1),$2)',[replace(lower(n1),'power_',''),':time'],[0;2]), ...
            'color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4])
% TEMP FROM
        else
        set(h1,'ydata',y,'xdata',x, ...
            'color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4])
        end
% TEMP TO
       end
      end
% TEMP FROM
      if ~qset
% TEMP TO
      switch mdsdata('if_error(execute($1),$2)',['\PCS::ONLINE_NBI_',n],'OFF')
       case 'ON',qi = 1;
       otherwise,qi = 0;
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','nbi_enable')'
       set(h1,'value',qi,'BackgroundColor',[1 0.4 0.4])
      end
      switch mdsdata('if_error(execute($1),$2)',['\PCS::DRIVE_NBI_',n,':INTERNAL:VAL'],' ')
       case 'DRAWN',qi = 2;
       case 'CONSOLE',qi = 3;
% NBI drive set by default to 'DRAWN'
       otherwise,qi = 2;
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','nbi_drive')'
       set(h1,'value',qi,'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','nbi_rtc_on')'
       set(h1,'string',num2str(mdsdata('if_error(execute($1),$2)',['\PCS::DRIVE_NBI_',n,':PCS:T_START'],0)),'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','nbi_rtc_off')'
       set(h1,'string',num2str(mdsdata('if_error(execute($1),$2)',['\PCS::DRIVE_NBI_',n,':PCS:T_STOP'],0)),'BackgroundColor',[1 0.4 0.4])
      end
% TEMP FROM
      else
      switch q.online
       case 'ON',qi = 1;
       otherwise,qi = 0;
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','nbi_enable')'
       set(h1,'value',qi,'BackgroundColor',[1 0.4 0.4])
      end
      switch q.drive
       case 'DRAWN',qi = 2;
       case 'CONSOLE',qi = 3;
       otherwise,qi = 1;
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','nbi_drive')'
       set(h1,'value',qi,'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','nbi_rtc_on')'
       set(h1,'string',num2str(q.t_rt_on),'BackgroundColor',[1 0.4 0.4])
      end
      for h1 = findobj(HFIG,'UserData',n,'tag','nbi_rtc_off')'
       set(h1,'string',num2str(q.t_rt_off),'BackgroundColor',[1 0.4 0.4])
      end
      end
% TEMP TO
     end
    end
    mgamsmsge(sprintf('NBI loaded from shot #%d',jshot));
   else
   end
   enmac pretty

  case 'convert'
   if nargin > 1 && varargin{1} > 1
    c2 = varargin{1};
    shc = 0;
    if mdsdata('getdbi("NUMBER_OPENED")')
     shc = mdsdata('$SHOT');
    end
    mdsopen('pcs',-1);
    for h = findobj(HFIG,'tag','gas_enable')'
     q0 = get(h,'value');
     n = get(h,'UserData');
     if q0
      for h1 = findobj(HFIG,'type','line','tag','wave')'
       n1 = get(h1,'UserData');
       n1 = n1(1:regexp(n1,'\d\d')+2);
       if strcmp(n1(end-1:end),n)
        y = get(h1,'ydata')';
        for h2 = findobj(HFIG,'UserData',n,'tag','gas_ctrl')'
         c1 = get(h2,'value')-1;
         if c1 > 1 && c1 ~= c2
          for h3 = findobj(HFIG,'UserData',n,'tag','gas_type')'
           gas = get(h3,'value')-2;
          end
          if gas > -1
           switch c1
            case 2
             switch c2
              case 3
               y = y*mdsdata(['\CALIB_GAS_0',n,':PROPERTIES:VtoPConvFact[\GAS_LIST[$1]]'],gas);
              case 4
               y(y<0) = 0;
               F = mdsdata(['\CALIB_GAS_0',n,':PROPERTIES:V2F_k[*,\GAS_LIST[$1]]'],gas);
               y = F(1)*(((F(2)*y).^F(3)+1).^(1/F(3))-1);
             end
            case 3
             switch c2
              case 2
               y = y/mdsdata(['\CALIB_GAS_0',n,':PROPERTIES:VtoPConvFact[\GAS_LIST[$1]]'],gas);
              case 4
               y = y/mdsdata(['\CALIB_GAS_0',n,':PROPERTIES:VtoPConvFact[\GAS_LIST[$1]]'],gas);
               y(y<0) = 0;
               F = mdsdata(['\CALIB_GAS_0',n,':PROPERTIES:V2F_k[*,\GAS_LIST[$1]]'],gas);
               y = F(1)*(((F(2)*y).^F(3)+1).^(1/F(3))-1);
             end
            case 4
             switch c2
              case 2
               F = mdsdata(['\CALIB_GAS_0',n,':PROPERTIES:F2V_k[*,\GAS_LIST[$1]]'],gas);
               y = ((y/F(1)+1).^F(3)-1).^(1/F(3))/F(2);
              case 3
               F = mdsdata(['\CALIB_GAS_0',n,':PROPERTIES:F2V_k[*,\GAS_LIST[$1]]'],gas);
               y = ((y/F(1)+1).^F(3)-1).^(1/F(3))/F(2);
               y = y*mdsdata(['\CALIB_GAS_0',n,':PROPERTIES:VtoPConvFact[\GAS_LIST[$1]]'],gas);
             end
           end
           set(h1,'ydata',y');
           x = mdsdata('IF_ERROR(GETNCI($1,"RECORD"),$ROPRAND)',['\PCS::LIM_GAS_0',n,':YMAX']);
           if c2 >= 1
	    x = [0,x(c2)];
	   else
	    x = [0,x(1)];
	   end
           switch PAN(KPAN).label
            case 'Density/Gas',l = 2;
            case 'Density/Piezo REF',l = str2num(n)+1;
            case 'GAS REF',l = str2num(n);
            case 'GAS REF|FF',l = str2num(n)+20;
           end
           PAN(KPAN).lim(:,l) = x;
           set(h2,'value',c2+1,'BackgroundColor',[1 0.4 0.4]);
	   PAN(KPAN).legend{l} = [regexprep(PAN(KPAN).legend{l},'\s\(\S*\)',''), ...
                        	 replace([' (',deblank( ...
               mdsdata('if_error(execute($1),$2)', ...
                       [replace(lower(PAN(KPAN).node{l}),':val',''),':units[',int2str(c2-1),']'],' ') ...
                                               ),')'],' ()','')];
           ax = get(h1,'Parent');
           delete(findobj(ax,'type','text'))
	   text(0.05,0.95,PAN(KPAN).legend{l}, ...
        	'units','normalized','color','g','horizontalalignment','left','verticalalignment','top','Parent',ax);
          end
         end
        end
       end
      end
      enmac('pretty');
     end
    end
    if shc,mdsopen('pcs',shc);end
   end

  case 'unstick'
   for h = findobj(HFIG,'tag','gas_enable')'
    q0 = get(h,'value');
    n = get(h,'UserData');
    if q0 && str2num(n) < 4,
     h1 = findobj(HFIG,'type','line','tag','wave','UserData',['\PCS::GAS_REF_0',n,':VAL']);
     x1 = get(h1,'XData');
     y1 = get(h1,'YData');
     h2 = findobj(HFIG,'type','line','tag','wave','UserData',['\PCS::GAS_FEEDFOR_0',n,':VAL']);
     x2 = get(h2,'XData');
     y2 = get(h2,'YData');
     if ~any(y2)
      tpre = x1(find(y1 & x1>-1,1,'first'));
      if ~isempty(tpre)
       x2 = [tpre,tpre+0.001,tpre+0.006,tpre+0.026,max(x1(end),tpre+0.027)+[0,0.001]];
       y2 = [0,165,165,100,100,0];
       y1(x1<-2) = 0;
      end
     elseif ~any(y1(x1<-2))
      i1 = find(x1>-2);
      x1 = [-3.951,-3.95,-3.93,-3.929,x1(i1)];
      y1 = [0,2,2,0,y1(i1)];
      x2 = [0,2];
      y2 = [0,0];
     else
      break
     end
     set(h1,'ydata',y1','xdata',x1','Color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4]);
     set(h2,'ydata',y2','xdata',x2','Color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4]);
    end
   end
   enmac('pretty');      

  case 'zero_traces'
   for h = [findobj(HFIG,'tag','gas_enable')',findobj(HFIG,'tag','nbi_enable')'];
    q0 = get(h,'value');
    n = get(h,'UserData');
    if q0
     for h1 = findobj(HFIG,'type','line','tag','wave')'
      n1 = get(h1,'UserData');
      if ~isempty(strfind(lower(n1),'gas'))
       n1 = n1(regexp(n1,'\d\d')+[1:2]);
      elseif ~isempty(strfind(lower(n1),'nbi'))
       n1 = n1(regexp(n1,'\d'));
      else
       break
      end
      if strcmp(n1,n)
       set(h1,'xdata',[0 2],'ydata',[0 0],'color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4]);
      end
     end
    end
   end
   enmac('pretty');

  case 'quit'
   % If closing an enmac figure
   % Check if figure in second argument is the current enmac figure
   if nargin > 1 && ~isequal(HFIG,varargin{1})
     % If not, delete carefully the figure
     checkdelete(varargin{1});
     % Different enmac session so return now
     return;
   end
   % Avoid triggering the quit action again
   if ishghandle(HFIG), set(HFIG,'DeleteFcn',[]);end
   % Delete carefully the figure
   checkdelete(HFIG);
   % Re-init all variables and return
   clear enmac
   return

  case 'selknot'
   d = str2double(varargin{1});
   [x,~,k,~,~,w] = knotsel(ax,0,0);
   w.sel = min(max(k+d,1),length(x));
   set(ax,'UserData',w)
   knotsel(ax,0,1);

  case 'selwave'
   d = str2double(varargin{1});
   if isempty(KPAN), return, end
   [x,~,k] = knotsel(ax,0,0);
   if isempty(k), return, end
   x1 = x(k);
   h = sort(findobj(HFIG,'type','axes'));
   ax=h(min(max(find(h==ax)+d,1),length(h)));
   axes(ax);
   [x,~,~,~,~,w] = knotsel(ax,0,0);
   [~,k] = min(abs(x-x1));
   w.sel = k;
   set(ax,'UserData',w);
   knotsel(ax,0,1);

  case 'del'
   d = str2double(varargin{1});
   [x,y,k,~,h,w] = knotsel(ax,0,0);
   if ~isempty(k)
    x(k) = []; y(k) = [];
    set(h,'xdata',x,'ydata',y,'color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4])
    w.sel = min(k+d,length(x));
    if w.sel <= 0, w.sel = []; end
    set(ax,'UserData',w);
   end
   knotsel(ax,0,1);
   enmac pretty

  case 'onoff'
   if strcmp(get(gcbo,'checked'),'on'), set(gcbo,'checked','off')
   else,                                set(gcbo,'checked','on')
   end
   
  case 'txt'
   try
    p = [eval(get(findobj(HFIG,'tag','txtx'),'string')) eval(get(findobj(HFIG,'tag','txty'),'string'))];
    enmac('move',p)
   end
   
  case 'btndwn'
   if ~verLessThan('matlab','8.4.0')
    % See function ginput in versions later than 8.4.0 for emulating a
    % fullcrosshair pointer
    pointer = 'crosshair';
   else
    pointer = 'fullcrosshair';
   end
   set(HFIG,'pointer',pointer)
   switch get(HFIG,'selectiontype')
    case 'normal', knotsel(ax,1,1);
    case 'extend', set(HFIG,'windowbuttonmotionfcn','enmac move')
    case 'alt',    enmac new
   end
   
  case 'btnup'
   set(HFIG,'pointer','default','windowbuttonmotionfcn','')
   
  case 'resize'
   if contains(get(HFIG,'name'),{'gas','piezo'},'IgnoreCase',true)
    spacex = 270;
   elseif contains(get(HFIG,'name'),{'nbi'},'IgnoreCase',true)
    spacex = 240;
   else
    spacex = 10;
   end
   tmp = get(HFIG,'position');
   set(findobj(HFIG,'tag','txtw'),'position',[0   tmp(4)-20 200 20])
   set(findobj(HFIG,'tag','txtx'),'position',[200 tmp(4)-20  75 20])
   set(findobj(HFIG,'tag','txty'),'position',[275 tmp(4)-20  75 20])
   set(findobj(HFIG,'tag','loadsel'),'position',[430 tmp(4)-20  120 20])
   set(findobj(HFIG,'tag','origin'),'position',[550 tmp(4)-20  75 20])
   h = findobj(HFIG,'type','axes');
   if ~isempty(h)
    if contains(PAN(KPAN).label,{'GAS REF|FF'},'IgnoreCase',true)
     x = round((tmp(4)-50)/length(h)*2*(0:length(h)/2)+20);
     for k=1:length(h)/2
      set(h(k),'units','pixel','position',[50 x(k) (tmp(3)-spacex)/2-50 x(k+1)-x(k)])     
      set(h(k+length(h)/2),'units','pixel','position',[(tmp(3)-spacex)/2+50 x(k) (tmp(3)-spacex)/2-50 x(k+1)-x(k)])     
      if contains(getfield(get(h(k),'UserData'),'node'),'gas','IgnoreCase',true),
       xb(k) = 1;
      else
       xb(k) = 0;
      end
     end
    else
     x = round((tmp(4)-70)/length(h)*(0:length(h))+20);
     for k=1:length(h)
      set(h(k),'units','pixel','position',[50 x(k) tmp(3)-spacex-50 x(k+1)-x(k)])     
      if contains(getfield(get(h(k),'UserData'),'node'),'gas','IgnoreCase',true),
       xb(k) = 1;
      else
       xb(k) = 0;
      end
     end
    end
    enmac pretty
   end
% GAS
   dx = 15;
   dy = 15;
   hc = findobj(HFIG,'tag','gas_enable');
   hb = find(xb);
   if ~isempty(hb)
    hb(end+1) = hb(end)+1;
    if length(hc) ~= length(hb)-1
     uiwait(errordlg(['Error: discrepancy in number of gas traces in ' get(HFIG,'name')],'','modal'))
    end
    if ~isempty(hc)
     for k=1:length(hc)
      set(hc(k),'units','pixel','position',[tmp(3)-spacex (x(hb(k))+x(hb(k)+1))/2 dx dy])
     end
    end
   end
   tmp = tmp(3)-spacex+dx;
%
   dx = 70;
   hc = findobj(HFIG,'tag','gas_ctrl');
   if ~isempty(hb)
    if length(hc) ~= length(hb)-1
     uiwait(errordlg(['Error: discrepancy in number of gas traces in ' get(HFIG,'name')],'','modal'))
    end
    if ~isempty(hc)
     for k=1:length(hc)
      set(hc(k),'units','pixel','position',[tmp+2 (x(hb(k))+x(hb(k)+1))/2+dy/2 dx 0])
     end
    end
   end
   ht = findobj(HFIG,'tag','ctrl');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(hb(end))+dy*0.5+2 dx dy])
   end
   ht = findobj(HFIG,'tag','fftitle');
   dx = 300;
   if ~isempty(ht)
    set(ht,'units','pixel','position',[240 x(hb(end))+dy*0.5+2 dx dy])
   end
   dx = 70;
   tmp = tmp+dx+2;
%
   dx = 48;
   hc = findobj(HFIG,'tag','gas_type');
   if ~isempty(hb)
    if length(hc) ~= length(hb)-1
     uiwait(errordlg(['Error: discrepancy in number of gas traces in ' get(HFIG,'name')],'','modal'))
    end
    if ~isempty(hc)
     for k=1:length(hc)
      set(hc(k),'units','pixel','position',[tmp+2 (x(hb(k))+x(hb(k)+1))/2+dy/2 dx 0])
     end
    end
   end
   ht = findobj(HFIG,'tag','gas');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(hb(end))+dy*0.5+2 dx dy])
   end
   tmp = tmp+dx+2;
%
   dx = 38;
   hc = findobj(HFIG,'tag','gas_drive');
   if ~isempty(hb)
    if length(hc) ~= length(hb)-1
     uiwait(errordlg(['Error: discrepancy in number of gas traces in ' get(HFIG,'name')],'','modal'))
    end
    if ~isempty(hc)
     for k=1:length(hc)
      set(hc(k),'units','pixel','position',[tmp+2 (x(hb(k))+x(hb(k)+1))/2+dy/2 dx 0])
     end
    end
   end
   ht = findobj(HFIG,'tag','drive');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(hb(end))+dy*0.5+2 dx dy])
   end
   tmp = tmp+dx+2;
%
   dx = 38;
   for k=1:length(hb)-1
    if contains(getfield(get(h(hb(k)),'UserData'),'node'),{'001','002','003'},'IgnoreCase',true),
     xb(hb(k)) = 1;
    else
     xb(hb(k)) = 0;
    end
   end
   hc = findobj(HFIG,'tag','gas_analog_act');
   hb = find(xb);
   if ~isempty(hb)
    hb(end+1) = hb(end)+1;
    if length(hc) ~= length(hb)-1
     uiwait(errordlg(['Error: discrepancy in number of gas traces in ' get(HFIG,'name')],'','modal'))
    end
    if ~isempty(hc)
     for k=1:length(hc)
      set(hc(k),'units','pixel','position',[tmp+2 (x(hb(k))+x(hb(k)+1))/2+dy/2 dx 0])
     end
    end
   end
   ht = findobj(HFIG,'tag','analog');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(hb(end))+dy*0.5+2 dx dy])
   end
   tmp = tmp+dx+2;
%
   dx = 45;
   dy = 20;
   hc = findobj(HFIG,'tag','gas_analog_gain');
   if ~isempty(hb)
    if length(hc) ~= length(hb)-1;
     uiwait(errordlg(['Error: discrepancy in number of gas traces in ' get(HFIG,'name')],'','modal'))
    end
    if ~isempty(hc)
     for k=1:length(hc)
      set(hc(k),'units','pixel','position',[tmp+2 (x(hb(k))+x(hb(k)+1))/2-dy/2 dx dy])
     end
    end
   end
   dy = 15;
   ht = findobj(HFIG,'tag','gain');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(hb(end))+dy*0.5+2 dx dy])
   end
%
   tmp = get(HFIG,'position');
   dx = 85;
   dy = 25;
   hc = findobj(HFIG,'tag','convert');
   if ~isempty(hc)
    set(hc,'units','pixel','position',[tmp(3)-dx-3 tmp(4)*.4+4+dy dx dy])
   end
   hc = findobj(HFIG,'tag','ctrl_convert');
   if ~isempty(hc)
    set(hc,'units','pixel','position',[tmp(3)-dx-3 tmp(4)*.4 dx dy])
   end
   ht = findobj(HFIG,'tag','zero_traces');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp(3)-dx-3 tmp(4)*.62 dx dy])
   end
   ht = findobj(HFIG,'tag','toggle');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp(3)-dx-3 tmp(4)*.2+4+1.3*dy dx dy])
   end
   hc = findobj(HFIG,'tag','unstick');
   if ~isempty(hc)
    set(hc,'units','pixel','position',[tmp(3)-dx-3 tmp(4)*.2 dx 1.3*dy])
   end
   hc = findobj(HFIG,'tag','gas_enable_all');
   if ~isempty(hc)
    set(hc,'units','pixel','position',[tmp(3)-dx-3 8+dy dx dy])
   end
   hc = findobj(HFIG,'tag','gas_disable_all');
   if ~isempty(hc)
    set(hc,'units','pixel','position',[tmp(3)-dx-3 4 dx dy])
   end
% NBI
   tmp = get(HFIG,'position');
   dx = 15;
   dy = 15;
   hc = findobj(HFIG,'tag','nbi_enable');
   if ~isempty(hc)
    for k=1:length(hc)
     set(hc(k),'units','pixel','position',[tmp(3)-spacex (x(k)+x(k+1))/2 dx dy])
    end
   end
   tmp = tmp(3)-spacex+dx;
%
   dx = 85;
   dy = 50;
   hc = findobj(HFIG,'tag','nbi_power_energy');
   if ~isempty(hc)
    set(hc,'units','pixel','position',[tmp x(2)-dy/2 dx dy])
   end
%
   dx = 73;
   dy = 15;
   hc = findobj(HFIG,'tag','nbi_drive');
   if ~isempty(hc)
    for k=1:length(hc)
     set(hc(k),'units','pixel','position',[tmp+2 (x(k)+x(k+1))/2+dy/2 dx 0])
    end
   end
   ht = findobj(HFIG,'tag','nbi_ff');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(end)-dy+2 dx 2.5*dy])
   end
   tmp = tmp+dx+2;
%
   dx = 45;
   dy = 20;
   hc = findobj(HFIG,'tag','nbi_rtc_on');
   if ~isempty(hc)
    for k=1:length(hc)
     set(hc(k),'units','pixel','position',[tmp+2 (x(k)+x(k+1))/2-dy/2 dx dy])
    end
   end
   dy = 15;
   ht = findobj(HFIG,'tag','nbi_rtc_t_on');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(end)-dy+2 dx 2.5*dy])
   end
   tmp = tmp+dx+2;
%
   dy = 20;
   hc = findobj(HFIG,'tag','nbi_rtc_off');
   if ~isempty(hc)
    for k=1:length(hc)
     set(hc(k),'units','pixel','position',[tmp+2 (x(k)+x(k+1))/2-dy/2 dx dy])
    end
   end
   dy = 15;
   ht = findobj(HFIG,'tag','nbi_rtc_t_off');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(end)-dy+2 dx 2.5*dy])
   end
   tmp = tmp+dx+2;
%
   dx = 38;
   hc = findobj(HFIG,'tag','nbi_species');
   if ~isempty(hc)
    for k=1:length(hc)
     set(hc(k),'units','pixel','position',[tmp+2 (x(k)+x(k+1))/2-dy/2 dx dy])
    end
   end
   ht = findobj(HFIG,'tag','nbi_gas');
   if ~isempty(ht)
    set(ht,'units','pixel','position',[tmp+2 x(end)-dy+2 dx 2.5*dy])
   end
%
   tmp = get(HFIG,'position');
   dx = 90;
   dy = 25;
   hc = findobj(HFIG,'tag','nbi_enable_all');
   if ~isempty(hc)
    set(hc,'units','pixel','position',[tmp(3)-dx-4 8+dy dx dy])
   end
   hc = findobj(HFIG,'tag','nbi_disable_all');
   if ~isempty(hc)
    set(hc,'units','pixel','position',[tmp(3)-dx-4 4 dx dy])
   end

  case 'full'
   if FULL
     FULL = false;
     value = 'off';
   else
     FULL = true;
     value = 'on';
   end
   set(findobj(HFIG,'label','View full traces'),'Checked',value);
   enmac('pretty');
   
  case 'pretty'
   x1 = Inf; x2 = -Inf;
   for h = findobj(HFIG,'type','line')'
    x = get(h,'xdata');
    if ~isempty(x), x1 = min(x1,x(1)); x2 = max(x2,x(end)); end
   end
   test = ~isempty(strfind(lower(PAN(KPAN).label),'gas')) || ...
     ~isempty(strfind(lower(PAN(KPAN).label),'piezo')) || ...
     ~isempty(strfind(lower(PAN(KPAN).label),'nbi'));
   if test && ~FULL
     x1 = max(-0.3,x1);
   end
   set(findobj(HFIG,'type','axes'),'xlim',sort([x1 x2] + [-1 1]*(x2-x1)/20))
   for h = findobj(HFIG,'type','line')'
    x = get(h,'ydata'); x1 = min(x); x2 = max(x);
    try set(get(h,'parent'),'ylim',sort([x1 x2] + [-1 1]*(x2-x1)/20)), end
   end
   
  case 'move'
   [x,y,k,p,h,w] = knotsel(ax,0,0);
   if isempty(k), return, end
   if nargin > 1, p = varargin{1}; end
   [xx,yy] = snap(x,y,k,p,w,1);
   if strcmp(get(findobj(HFIG,'tag','vlock'),'checked'),'off'), x(k) = xx; end
   if strcmp(get(findobj(HFIG,'tag','hlock'),'checked'),'off'), y(k) = yy; end
   set(h,'xdata',x,'ydata',y,'color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4])
   knotsel(ax,0,0);
   enmac pretty
   
  case 'new'
   [x,y,~,p,h,w] = knotsel(ax,0,0);
   if isempty(x) || p(1) < x(1)
    k = 0;
   else
    k = min(max([find(max(p(1)-x,0)) 1]),length(x));
   end
   [xx,yy] = snap(x,y,k,p,w,0);
   x = [x(1:k) xx x(k+1:end)];
   y = [y(1:k) yy y(k+1:end)];
   set(h,'xdata',x,'ydata',y,'color',[1 0.4 0.4],'markerfacecolor',[1 0.4 0.4])
   w.sel = k+1;
   set(ax,'UserData',w)
   knotsel(ax,0,1);
   enmac pretty

 end
end
set(HFIG,'Handlevisibility',figvis)

function [x,y,k,p,h,w] = knotsel(ax,sel,ptr)
p = get(ax,'currentpoint'); p = p(1,1:2);
h = findobj(ax,'type','line','tag','wave');
x = get(h,'xdata'); y = get(h,'ydata');
w = get(ax,'UserData');
if sel
 [~,k] = min(abs(x-p(1)));
 w.sel = k;
 set(ax,'UserData',w)
else
 k = w.sel;
end
if ptr, try set(0,'pointerlocation',ap2rp(ax,[x(k) y(k)])), end, end
fig = get(ax,'Parent');
set(findobj(fig,'tag','txtw'),'string',w.name)
set(findobj(fig,'tag','txtx'),'string',num2str(x(k)))
set(findobj(fig,'tag','txty'),'string',num2str(y(k)))
delete(findobj(fig,'type','line','tag','sel'))
line(x(k),y(k),'marker','s','color','w','markerfacecolor','w','tag','sel','Parent',ax)

function [xx,yy] = snap(x,~,k,p,w,dk)
lim = w.lim;
if k-dk >= 1,         lim(1) = x(k-dk)+w.delta(1); end
if k    <  length(x), lim(2) = x(k+1) -w.delta(1); end
if lim(1) > lim(2) || lim(3) > lim(4)
 xx = []; yy = [];
else
 if ~isnan(w.delta(1)), p(1) = round(p(1)/w.delta(1))*w.delta(1); end
 if ~isnan(w.delta(2)), p(2) = round(p(2)/w.delta(2))*w.delta(2); end
 xx = min(max(p(1),lim(1)),lim(2));
 yy = min(max(p(2),lim(3)),lim(4));
end

function pr = ap2rp(ax,pa)
ap = get(ax,'position');
fig = get(ax,'Parent');
fp = get(fig,'position');
xl = get(ax,'xlim'); yl = get(ax,'ylim');
pr = round((pa - [xl(1) yl(1)]) ./ [xl(2)-xl(1) yl(2)-yl(1)] .* ap(3:4) + ap(1:2) + fp(1:2) - [1 2]);

function checkdelete(fig)
% Check if this figure is still valid.
if isscalar(fig) && ishghandle(fig) && ~strcmpi(get(fig,'BeingDeleted'),'on')
  % And close it
  delete(fig);
end

function h = mgpopupmenu(parent,type,label,callback,color,varargin)
% Popup menu
%   Label should be a cell array
%   First label is always the "none of the above" case
%   Additional (or overriding) property-value pairs can be passed by varargin

menucolor={[1 0.6 0.2];[1 0.4 0.4]};
h = uicontrol('Parent',parent,'Style','PopUpMenu','Units','Pixel', ...
               'String',label,'FontSize',9, ...
               'HorizontalAlignment','Left','Callback',callback, ...
               'Tag',type,'BackgroundColor',menucolor{color},varargin{:});

function h = mgcheckbox(parent,type,callback,color,varargin)
% Checkbox
%   Additional (or overriding) property-value pairs can be passed by varargin

checkboxcolor={[1 1 1]*.5;[1 0.4 0.4]};
h = uicontrol('Parent',parent,'Style','Checkbox','Units','Pixel', ...
              'FontSize',9,'HorizontalAlignment','Center','Callback',callback, ...
              'Tag',type,'BackgroundColor',checkboxcolor{color},varargin{:});

function h = mgpushbutton(parent,type,callback,color,varargin)
% Checkbox
%   Additional (or overriding) property-value pairs can be passed by varargin

buttoncolor={[0 0.8 1];[1 0.4 0.4]};
h = uicontrol('Parent',parent,'Style','pushbutton','Units','Pixel', ...
              'FontSize',9,'HorizontalAlignment','Center','Callback',callback, ...
              'Tag',type,'BackgroundColor',buttoncolor{color},varargin{:});

function h = mgedit(parent,type,callback,color,varargin)
% Editable text
%   Additional (or overriding) property-value pairs can be passed by varargin

editcolor={[1. 1. 1.];[1 0.4 0.4]};
h = uicontrol('Parent',parent,'Style','Edit','Units','Pixel', ...
               'FontSize',12,'HorizontalAlignment','Left','Callback',callback, ...
               'Tag',type,'BackgroundColor',editcolor{color},varargin{:});

function h = mgtext(parent,type,static_text,color,varargin)
% Static text
%   Additional (or overriding) property-value pairs can be passed by varargin

textcolor={[0.4 0.9 0.6];[1 0.4 0.4];[.75 .75 .75];[.6 1.0 .4];[0 0.8 1]};
h = uicontrol('Parent',parent,'Style','text','Units','Pixel', ...
              'String',static_text,'FontSize',12, ...
              'HorizontalAlignment','Center', ...
              'Tag',type,'BackgroundColor',textcolor{color},varargin{:});

% message display: mgamsmsge(msge,level)
function mgamsmsge(msge,level)
global H
x = rem(round(clock),100);
x = sprintf('%02d.%02d.%02d %02d:%02d:%02d',x([3 2 1 4 5 6]));
if nargin == 1
 set(H.msge,'string',{x,msge},'foreground',[0 .5 0])
elseif level == 'f'
 set(H.msge,'string',{x,msge},'foreground','r'), fprintf('\7')
else
 set(H.msge,'string',{x,msge},'foreground','y')
end
drawnow
fprintf('\r%s\t%s\n',x,msge);
