function dWpdFx = vizrJac(Fx,Opy,iry,drx,dzx)
% function dWpdFx = vizrJac(Fx,Opy,iry,drx,dzx, L)
% Computes dWp dFx Jacobian. Takes some inputs of vizrmex
% Arguments:
%   Fx:   matrix, Flux on x grid
%   Opy:  matrix of uint, plasma domain indicators
%   iry:  vector, inverse of r values on y grid (z direction is omitted)
%   drx:  float, r step size on x grid
%   dzx:  float, z step size on x grid
% returns:
%   dWp_dFx: Matrix, Jacobian of Wp w.r.t. Fx
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Compute flux gradient on y grid
dFdr = (Fx(2:end-1,3:end) - Fx(2:end-1,1:end-2))/(2*drx);
dFdz = (Fx(3:end,2:end-1) - Fx(1:end-2,2:end-1))/(2*dzx);

Opy = (Opy>0);
dFdr = dFdr .* Opy .* iry' ./ drx;
dFdz = dFdz .* Opy .* iry' ./ dzx;

dWpdFx = zeros(size(Fx));
dWpdFx(2:end-1, 3:end  ) =                            dFdr;
dWpdFx(2:end-1, 1:end-2) = dWpdFx(2:end-1, 1:end-2) - dFdr;
dWpdFx(3:end  , 2:end-1) = dWpdFx(3:end  , 2:end-1) + dFdz;
dWpdFx(1:end-2, 2:end-1) = dWpdFx(1:end-2, 2:end-1) - dFdz;

dWpdFx = drx*dzx/(4*pi*4e-7*pi) * reshape(dWpdFx,1,numel(Fx));

end
