% Test collection for Octave
%
%   Only basic tests to ensure that no MATLAB-specific feature is used
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Check paths assuming this is run from the toolbox base directory
%!shared tbxpath
%! tbxpath=pwd;
%!test
%! assert(which('bspsum'), fullfile(tbxpath,'genlib',['bspsum.',mexext]))
%! assert(which('asxymex'), fullfile(tbxpath,['asxymex.',mexext]))

% Integration tests from tests/anamak_all_code_test.m
%!function [LYfbt,LYfgs,LYliut_ref,LXliut,LYliut] = anamak_all_code(shot,usecs,verbose,fbt_fgs_only)
%!  tok = 'ana';
%!  iterq = 50;
%!  tol = 3e-5;
%!
%!  dt = 2.5e-5;
%!  t = 0:dt:1e-3;
%!  fprintf('** Find initial FBT solution **\n')
%!
%!  if usecs, csargs = {'icsint',true,'ilim',3};
%!  else,     csargs = {'icsint',false};end
%!
%!  [Lfbt,LXfbt] = fbt(tok,shot,[],...
%!    'debug',verbose,'iterq',iterq,'tol',tol,...
%!    csargs{:});
%!
%!  if verbose
%!    meqgplot(Lfbt.G); drawnow; % plot geometry
%!  end
%!
%!  % Solve FBT
%!  LYfbt = fbtt(Lfbt,LXfbt);
%!  assert(~isempty(LYfbt),'FBT returned empty structure');
%!
%!  %% Use this as starting point for FGS
%!  fprintf('** FGS forward equilibrium from FBT **\n')
%!
%!  [Lfgs] = fgs(tok,shot,t(1),'debug',verbose,...
%!    'iterq',iterq,csargs{:});
%!  LXfgs = meqxconvert(Lfbt,LYfbt,Lfgs);
%!  LYfgs = fgst(Lfgs,LXfgs);
%!
%!  % Compare
%!  if verbose
%!    clf; meqplotQ(Lfgs,LYfbt,LYfgs); drawnow;
%!  end
%!
%!  if fbt_fgs_only, return; end
%!
%!  %% And then evolve using FGE...
%!  fprintf('** Evolve using FGE forward equilibrium evolution **\n')
%!
%!  [Lfge,LXfge] = fge(tok,shot,t,'usepreconditioner',1,...
%!    'debug',verbose,'izgrid',(verbose>0),...
%!    'iterq',iterq,csargs{:});
%!
%!  % run time evolution without control
%!  LYfge = fget(Lfge,LXfge);
%!     
%!  if verbose
%!    clf;
%!    meqmovie(Lfge,LYfge,'decimate',5);
%!  end
%!
%!  %% Do time-varying equil. reconstruction using LIUQE for uncontrolled case
%!  fprintf('** LIUQE reconstruction **\n')
%!
%!  Lliu = liu(tok,shot,t,'pQ',Lfbt.pQ,'Fterr',1e-4,...
%!    'debug',verbose,'psichco',1e-6,csargs{:});
%!  it =1:10:numel(LYfge.t); % select time slices where to do reconstruction
%!  LYliut_ref = meqxk(LYfge,it);
%!  LXliut = liux(Lliu,meqxconvert(Lfge,LYliut_ref,Lliu,true));
%!
%!  % Deselect some sensors
%!  wBm = ones(Lliu.G.nm,1);wBm(5) = 0;
%!  wFf = ones(Lliu.G.nf,1);wFf(11) = 0;
%!
%!  LYliut = liut(Lliu,LXliut,'debug',verbose,...
%!    'wBm',wBm,'wFf',wFf);
%!  assert(~isempty(LYliut),'LIUQE did not find any equilibrium')
%!  nt = numel(LYliut.t);
%!
%!  if verbose
%!    meqplotQ(Lliu,meqxk(LYliut,nt),meqxk(LYfge,nt))
%!  end
%!endfunction

%!test 
%! verbose = 0;
%! fbt_fgs_only = false;
%! for shot = [1,2,11] % circular, diverted, elongated
%!   % Only test with cubic spline for shot 1
%!   if shot == 1
%!     usecs_ = [false,true];
%!   else
%!     usecs_ = false;
%!   end
%!   for usecs = usecs_
%!     fprintf('\nTesting FBT->FGS->FGE->LIU ana/shot=%d with usecs=%d\n',shot,usecs);
%!     [LYfbt,LYfgs,LYliut_ref,LXliut,LYliut] = anamak_all_code(shot,usecs,verbose,fbt_fgs_only); 
%!     % Compare
%!     % Octave conventions for assert, tol>0 -> absolute tolerance
%!     %                                tol<0 -> relative tolerance
%!     %   Compare FBT and FGS:
%!     %     main difference is due to tol~3e-5 in FBT leading to poor GS solution
%!     reltol = 1e-4;
%!     assert(LYfbt.FB,LYfgs.FB,reltol)
%!     assert(LYfbt.rA,LYfgs.rA,reltol)
%!     assert(LYfbt.zA,LYfgs.zA,reltol*LYfbt.rA)
%!
%!     %   Compare LIU and FGE
%!     %     main difference is again due to quality of GS solution in LIU
%!     reltol = 2e-3; % tight tolerances: should be close to equal
%!     assert(LYliut.FB,LYliut_ref.FB,-reltol)
%!     assert(LYliut.rA,LYliut_ref.rA,-reltol)
%!     assert(LYliut.zA,LYliut_ref.zA,reltol*LYfbt.rA)
%!
%!     assert(LYliut.Bm,LXliut.Bm,5*reltol*max(abs(LXliut.Bm(:))))
%!     assert(LYliut.Ff,LXliut.Ff,5*reltol*max(abs(LXliut.Ff(:))))
%!   end
%! end

%!test 
%! verbose = 0;
%! usecs = false;
%! fbt_fgs_only = true;
%! for shot = [81,82] % droplets, doublet
%!   fprintf('\nTesting FBT->FGS ana/shot=%d with usecs=%d\n',shot,usecs);
%!   [LYfbt,LYfgs] = anamak_all_code(shot,usecs,verbose,fbt_fgs_only);
%!   % Compare
%!   % Octave conventions for assert, tol>0 -> absolute tolerance
%!   %                                tol<0 -> relative tolerance
%!   %   Compare FBT and FGS:
%!   %     main difference is due to tol~3e-5 in FBT leading to poor GS solution
%!   reltol = 2e-4; % Same tolerance as FGS solver
%!   assert(LYfbt.FB,LYfgs.FB,reltol)
%!   assert(LYfbt.rA,LYfgs.rA,reltol)
%!   assert(LYfbt.zA,LYfgs.zA,reltol*LYfbt.rA)
%! end
