function tests_octave(test_file, paths, packages)
% Auxiliary file used to run genlib test suite for Octave from the shell
% Called by test_script.sh
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

try
  fprintf('\n Running test file: %s\n',mfilename('fullpath'));
  fprintf('     Time: %s\n',datestr(now));

  if nargin<1
    error('tests_octave should be called with at least one argument');
  end

  if nargin<2
    tbxpath=fileparts(mfilename('fullpath'));
    % Add meq, meq/genlib and meq/_octave
    paths={tbxpath,fullfile(tbxpath,'genlib'),fullfile(tbxpath,'_octave')};
  end

  if nargin<3
    packages={};
  end

  % Set up paths
  paths = cellstr(paths);
  for ii = 1:numel(paths)
    addpath(paths{ii});
  end

  % Set up packages
  packages = cellstr(packages);
  for ii = 1:numel(packages)
    pkg('load',packages{ii})
  end

  log_fname = 'octave_error_log';
  passed = test(test_file,'quiet','octave_error_log'); % call to your test script here, with optional test_case input
  exit_code = int32(~passed); % convert to bash shell convention
catch ME
  disp(getReport(ME))
  exit_code = int32(1);
end

if exist('log_fname','var') && exist(log_fname,'file')
  fprintf('\nOctave test error log:\n');
  type(log_fname);
  delete(log_fname);
end

exit(exit_code);
