classdef resp_test < meq_test
  % extremely simple test for resp
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    A,B,C,D
    tol
  end
  properties(ClassSetupParameter)
    type = {'single','double'};
  end
  
  methods(TestClassSetup)
    function setup_ABCD(testCase,type)
      no = 4; 
      na = 3;
      nb = 6;
      nc = 8;
      nd = 10;
      testCase.A = cast(rand(no,na),type);
      testCase.B = cast(rand(na,nb),type);
      testCase.C = cast(rand(no,nc),type);
      testCase.D = cast(rand(nc,nd),type);
      
      testCase.tol = sqrt(eps(type));
    end
  end
  
  methods (Test,TestTags={'Unit'})
    function test_resp(testCase)
      % Matlab calculation
      ABCD = [testCase.A*testCase.B testCase.C*testCase.D];

      % Mex calculation
      testCase.verifyEqual(respmex(testCase.A,testCase.B,testCase.C,testCase.D),...
        ABCD,...
        'AbsTol',testCase.tol)
    end
    
  end
end

