classdef q95_test < meq_test
  % tests of q95 calculation
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  methods(Test,TestTags={'Unit'})
    function test_q95_interp(testCase)
      % Verify linear interpolation to rho=sqrt(0.95)
      
      L = liu('ana',1,[]);
      
      % Verify interpolation of rho profile gives exact value.
      testCase.verifyEqual(L.c95*(L.pQ(L.i95)).',sqrt(0.95),'Cannot recover expected value when interpolating to rho=sqrt(0.95)')
    end
  end
end
