classdef meqfbp_test < meq_test
  % Test for evaluation of boundary flux using Lackner's trick
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    verbosity = 1;
    % parameters for dummy test equilibrium
    Iy;
    L;
  end
  
  methods(TestClassSetup)
    
    function setup_Jy(testCase)
      %#ok<*PROP>
     
      testCase.L = liu('ana',0,0);
      % put a current in the chamger
      P = testCase.L.P;
      R0 = P.r0; Z0 = 0;
      a0 = P.al*0.9;
      ry = testCase.L.ry; zy = testCase.L.zy;
      Imax = 1e4;
      testCase.Iy = ...
        max(((-(ry'-R0).^2 + -(zy-Z0).^2)/a0^2 + 1 )*Imax,0); % Dummy flux map
    
      if testCase.verbosity
        imagesc(ry,zy,testCase.Iy); hold on;
        meqgplot(testCase.L.G); axis equal tight
      end
    end
  end
  
  methods(Test,TestTags = {'Unit'})
    function test_gszr_dlst(testCase)
      Iy = testCase.Iy;
      L = testCase.L;
      
      %% Get boundary flux for this Iy
      Fb = meqfbp(Iy,L); % using Lackner's trick

      Fb2 = L.G.Mby*Iy(:); % Same using direct Green's functions
      
      testCase.assertEqual(Fb,Fb2,'RelTol',2e-2)
    end
  end
  
end
