classdef meq_solver_test < meq_test
  % Superclass for tests of functions in solver directory
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    A_
    b_
    m_
    Pinv_
    tol_ = 1e-12;
  end

  properties(ClassSetupParameter)
    variant = {'simple','zero','handle','prec','prec_handle'}
  end

  properties(Abstract,ClassSetupParameter)
    nb
  end

  methods (TestClassSetup)
    function setup(testCase,variant,nb)
      % Generate a linear function and RHS to test linear solvers

      n = 300;
      A = rand(n,n );
      b = rand(n,nb);
      m = n/nb;
      Pinv = [];

      % Variant
      switch variant
        case 'simple'
        case 'zero'
          b = zeros(n,nb);
        case 'handle'
          A = @(x) A*x;
        case 'prec'
          Pinv = 1;
        case 'prec_handle'
          Pinv = @(x) x;
      end

      testCase.A_    = A;
      testCase.b_    = b;
      testCase.m_    = m;
      testCase.Pinv_ = Pinv;
    end
  end

  methods
    function check_result(testCase,x)
      % Verify x is solution of A*x=b

      A    = testCase.A_;
      b    = testCase.b_;
      tol  = testCase.tol_;

      if isa(A,'function_handle')
        res = zeros(size(b));
        for ii = 1:size(res,2)
          res(:,ii) = A(x(:,ii))-b(:,ii);
        end
      else
        res = A*x-b;
      end
      testCase.verifyEqual(res,zeros(size(b)),'AbsTol',10*tol);
    end
  end
end
