classdef liuptcv_test < meq_test
  % tests for LIUQE parameter retrieval for TCV
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  methods(TestClassSetup)
    function connect_to_tcvdata(testCase)
      server = meqmdsserver();
      status = mdsconnect(server);
      testCase.assertTrue(isodd(status),'mdsconnect to tcvdata.epfl.ch failed');
    end
  end
  
  methods(Test, TestTags = {'TCV'})
    function test_liuptcv_default(testCase)
      % Compares parameter values for LIUQE in the results model tree and
      % those in liuptcv_default
      
      Pmodel   = liuptcv(-1,'psrc','LIUQE.M');
      Pdefault = liuptcv([],'psrc','default');
      
      testCase.verifyTrue(structcmp(rmfield(Pmodel  ,{'psrc','wBm','shot'}),...
                                    rmfield(Pdefault,{'psrc','wBm'       }),...
                                    eps('single')),...
                          'LIUQE parameters stored in the model tree do not match the defaults from liuptcv');
    end
  end
  
end
