classdef liuanasrv_test < meq_test
  % tests for automated LIU runs for TCV including storage to MDSplus
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties (TestParameter)
    shot = {55555};
    analysis = {'thomson','fast'};
  end

  methods(Test, TestTags = {'TCV'})
    function test_liuanasrv(testCase,shot,analysis)
      % Runs liuanasrv

      % Check that TCV tools are available
      testCase.check_tok('tcv');

      % Setup temporary MDSplus storage
      testCase.applyFixture(tcv_temp_tree_fixture('results',shot));

      % Disable DML fitting for this run if the dml toolbox is not available
      if isempty(which('dmlbo'))
        mdsopen('results',shot);
        mdsput('\results::equil_param:idml',int32(0));
      end
      % Run liuanasrv
      liuanasrv(shot,[],analysis);
    end
  end
  
end
