classdef liu_jBwreg_test < meq_test
  % Test for current profile regularization in J
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties (TestParameter)
    shot = struct('diverted',2);
    time = {0};
  end
  
  methods(Test, TestTags = {'Unit'})
    function increasing_jBwreg(testCase,shot,time)
      % Check that edge current regularisation is working
      jB_wreg = [1e0,1e2,1e4];

      wreg_ = NaN;
      jB_ = Inf;
      
      % Generate some synthetic measurements using standard bf set
      [~,LX] = liu('ana',shot,time);
      
      for ii = 1:numel(jB_wreg)
        % Use bfef for reconstruction with regularisation
        L = liu('ana',shot,time,'bfct',@bfefmex,'bfp',[2;3],'wreg',5e-8*[1;jB_wreg(ii)*[1;1]]);
        LX.ag = zeros(L.ng,1); % ng has changed (but LX.ag isn't used anyway)
        LY = liut(L,LX);
        testCase.assertTrue(meq_test.check_convergence(L,LX.t,LY),sprintf('LIUQE did not converge for wreg_jB=%e',jB_wreg(ii)));
        
        [ fPg,  fTg] = L.bfct(0,L.bfp);
        [ gQg,    ~] = L.bfct(2,L.bfp,1,LY.FA,LY.FB);
        [aPpg,aTTpg] = L.bfct(3,L.bfp,LY.ag,LY.FA,LY.FB,fPg,fTg,L.idsx);
        jB = gQg .* aPpg' * fPg * LY.rA + gQg .* aTTpg.' * fTg /LY.rA /mu0; % Current density at psiN=1 for r=rA
        % Check that it did decrease after we increased wreg
        testCase.verifyLessThan(abs(jB),abs(jB_),sprintf('Edge current did not decrease between wreg_jB=%e (%e) and %e (%e)\n\t ',wreg_,jB_,jB_wreg(ii),jB));
        
        wreg_ = jB_wreg(ii);
        jB_ = jB;
      end
    end
  end
end
  
