classdef jacfd_test < meq_test
  % Test of Generic finite difference jacobian evaluation
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    paravail
  end

  properties (TestParameter)
    workers = {1,2}; % Enables testing of parfor block
  end

  methods (TestClassSetup)
    function setupParallelPool(testCase)

      % check if parallel toolbox is installed, parallel replaced distcomp since R2019b
      testCase.paravail = ~isempty(ver('parallel')) || ~isempty(ver('distcomp')); %#ok<DCRENAME>

      if testCase.paravail && isempty(gcp('nocreate'))
        % If no pool is already available, delete the created one at the end of these tests
        testCase.addTeardown(@() delete(gcp('nocreate')));
      end
    end
  end

  methods (Test, TestTags={'Unit'})
    function test_jacfd_pertgroups(testCase,workers)
      % Test pertgroups option of jacfd function
      testCase.assumeTrue(workers == 1 || testCase.paravail, 'Skipping parallel tests since parallel toolbox was not found');

      n = 201;
      x = linspace(0,2*pi,n).';
      f = @sin;

      % Compute analytical jacobian
      J = cos(x);

      % Compute full numerical jacobian
      J_fd_ = jacfd(f,{x},'szF0',{n},'workers',workers);
      testCase.verifySize(J_fd_,[n,n]);

      % Compute numerical jacobian perturbing all x values at once
      J_fd = jacfd(f,{x},'szF0',{n},'pertgroups',{1:n});
      testCase.verifySize(J_fd,[n,1]);

      testCase.verifyEqual(J_fd,J,'AbsTol',sqrt(eps),'Analytical and numerical jacobians do not match');
      testCase.verifyEqual(diag(J_fd_),J_fd,'diagonal of full jacobian does not match reduced jacobian');

    end
  end

end
