classdef ilackner_test < meq_test
  % Test to ensure that the ilackner option leads to similar results
  % in the inversion of the GS operator meqFx
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    LX;
    Fx;
    machine;
    shot;
    verbosity = 0;
  end
  
  properties(TestParameter)
    lackner_option = {'0', '2'};
  end
  
  properties (ClassSetupParameter)
    machines = {'ana'};
    shots = {'1', '2', '3', '5', '82'};
  end
  
  methods(TestClassSetup)
    function testSetup(testCase, machines, shots)
      [L, testCase.LX] = fgs(machines, str2double(shots), 0, 'ilackner', 1);
      Ie = [testCase.LX.Ia; testCase.LX.Iu];
      testCase.Fx = meqFx(L, testCase.LX.Iy, Ie);
      testCase.machine = machines;
      testCase.shot = shots;
    end
  end
  
  methods(Test,TestTags={'Unit'})
    
    function test_meqFx_with_lackner_options(testCase, lackner_option)
      Iy = testCase.LX.Iy;
      Ie = [testCase.LX.Ia; testCase.LX.Iu];
      Fx_baseline = testCase.Fx;
      
      L = fgs(testCase.machine, str2double(testCase.shot), 0, 'ilackner', str2double(lackner_option));
      
      Fx_test = meqFx(L, Iy, Ie);
      testCase.verifyEqual(Fx_baseline, Fx_test, 'AbsTol', 5e-3);
    end
    
  end
end
