classdef gmres_block_test < meq_solver_test
  % Test the Block-GMRES algorithm
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties(ClassSetupParameter)
    nb = {20}
  end

  properties (TestParameter)
    algoGMRES = {'sim','giv','qr'}
  end

  methods (Test, TestTags = {'Unit'})
    function test_gmres_block(testCase,algoGMRES)
      % Test Block-GMRES algorithm
      
      A    = testCase.A_;
      b    = testCase.b_;
      m    = testCase.m_;
      tol  = testCase.tol_;
      Pinv = testCase.Pinv_;

      x = gmres_block(A,b,algoGMRES,tol,m,Pinv);

      % Check result
      testCase.check_result(x);
    end
  end
end