classdef fgs_fge_tcv_jacobian_test < meq_jacobian_test
  % Tests of Forward-Grad-Shafranov solvers FGS and FGE with analytical
  % Jacobian on TCV shots
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    tok = 'tcv';
    verbosity = 0;
    agcon = {'Ip','bp','qA'};
  end

  properties(ClassSetupParameter)
    codes = {'fgs','fge'};
  end
  
  properties(TestParameter)
    shot = struct('diverted',         61400,'limited',         65000,'snowflake',       65270);
    t    = struct('diverted',  0.4:0.05:0.7,'limited',    1:0.05:1.3,'snowflake',0.4:0.05:0.7);
  end

  methods(TestClassSetup)
    function setup_code(testCase,codes)
      testCase.code = codes;
    end
  end
  
  methods(Test,TestTags={'Jacobian-Integration'},ParameterCombination='sequential')
    
    function test_code_jacobian_tcv(testCase,shot,t)

      [ok,msg] = meq_test.check_tok(testCase.tok,shot);
      testCase.assumeTrue(ok,msg);

      if testCase.verbosity
        fprintf('Testing %s for TCV shot:%d t1=%f\n',upper(testCase.code),shot,t(1));
      end
      
      % Setup with newton and analytical jacobian
      [L,LX] = get_L_LX(testCase,shot,t,'algoF','newton');
      % Test solver with GMRES-aya method - check for convergence
      LY = get_LY(testCase,L,LX);

      % Check run was successful
      testCase.verifyTrue(meq_test.check_convergence(L,LX.t,LY),sprintf('shot %s did not converge',shot));
    end
    
  end
end
