classdef fgs_fge_sparse_jacobian_test < meq_jacobian_test
  % Tests FGS and FGE using sparse Jacobian
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    tok = 'ana';
    t = 0:5e-3:1e-2;
    verbosity = 0;
    agcon = {'bp','li','qA'};
  end

  properties(TestParameter)
    codes = {'fgs','fge'};
    shot  = struct('diverted',2,'double_null',4,'squashed',5,'doublet',82);
  end

  methods(Test,TestTags={'Jacobian-Integration'})
    function Newton_GS_sparse_jacobian_test(testCase,codes,shot)
      % Compare run with full or sparse jacobian

      testCase.code = codes;
      testCase.algoGMRES = 'aya';

      PP = {'algoNL','Newton-GS','algoF','newton','selu','e','nu',30};

      % Run case with full jacobian
      [L,LX] = get_L_LX(testCase,shot,testCase.t,PP{:},'jacobian_sparse',false);
      LY = get_LY(testCase,L,LX);

      % Verify run succeeded
      testCase.verifyTrue(meq_test.check_convergence(L,LX.t,LY),sprintf('shot %d did not converge with full jacobian',shot));

      % Run case with sparse jacobian
      LS = get_L_LX(testCase,shot,testCase.t,PP{:},'jacobian_sparse',true);
      % Reuse same initial condition
      LYS = get_LY(testCase,LS,LX);

      % Verify run succeeded
      testCase.verifyTrue(meq_test.check_convergence(LS,LX.t,LYS),sprintf('shot %d did not converge with sparse jacobian',shot));

      % Compare results
      %  Excluding Bmdot, Ffdot, Iu and Iv from comparison since these are very small for these cases
      testCase.verifyTrue(structcmp(LYS,LY,10*L.P.tolF,{'res','resy','resFx','resC','resp','rese','Bmdot','Ffdot','Iu','Iv'}),'Runs with full and sparse jacobians do not agree')
    end
  end

end
