classdef fge_inactive_domains_test < meq_test
  % Tests for treatment of inactive domains in FGE
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties(TestParameter)
    cdetype = {'','cde_ss_0D','OhmTor_0D','OhmTor_rigid_0D','cde_1D','cde_OhmTor_1D','static_cde_1D','static_Iy_1D'};
  end
  

  methods(Test,TestTags={'fge'})
    function test_fgs_inactive_domains(testCase)
      % Run droplet case with non-ag constraints in inactive mantle
      agcon = {{'Ip','bp','qA'},{'Ip','bp','qA'},{'Ip','Wk','ag'}};
      [L,LX] = fgs('ana',81,[],'agcon',agcon);
      LY = fgst(L,LX);

      testCase.verifyTrue(LY.isconverged,'FGS did not converge with inactive domains');
    end

    function test_fge_inactive_domains(testCase, cdetype)
      % Run droplet case with non-ag constraints and cde in inactive mantle
      if isempty(cdetype)
        agcon = {'Ip', 'bp', 'qA'};
      elseif endsWith(cdetype, '0D')
        agcon = {{'bp','qA'},{'bp','qA'},{'Wk','ag'}};
      elseif endsWith(cdetype, '1D')
        % only one degree of freedom controlled by 1D cde to help with convergence
        agcon = {'bp','ag'};
      end
      [L,LX] = fge('ana',81,1e-4*(0:10),'agcon',agcon,'cde',cdetype);
      LY = fget(L,LX);

      testCase.verifyTrue(all(LY.isconverged),'FGE did not converge with inactive domains');
    end
    
  end
end