classdef dlst_test < meq_test
  % Test for evaluation of delta-star operator
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    verbosity = 0;
    % parameters for dummy test equilibrium
    R0 = 1;
    
    Iy;
    L;
  end
  
  properties(ClassSetupParameter)
    enz = {4,6}; % Using values of 7 and above can lead to high memory usage for certain tasks
  end
  
  methods(TestClassSetup)
    
    function setup_Jy(testCase,enz)
      %#ok<*PROP,*PROPLC>
      
      nz = 2^enz + 1;
      nr = nz-1;
      R0 = testCase.R0;
      Z0 = 0;
      FA = 0;
      FB = 1;
      rBt = 1.4;
      L = liu('ana',1,0,'nz',(nz-1)/2,'nr',nr);
      [L,LY] = testCase.getCircularEquilibrium(L,R0,Z0,FA,FB,rBt);
      
      % dlst specifics
      L.dlst = dlstc(L.nzx,L.nrx,L.drx,L.dzx,L.rry);
      L.frhs = -2*pi*(4e-7*pi)*(L.dzx)^2*(L.idrx*L.idzx) * L.rry;
      
      testCase.Iy = LY.Iy;
      testCase.L = L;
      
    end
  end
  
  methods(Test,TestTags = {'Unit'})
    function test_gszr_dlst(testCase)
      Iy = testCase.Iy;
      L = testCase.L;
      % Solve Poisson problem to find Fx for given Jy
      Fb = zeros(2*(L.nzx+L.nrx-2),1);
      Fx = gszrmex(Fb,Iy,L.cx,L.cq,L.cr,L.cs,L.ci,L.co,0);
      
      % Del-star(psi) (LHS of GS equation)
      LF = reshape(L.dlst * Fx(:), L.nzy, L.nry);
      
      % RHS of GS equation
      rhs  = L.frhs.*Iy; % RHS of GS equation
      
      % Compare
      testCase.assertEqual(LF,rhs,'AbsTol',sqrt(eps))
    end
  end
  
end
