classdef (SharedTestFixtures={mexm_fixture}) cizr_test < meq_test
  % Tests for surface and volume integrals
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    tol = 1e-4;
    data
  end

  properties (ClassSetupParameter)
    type = {'SND',...
            'DND',...
            'Lim',...
            'Lim-X',...           % limited with a non-limiting X-point
            'Boundary-X',...      % X-point close to the computational boundary
            'Double-Snowflake-Minus',...
            'Double-Snowflake-Plus',...
            'Doublet',...
            'Droplet',...
            'Doublet-div-nomantle',...
            'Doublet-div',...
            'Triplet',...
            'Triplet-madness',...
           };
    sIp = struct('positive',1,'negative',-1);
  end
  
  properties (TestParameter)
    method = {'cizrmex','cizrmexm'};
  end
  
  methods(TestClassSetup)
    function meqintTestSetup(testCase,type,sIp)
      S = testCase.generate_flux_map(type,sIp);
      
      % Need an increased grid size for Triplet-madness resolution
      L = fgs('ana',0,0,'cappav',2,'nz',32,'nr',32);
      L.nD = S.ndom;
      
      Fx = S.Fxh(L.rrx,L.zzx);

      [~,~,~,~,~,~,~,~,~,~,~,~,...
        ~,~,~,~,~,Opy,F0,F1] = meqpdom(Fx,sIp,L.P.isaddl,L);
      
      testCase.data.type = type;
      testCase.data.S    = S;
      testCase.data.Fx   = Fx;
      testCase.data.Opy  = Opy;
      testCase.data.L    = L;
      testCase.data.F0   = F0;
      testCase.data.F1   = F1;
    end
  end
  
  methods (Test,TestTags={'Unit'})
    function test_cizr(testCase,method)
      % Verify that mex and mexm versions give correct answers

      L = testCase.data.L;
      
      Fx  = testCase.data.Fx;
      Opy = testCase.data.Opy;
      F0  = testCase.data.F0;
      F1  = testCase.data.F1;
      FQ  = testCase.data.L.pQ.^2;

      % Expected values
      OpQ_ = zeros(L.nQ,L.nD);
      VpQ_ = zeros(L.nQ,L.nD);
      Fy = Fx(2:end-1,2:end-1);
      idF = (F1-F0);
      idF(idF~=0) = 1./idF(idF~=0);
      for iD = 1:L.nD
        for iQ = 1:L.nQ
          OpQ_(iQ,iD) = sum(           (Opy(:) == iD) & ((Fy(:) - F0(iD))*idF(iD) <= FQ(iQ)) )*L.dsx;
          VpQ_(iQ,iD) = sum(L.rry(:).*((Opy(:) == iD) & ((Fy(:) - F0(iD))*idF(iD) <= FQ(iQ))))*L.dsx;
        end
      end

      % test vs mex/mexm
      IVQD = feval(method,Fx,Opy,[ones(L.ny,1),L.rry(:)],L.dsx,L.pQ.^2,F0,F1);
      OpQ = IVQD(:,:,1);
      VpQ = IVQD(:,:,2);
      
      % verify
      testCase.verifyEqual(OpQ,OpQ_,'RelTol',testCase.tol)
      testCase.verifyEqual(VpQ,VpQ_,'RelTol',testCase.tol)
      
    end
  end
end
