classdef bf_single_domain_jacobian_test < bf_jacobian_test
  % test the analytical jacobian of the single domain basis function sets
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.d
    
  properties(ClassSetupParameter)
    shot = struct('circular',1,'diverted',2,'diverted2',3,...
      'squashed',5,'elongated',11);
  end
  
  properties (MethodSetupParameter)
    bfct = {'bfabmex','bfefmex','bf3pmex',                                     'bfsp',                   'bffbt', 'bf3imex'};
    bfp  = {    [3,3],    [4,4],    false,bfpsp(linspace(0,1,7),linspace(0,1,11),'n'),[1.1 .25 1.75 2.2 .75 2.5],bfp3imex()};
  end

end

%% Auxiliary functions
function bfp = bfp3imex()
% parameters for bf3imex test (direct specification of basis functions)
n=41;
FN = linspace(0,1,n)';
GN = [FN-1,FN-1,(FN-1).*FN];
IGN = bfprmex(GN);

FP = [1;0;0];
FT = [0;1;1];
bfp = struct('gNg',GN,'IgNg',IGN,'fPg',FP,'fTg',FT);
end
