classdef bf_fPg_fTg_tests < meq_test
  % Tests with custom values of fPg/fTg for basis functions
  %
  % See also bf_tests
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    bfp_
  end

  methods (TestClassSetup)
    function init_bf3i_parameters(testCase)
      % Initialize parameters for bf3i
      nN = 21;
      FN = linspace(0,1,nN).';
      gNg = [1-FN,FN.*(1-FN),ones(nN,1)];
      IgNg = bfprmex(gNg);
      fPg = [1;0;0];
      fTg = [0;1;1];

      bfp = struct('gNg',gNg,'IgNg',IgNg,'fPg',fPg,'fTg',fTg);
      testCase.bfp_ = bfp;
    end
  end

  methods (Test,TestTags={'Unit'})
    function test_unassigned_bf(testCase)
      % Check that unassigned bf (with fPg=fTg=0) does not produce current

      % Get dummy flux map
      r0 = 1;
      z0=0;
      rBt = 1;
      FA = 0;
      FB = 1;
      L = liu('ana',1);
      [L,LY] = testCase.getCircularEquilibrium(L,r0,z0,FA,FB,rBt);

      % Get parameters
      bfp = testCase.bfp_;
      bfp.fPg(3) = 0;
      bfp.fTg(3) = 0;

      [Tyg,TpDg,ITpDg] = bf3imex(1,bfp,LY.Fx,FA,FB,LY.Opy,L.ry,L.iry);

      % Check that outputs are zero for 3rd basis function
      testCase.verifyEqual( Tyg (:,3),zeros(L.ny,1),' Tyg  should be zero when fPg=fTg=0')
      testCase.verifyEqual( TpDg(:,3),            0,' TpDg should be zero when fPg=fTg=0')
      testCase.verifyEqual(ITpDg(:,3),            0,'ITpDg should be zero when fPg=fTg=0')
    end

    function test_pprime_and_ttprime_bf(testCase)
      % Check that fPg=fTg=1 is impossible
      bfp = testCase.bfp_;
      bfp.fPg(3) = 1;
      bfp.fTg(3) = 1;

      testCase.verifyError(@() liu('ana',1,[],'bfct',@bf3imex,'bfp',bfp),'MEQ:ParameterError');
    end
  end
end
