classdef (SharedTestFixtures={mexm_fixture}) bboxmex_test < meq_test
  % Tests for domain bounding box 
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    L
  end

  properties (TestParameter)
    method = {'bboxmex','bboxmexm'};
  end

  methods(TestClassSetup)    
    function setupLLY(testCase)
      testCase.L = fbt('ana',1,[],'pql',0.1);
    end
  end

  methods(Test,TestTags={'Unit'})
    % Test methods

    function test_bbox(testCase,method)
      % Verify that bbox gives the expected result

      L = testCase.L; %#ok<*PROPLC,*PROP> 
      
      %% Fake circular equilibrium
      r0 = 1.001; z0 = 0;
      FA = 1; FB = 0;
      rBt = 1;
      [L,LY] = testCase.getCircularEquilibrium(L,r0,z0,FA,FB,rBt);
      
      Opy = logical(LY.Iy);

      % Expected values
      rmin = L.ry(find(any(Opy,1),1,'first'));
      rmax = L.ry(find(any(Opy,1),1,'last'));
      zmin = L.zy(find(any(Opy,2),1,'first'));
      zmax = L.zy(find(any(Opy,2),1,'last'));
      B_ = [zmin,rmin,zmax,rmax];

      % test vs mex/mexm
      B = feval(method,Opy,L.zy,L.ry);

      testCase.verifyEqual(B,B_,sprintf('%s results do not match expected values',method));

    end
  end

end