classdef asxymex_jacobian_test < meq_jacobian_test
  % test the different terms of the analytical jacobian w.r.t jacobian
  % calculated by finite differences. Analytical tokamak parameters are
  % used as reference.
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
    
  properties
    verbosity = 0;
    tok = 'ana';
  end
    
  properties(ClassSetupParameter)
    shot = struct('circular',1,'diverted',2,'diverted2',3,'squashed',5,...
        meq_jacobian_test.doublets_under_test{:});
  end

  properties (TestParameter)
    convergence_test = struct('false',false,'true',true);
  end
  
  methods(TestClassSetup, ParameterCombination='sequential')
    function get_LLX(testCase,shot)
      % Compute FGS initial guess (FBT solution)
      t = 0;
      testCase.get_fgs_LLX(shot,t);
    end
  end
      
  methods(Test,TestTags={'Jacobian'})
    function test_extremum_jacobian(testCase,convergence_test)

      L = testCase.L;
      Fx = testCase.LX.Fx;

      % Prepare arguments
      fun = @asxymex;
      x0 = {Fx,L.G.zx,L.G.rx,L.P.dasm,L.dzx,L.drx,L.idzx,L.idrx,L.Oasx,L.dimw};

      % Compute jacobians
      [~,~,~,~,~,~,ixA,~,~,~,~,~,~,ixX,~] = fun(x0{:});
      
      % F0 sizes
      nA = numel(ixA);
      nX = numel(ixX);

      szF0 = [repmat({nA},1,7),repmat({nX},1,7)];

      % Compute other jacobians for axes
      [dFAdFx , dzAdFx , drAdFx , ddz2FAdFx , ddr2FAdFx , ddrzFAdFx ] = ...
        asxyJac(Fx, L.dzx, L.drx, L.idzx, L.idrx, ixA);

      % Compute other jacobians for saddle points
      [dFXdFx , dzXdFx , drXdFx , ddz2FXdFx , ddr2FXdFx , ddrzFXdFx ] = ...
        asxyJac(Fx, L.dzx, L.drx, L.idzx, L.idrx, ixX);

      % Check position, flux, hessian and stencils
      names_out = {'zA','rA','FA','dz2FA','dr2FA','drzFA',...
                   'zX','rX','FX','dz2FX','dr2FX','drzFX'};
      iargout = [1:6,8:13];
      names_in = {'Fx'};
      iargin = 1;
      
      J0 = {dzAdFx;drAdFx;dFAdFx;ddz2FAdFx;ddr2FAdFx;ddrzFAdFx;...
            dzXdFx;drXdFx;dFXdFx;ddz2FXdFx;ddr2FXdFx;ddrzFXdFx};
      
      jacfd_args = {'szF0',szF0};

      if convergence_test
        % Test convergence
        epsval = {testCase.meshDeltaFx};

        % Skip convergence of hessian, since precision on it is quite poor
        % (evaluated through comparison of close numbers)
        mask = [1:3,7:9];
        names_out = names_out(mask);
        iargout = iargout(mask);
        J0 = J0(mask,:);
      else
        % Test baseline error
        epsval = {testCase.deltaFx};
      end
      % Call generic function
      testCase.test_analytical_jacobian(...
        fun,x0,J0,jacfd_args,iargout,names_out,iargin,names_in,epsval);
    end
  end
end
