classdef argout_test < meq_test
  % tests for custom output arguments
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    L
    LX
  end
  
  properties (TestParameter)
    code = {'liu','lih','fbt','fgs','fge','bde'}
  end
 
  methods (TestClassSetup)
    function setLLX(testCase)
      [testCase.L,testCase.LX] = liu('ana',1);
    end
  end
 
  methods (Test, TestTags={'Integration'})
    function basic_argout(testCase,code)
      % Basic test
      tok = 'ana'; shot = 1;
      switch code
        case 'liu'
          LY = liut(testCase.L,testCase.LX,'argout','kit');
          testCase.verifyNumElements(LY.kit,numel(LY.t));
        case 'lih'
          Lh = lih(tok,shot,[]);
          LY = liht(Lh,testCase.LX,'argout','Jh');
          testCase.verifyNumElements(LY.Jh,Lh.nh);
        case 'fbt'
          [~,~,LY] = fbt(tok,shot,[],'argout','RaUt');
          testCase.verifyTrue(isfield(LY,'RaUt'));
        case 'fgs'
          [~,~,LY] = fgs(tok,shot,[],'argout','x0');
          testCase.verifyTrue(isfield(LY,'x0'));
        case 'fge'
          [~,~,LY] = fge(tok,shot,(0:1)*1e-4,'argout','fgeF:sIp');
          testCase.verifyTrue(isfield(LY,'sIp'));
        case 'bde'
          [Le,~,LY] = fge(tok,shot,(0:1)*1e-4);
          LY = bdet(Le,LY,'argout','sIp');
          testCase.verifyTrue(isfield(LY,'sIp'));
      end
    end
    
    function expr_argout(testCase)
      % Expression test
      LY = liut(testCase.L,testCase.LX,'argout','rat1=LYt.Wk./LYt.bp');
      testCase.verifyEqual(LY.rat1,LY.Wk./LY.bp);
    end
    
    function several_argout(testCase)
      % Several outputs test
      LY = liut(testCase.L,testCase.LX,'argout',{'Wk2=LYt.Wk*2','r=LYt.rA'});
      testCase.verifyEqual(LY.Wk2,LY.Wk*2);
      testCase.verifyEqual(LY.r,LY.rA,'RelTol',1e-6);
    end
    
    function file_argout(testCase)
      % Output with filename
      Ll = liu('ana',1,[],'iterq',20,'argout',{'meqpost:rp=rY','meqpostq:rO'});
      LY = liut(Ll,testCase.LX);
      testCase.verifyTrue(all(isfield(LY,{'rp','rO'})));
    end
    
    function unsupported_file_argout(testCase)
      % Output with filename
      testCase.verifyError(@() liut(testCase.L,testCase.LX,'argout','meqplott:ax'),...
        'meqargoutc:unsupportedFile');
    end
  end
 
end
