classdef Iy_jacobian_test < meq_jacobian_test
% Test the convergence of dIydIy and dIydIe
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    verbosity = 0;
    tok = 'ana';
  end

  properties (TestParameter)
    shot = struct('circular',1,'diverted',2,'diverted2',3,'squashed',5,...
      meq_jacobian_test.doublets_under_test{:});
    icsint = struct('false',false,'true',true);
    convergence_test = struct('false',false,'true',true);
  end

  methods(Test,TestTags={'Jacobian'})
    function test_dIydFx_jacobian(testCase,shot,icsint,convergence_test)

      % Do not run convergence test with cubic-spline interpolation
      testCase.assumeTrue(~icsint || ~convergence_test, 'Skipping convergence test with icsint=true')

      % Cubic-spline interpolation parameters
      PP = {};
      if icsint
        PP = {'icsint',true,'ilim',3};
      end

      % compute a plasma equilibrium using fbt
      t = 0;
      [L,LX] = fgs(testCase.tok,shot,t,'debug',testCase.verbosity,PP{:});
      testCase.L  = L ;
      testCase.LX = LX;
 
      Fx  = LX.Fx;
      ag  = LX.ag;
      sIp = sign(LX.Ip);

      % Prepare arguments
      fun = @Fx2Iy;
      x0 = {L,Fx,ag,sIp};

      % F0 sizes
      szF0 = {L.ny};

      % compute the analytical jacobians
      [~,dIydFx] = fun(x0{:});

      % Check the single Iy2Iy output
      names_out = {'Iy'};
      iargout = 1;
      names_in = {'Fx'};
      iargin = 2;
      J0 = {dIydFx};

      jacfd_args = {'szF0',szF0};

      if convergence_test
        % Test convergence
        epsval = {testCase.meshDeltaFx};
      else
        % Test baseline error
        epsval = {testCase.deltaFx};
      end
      % Call generic function
      testCase.test_analytical_jacobian(...
        fun,x0,J0,jacfd_args,iargout,names_out,iargin,names_in,epsval);
    end
  end
end

function [Iy,dIydFx] = Fx2Iy(L,Fx,ag,sIp)
% FX2IY compute new Iy based on Fx/ag
%
% Based on bits of fgeF

% Identify plasma domains and axis/boundary fluxes
if nargout>1
  % with jacobians
  [~,~,~,~,~,~,~,~,~,~,~,~,...
    ~,~,~,~,~,Opy,F0,F1,~,~,~,dF0dFx,dF1dFx] = meqpdom(Fx,sIp,L.P.isaddl,L);
else
  % without jacobians
  [~,~,~,~,~,~,~,~,~,~,~,~,...
    ~,~,~,~,~,Opy,F0,F1] = meqpdom(Fx,sIp,L.P.isaddl,L);
end

% Compute new Iy
Tyg = L.bfct(1,L.bfp,Fx,F0,F1,Opy,L.ry,L.iry);
Iy = reshape(Tyg*ag,L.nzy,L.nry);

if nargout>1
  % compute jacobians
  [dTygdFy,dTygdF0,dTygdF1] = L.bfct(11,L.bfp,Fx,F0,F1,Opy,L.ry,L.iry);

  active_domains = int8(find(any(L.TDg.*ag.',1)));
  mask = ismember(Opy(:),active_domains);
  [~,~,~,dIypdFx] = meqIyJac(L,ag,mask,dTygdFy,dTygdF0,dTygdF1,dF0dFx,dF1dFx);
  if L.P.icsint
    dIydFx = zeros(L.ny,L.nx);
    dIydFx(mask,:) = dIypdFx;
  else
    dIydFx = dIypdFx;
  end
end
end
