function solverinfo=initsolverinfo(varargin)
% Initialize solverinfo
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
%% Parse inputs
for k = 1:2:length(varargin), solverinfo.(varargin{k}) = varargin{k+1}; end

%% defaults for solverinfo
D.isconverged = 0;
D.failed = 0;
D.niter = 0;
D.residual_max = inf;
D.res = inf;
D.residual_2norm = inf;
D.restarts = 0;
D.mkryl = 0;
D.nfeval = 0;
D.stopped_early = false;
D.prev_H = [];

for k = fieldnames(D)'
  if ~isfield(solverinfo,k{1}), solverinfo.(k{1}) = D.(k{1}); end
end

end