function [L_liu,LX_liu,LY_liu,L_fge,LX_fge,eqsource] = liuqe_doublet(shot,time,user_parameters,doplot)
% LIUQE_DOUBLET Reconstruction of TCV doublets
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin<4
  doplot = false;
end
meq_common_parameters = [{'gsxe',2,'izgrid',false},user_parameters];


eqsource = 'liu';
% Script to generate L,LX,LY structure to run fge from LIUQE with Newton method, and deal with multiple domains
npq = 11;
sela  = {'E', 'F', 'OH'};

Pbfp = {...
  'bfct',@bfgenD,...
  'bfp',{...
  @bfabmex, [0 1], [1;0;0];...
  @bfabmex, [0 1], [0;1;0];...
  @bfabmex, [0 1], [0;0;1]}...
  };

%Pbfp = {};

%% Compute equilibrium reconstruction for doublet
algoF = 'sqp';
switch algoF
  case 'picard'
    % The equilibrium is compute only for the first time slice
    inPar = liup_doublet('useSQP',false,'itert', 30, 'sela', sela, ...
      'iterfrz', 20, 'npq', npq, 'stabz', 1,'wdz',[0;0;Inf],...
      'wag',[0 0 1],...
      'psichco', 1e-10, 'infct',@qintmex,...
      Pbfp{:});
  case 'sqp'
    inPar = liup_doublet('useSQP',true,'sela',sela,Pbfp{:});
end

inPar = [inPar,meq_common_parameters];
[L_liu,LX_liu] = liu('tcv',shot,time,inPar{:});
LX_liu.t = time; % assign exact time to avoid rounding troubles

%% FGE equilibrium
tolF = 1e-8;
% mantle basis functions only for mantle, constrained to zero anyways
bfct = @bfgenD;
bfp = {...
  @bfsp, bfpsp([0, 1], [0, 0.5, 1], 'z'), [1;0;0]; ...
  @bfsp, bfpsp([0, 1], [0, 0.5, 1], 'z'), [0;1;0];...
  @bfsp, bfpsp([0, 1], [0,      1], 'z'), [1;1;1]};

%'cde', 'cde_ss_0D',...
% agcon = {
%   {'bp'}, ...
%   {'bp'}, ...
%   {'bp'},
%   };
%agcon = {{'Ip','qA'},{'Ip','qA'},{'Ip'}};
agcon = {{},{},{'ag'}};
bfct = L_liu.bfct; bfp = L_liu.bfp;
cde = 'cde_ss_0D'; %cde = 'cde_OhmTor_1D';
fge_params = {'agcon', agcon,...
  'idoublet', 1, 'tolF', tolF,...
  'ssinit',false,...
  'bfct',bfct,'bfp',bfp,...
  'sela',sela,...
  'cde',cde};
fge_params = [fge_params, meq_common_parameters];

L_fge = fge('tcv', shot, [], fge_params{:});

%%
for it = iround(LX_liu.t,10e-3) %1:numel(LX_liu.t)
  
  LXt_liu = meqxk(LX_liu,it);
  %%
  L_liu.P.wag = [0 0 Inf];
  LXt_liu.ag(3,1) = 0;
  L_liu = liuc(L_liu.P,L_liu.G);
  LY_liu = liut(L_liu,LXt_liu,'debugplot',0,'debug',0);
   
  if ~LY_liu.isconverged
    fprintf('no liu convergence at t=%5.4f\n',LXt_liu.t);
    %continue
  end
  disp(LY_liu.IpD/1e3);
  
  if doplot
    clf;
    subplot(121)
    meqplott(L_liu,LY_liu);
    subplot(122)
    imagesc(L_liu.ry,L_liu.zy,LY_liu.Iy); axis xy equal;
    drawnow;
  end
  %%
  LX_fge = meqxconvert(L_liu, LY_liu, L_fge);
  
  %%
  try
    L_fge.P.debug=2;
    LX_fge = fgex('tcv', [], L_fge, LX_fge);
  catch
    fprintf('no FGS convergence at t=%5.4f\n',LXt_liu.t)
    continue
  end
  L_fge = fgel(L_fge,LX_fge);
  
  Ei = fgeeig(L_fge);
  fprintf('t=%4.4f, Ei=%+4.3f Ip=%3fkA\n',LX_fge.t,Ei(1),LY_liu.Ip/1e3);
  
  EEi(:,it) = Ei;
  %%
  if doplot
    clf;
    meqcompare(L_liu,LY_liu,LX_fge)
    subplot(121)
    title(sprintf('TCV %d %4.1fms Ip=%3.0fkA',shot,LY_liu.t*1e3,LY_liu.Ip/1e3))
    
    subplot(133);
    fgeploteig(L_fge)
    drawnow;
  end
end
