% Simple script to test fgs with analytical jacobian
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

for method = {'sim','giv','aya'}
  
  [L,LX] = fgs('ana',2,0, ...
               'tol',1e-4, ...
               'tolF',1e-10, ...
               'gsxe',3, ...
               'agcon',{'Ip','bp','qA'}, ...
               'algoF','jfnk', ...
               'algoGMRES',method{1}, ...
               'anajac',true, ...
               'usepreconditioner', false, ...
               'mkryl',150);
  
  LY = fgst(L,LX,'debug',2);

end
