function [psi,dpsidr,dpsidz,psirr,psirz,psizz,psirrr,psirrz,psirzz,psizzz] = GS_symbolic()
% Prints symbolic expressions for various derivatives of vacuum solution of GS equation
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

R = sym('R');
Z = sym('Z');
syms c1 c2 c3 c4 c5 d1 d2 d3 d4

psi =  c1 ...
        + c2*(R^2) ...
        + c3*(R^4 - 4*R^2.*Z^2) ...
        + c4*(R^2.*log(R) - Z^2) ...
        + c5*(R^6 + 8*R^2*Z^4 - 12*R^4*Z^2) ...
        + d1*(Z) ...
        + d2*(R^2.*Z) ...
        + d3*(3*R^4*Z - 4*R^2*Z^3) ...
        + d4*(3*R^2*Z.*log(R) - Z^3);
 
dpsidr = diff(psi,'R');
dpsidz = diff(psi,'Z');

psirr = diff(dpsidr,'R');
psizz = diff(dpsidz,'Z');
psirz = diff(dpsidr,'Z');
%dpsizr = diff(dpsidz,'R'); % equal to psirz, checked

psirrr = diff(psirr,'R');
psizzz = diff(psizz,'Z');
psirrz = diff(psirr,'Z');
psirzz = diff(psirz,'Z');

fprintf('psi: %s\n\n',psi);
fprintf('dpsidr: %s\n',dpsidr);
fprintf('dpsidz: %s\n\n',dpsidz);

fprintf('psirr: %s\n',psirr);
fprintf('psizz: %s\n',psizz);
fprintf('psirz: %s\n\n',psirz);

fprintf('psirrr: %s\n',psirrr);
fprintf('psizzz: %s\n',psizzz);
fprintf('psirrz: %s\n',psirrz);
fprintf('psirzz: %s\n\n',psirzz);

end
