% Load RZP parameters, overloading FGEP.
% P = rzpp(P,...)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [P] = rzpp(P,varargin)

%% Default Parameters
D.algoNL = 'all-nl';
D.agcon = {'Ip','bp','li'};  % residual function(s) for basis function coeff constraints (see help meqagcon)
D.lin   = true; % run linearized version (the only one present)
D.anajac = true; % Use analytical jacobian
D.usepreconditioner = false; % Do not use preconditioner

%Fast calculation parameters
D.rzpfast   = false; %fast calculation flag
D.gritermax  = int32(100); %maximum number of iterations for the fast growth rate calculation
D.grtol      = 1.e-4; %tolerance for the fast growth rate calculation
D.eigitermax = int32(100); %maximum number of iterations for the fast eigenvector calculation
D.eigtol     = 1.e-4; %tolerance for the fast eigenvector calculation
D.eigvinit   = []; %eigenvector starting assumption for the fast eigenvector calculation

%% Overwrites parameters from input and set defaults
for k = 1:2:numel(varargin), P.(varargin{k}) = varargin{k+1}; end
for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
end

P = fgep(P);

assert(strcmpi(P.algoNL,'all-nl'),'rzp only supports algoNL=all-nl');

end