function [L] = rzpl(L,LX)
% RZP linearization around initial equilibrium guess LX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

assert(nargin==2,'not enough input arguments');

L = fgel(L,LX);

lin = L.lin;

%% Store linearization points
lin.ag = [LX.Ip,LX.rIp./LX.Ip,LX.zIp./LX.Ip]; %expansion parameters for Iy in rzip are [Ip,Rc,Zc]

Bz = L.Bzye*lin.Ie;
Gamma0 = -4*pi*L.rry(:)'.*LX.Iy(:)'*Bz(:)/(mu0*lin.Ip^2);
%definition from A. Coutlis, Nucl. Fusion, vol. 39, no. 5, pp. 663-683, 1999.
%Linked to the same paper definition of Gamma0 in rzpFlin
lin.Lp = mu0*(lin.rIp/lin.Ip)*(Gamma0-0.5-lin.bp);

L.lin = lin;