function [dzmax] = rzpfastdzmax(Kinv,b,alpha,beta,gamma,v,w,Ainv,Va,Ia,Le,ne,bea,Vsat,Iamax,Tps,na_sel)
%% [dzmax] = rzpfastdzmax(K,b,alpha,beta,gamma,v,w,Ainv,Va,Ia,Le,ne,bea,Vsat,Iamax,Tps,na_sel)
% Function to be mexified. It comprises the fast version for the
% calculation of the maximum vertical displacement for a given active
% circuit. The formula for the maximum displacement can be found in D.A.
% Humpreys et al 2009 Nucl. Fusion 49 115003. For the calculation of the
% maximum displacement, the A matrix, the growth rate and the unstable
% eigenvector must be calculated.
%
% Since it is circuit specific, different parameters for specific type of
% citcuit used must be specified:
% bea: column vector, Iedot = A*Ie + bea*Va with Va power supply voltage of the coil 
% circuit adopted for the calculation
% Vsat: number, saturation voltage of the power supply
% Tps: number, delay time response of the power supply to the vertical siplacement
% Le: number, auto inductance of the coil circuit
% Iamax: number, maximum current in the coil circuit
% na_sel: index of the corresponding coil circuit adopted in the vector Ia of
% active coil circuits
%
% An example of the use of the function and how to retrieve the matrix A
% from fgess follow:
%
% [L,LX] = rzp(tok,shot,t);
%
% %% Code parameters
% iter_max = 1000;
% tol = 1.e-6;
% w = [];
%
% %% Active circuit parameters (for FPS in this example)
% bea = [contains(L.G.dima,'G'); zeros(L.G.nu,1)];
% bea = L.Tee_fast'*bea; %coordinate transformation needed to suit the fast version
% Tps = 1.e-4;  %[s] delay time
% Vsat = 280;   %[V] 566 if in series, but 280 if in antiseriers
% Iamax = 1600; %[A] 2000 if in series, but 1600 if in antiseriers
% na_sel = find(contains(L.G.dima,'G'));
% La = L.Mee(L.na_sel,L.na_sel);
%
% [dzmax,A,gamma,v,dagdIe,L_seinv] = rzpfastdzmax(LX.Ia,LX.Iu,LX.Iy,LX.Ip,LX.rIp,...
%   L.N,L.F,L.Re,L.Le,...
%   bea,Vsat,Tps,La,Iamax,na_sel,...
%   L.RBrye,L.RBzye,L.RBrye_fast,L.RBzye_fast,L.drx,L.dzx,L.ny,L.np,L.ne,L.icde,...
%   iter_max,tol,w);
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

 %#codegen
 %Calculate inverse of Lse = Mee + Xee and dZcdIe
 Lseinv = (eye(ne) - beta*alpha*beta')/Le;
 dZcdIe = -Kinv(2,:)*b';
 
 %Take into account the current limits
 deltaVamax = abs(Va(na_sel) - Vsat);
 deltaIamax = abs(Ia(na_sel) - Iamax);
 Vmax = deltaIamax/(bea'*Ainv*Lseinv*bea);
 Vmax = min(abs(Vmax),abs(deltaVamax));
 
 dzmax = abs(dZcdIe*(v*w')*Lseinv*bea*Vmax/gamma*exp(-gamma*Tps));
end